/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawDataPoint;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.data.zzf;
import com.google.android.gms.fitness.data.zzi;
import com.google.android.gms.internal.zzanm;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class DataSet
extends zza
implements ReflectedParcelable {
    private final int versionCode;
    private final DataSource zzaQJ;
    private final DataType zzaQI;
    private final List<DataPoint> zzaRi;
    private final List<DataSource> zzaRj;
    private boolean zzaRk = false;
    public static final Parcelable.Creator<DataSet> CREATOR = new zzi();

    DataSet(int n, DataSource dataSource, DataType dataType, List<RawDataPoint> list, List<DataSource> list2, boolean bl) {
        this.versionCode = n;
        this.zzaQJ = dataSource;
        this.zzaQI = dataSource.getDataType();
        this.zzaRk = bl;
        this.zzaRi = new ArrayList<DataPoint>(list.size());
        this.zzaRj = n >= 2 ? list2 : Collections.singletonList(dataSource);
        for (RawDataPoint rawDataPoint : list) {
            this.zzaRi.add(new DataPoint(this.zzaRj, rawDataPoint));
        }
    }

    public DataSet(DataSource dataSource) {
        this.versionCode = 3;
        this.zzaQJ = (DataSource)((Object)zzac.zzw((Object)((Object)dataSource)));
        this.zzaQI = dataSource.getDataType();
        this.zzaRi = new ArrayList<DataPoint>();
        this.zzaRj = new ArrayList<DataSource>();
        this.zzaRj.add(this.zzaQJ);
    }

    public DataSet(RawDataSet rawDataSet, List<DataSource> list) {
        this.versionCode = 3;
        this.zzaQJ = DataSet.zzd(list, rawDataSet.zzaTD);
        this.zzaQI = this.zzaQJ.getDataType();
        this.zzaRj = list;
        this.zzaRk = rawDataSet.zzaQZ;
        List<RawDataPoint> list2 = rawDataSet.zzaTI;
        this.zzaRi = new ArrayList<DataPoint>(list2.size());
        for (RawDataPoint rawDataPoint : list2) {
            this.zzaRi.add(new DataPoint(this.zzaRj, rawDataPoint));
        }
    }

    private static <T> T zzd(List<T> list, int n) {
        return n >= 0 && n < list.size() ? (T)list.get(n) : null;
    }

    public static DataSet create(DataSource dataSource) {
        zzac.zzb((Object)((Object)dataSource), (Object)"DataSource should be specified");
        return new DataSet(dataSource);
    }

    public DataPoint createDataPoint() {
        return DataPoint.create(this.zzaQJ);
    }

    public void add(DataPoint dataPoint) {
        DataSource dataSource = dataPoint.getDataSource();
        zzac.zzb((boolean)dataSource.getStreamIdentifier().equals(this.zzaQJ.getStreamIdentifier()), (String)"Conflicting data sources found %s vs %s", (Object[])new Object[]{dataSource, this.zzaQJ});
        dataPoint.zzBo();
        DataSet.zze(dataPoint);
        this.zzd(dataPoint);
    }

    public void zzd(DataPoint dataPoint) {
        this.zzaRi.add(dataPoint);
        DataSource dataSource = dataPoint.getOriginalDataSource();
        if (dataSource != null && !this.zzaRj.contains((Object)dataSource)) {
            this.zzaRj.add(dataSource);
        }
    }

    public void addAll(Iterable<DataPoint> iterable) {
        for (DataPoint dataPoint : iterable) {
            this.add(dataPoint);
        }
    }

    public void zzb(Iterable<DataPoint> iterable) {
        for (DataPoint dataPoint : iterable) {
            this.zzd(dataPoint);
        }
    }

    public DataSource getDataSource() {
        return this.zzaQJ;
    }

    public DataType getDataType() {
        return this.zzaQJ.getDataType();
    }

    public List<DataPoint> getDataPoints() {
        return Collections.unmodifiableList(this.zzaRi);
    }

    public boolean isEmpty() {
        return this.zzaRi.isEmpty();
    }

    public boolean zzBh() {
        return this.zzaRk;
    }

    public boolean equals(Object object) {
        return object == this || object instanceof DataSet && this.zza((DataSet)((Object)object));
    }

    private boolean zza(DataSet dataSet) {
        return zzaa.equal((Object)((Object)this.getDataType()), (Object)((Object)dataSet.getDataType())) && zzaa.equal((Object)((Object)this.zzaQJ), (Object)((Object)dataSet.zzaQJ)) && zzaa.equal(this.zzaRi, dataSet.zzaRi) && this.zzaRk == dataSet.zzaRk;
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.zzaQJ});
    }

    public String toString() {
        List<RawDataPoint> list = this.zzBq();
        return String.format("DataSet{%s %s}", this.zzaQJ.toDebugString(), this.zzaRi.size() < 10 ? list : String.format("%d data points, first 5: %s", this.zzaRi.size(), list.subList(0, 5)));
    }

    public static void zze(DataPoint dataPoint) throws IllegalArgumentException {
        String string = zzanm.zza(dataPoint, zzf.zzaRa);
        if (string != null) {
            String string2 = String.valueOf((Object)dataPoint);
            Log.w((String)"Fitness", (String)new StringBuilder(20 + String.valueOf(string2).length()).append("Invalid data point: ").append(string2).toString());
            throw new IllegalArgumentException(string);
        }
    }

    int getVersionCode() {
        return this.versionCode;
    }

    List<RawDataPoint> zzBq() {
        return this.zzA(this.zzaRj);
    }

    List<RawDataPoint> zzA(List<DataSource> list) {
        ArrayList<RawDataPoint> arrayList = new ArrayList<RawDataPoint>(this.zzaRi.size());
        for (DataPoint dataPoint : this.zzaRi) {
            arrayList.add(new RawDataPoint(dataPoint, list));
        }
        return arrayList;
    }

    List<DataSource> zzBr() {
        return this.zzaRj;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzi.zza(this, parcel, n);
    }
}

