/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.fitness.FitnessActivities;
import com.google.android.gms.fitness.data.zzab;
import com.google.android.gms.fitness.data.zzb;
import java.util.concurrent.TimeUnit;

public class Session
extends zza {
    public static final String EXTRA_SESSION = "vnd.google.fitness.session";
    public static final String MIME_TYPE_PREFIX = "vnd.google.fitness.session/";
    private final int mVersionCode;
    private final long zzaed;
    private final long zzaQV;
    private final String mName;
    private final String zzaTJ;
    private final String zzacd;
    private final int zzaQW;
    private final zzb zzaTK;
    private final Long zzaTL;
    public static final Parcelable.Creator<Session> CREATOR = new zzab();

    Session(int n, long l, long l2, String string, String string2, String string3, int n2, zzb zzb2, Long l3) {
        this.mVersionCode = n;
        this.zzaed = l;
        this.zzaQV = l2;
        this.mName = string;
        this.zzaTJ = string2;
        this.zzacd = string3;
        this.zzaQW = n2;
        this.zzaTK = zzb2;
        this.zzaTL = l3;
    }

    public Session(long l, long l2, String string, String string2, String string3, int n, zzb zzb2, Long l3) {
        this(3, l, l2, string, string2, string3, n, zzb2, l3);
    }

    private Session(Builder builder) {
        this(builder.zzaed, builder.zzaQV, builder.mName, builder.zzaTJ, builder.zzacd, builder.zzaQW, null, builder.zzaTL);
    }

    public static Session extract(Intent intent) {
        if (intent == null) {
            return null;
        }
        return (Session)zzd.zza((Intent)intent, (String)EXTRA_SESSION, CREATOR);
    }

    public static String getMimeType(String string) {
        String string2 = String.valueOf(MIME_TYPE_PREFIX);
        String string3 = String.valueOf(string);
        return string3.length() != 0 ? string2.concat(string3) : new String(string2);
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaed, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaQV, TimeUnit.MILLISECONDS);
    }

    public long getActiveTime(TimeUnit timeUnit) {
        zzac.zza((this.zzaTL != null ? 1 : 0) != 0, (Object)"Active time is not set");
        return timeUnit.convert(this.zzaTL, TimeUnit.MILLISECONDS);
    }

    public boolean hasActiveTime() {
        return this.zzaTL != null;
    }

    public boolean isOngoing() {
        return this.zzaQV == 0L;
    }

    public String getName() {
        return this.mName;
    }

    public String getIdentifier() {
        return this.zzaTJ;
    }

    public String getDescription() {
        return this.zzacd;
    }

    public String getActivity() {
        return FitnessActivities.getName(this.zzaQW);
    }

    public int zzBg() {
        return this.zzaQW;
    }

    public zzb zzBs() {
        return this.zzaTK;
    }

    public String getAppPackageName() {
        return this.zzaTK == null ? null : this.zzaTK.getPackageName();
    }

    public boolean equals(Object object) {
        return object == this || object instanceof Session && this.zza((Session)((Object)object));
    }

    private boolean zza(Session session) {
        return this.zzaed == session.zzaed && this.zzaQV == session.zzaQV && zzaa.equal((Object)this.mName, (Object)session.mName) && zzaa.equal((Object)this.zzaTJ, (Object)session.zzaTJ) && zzaa.equal((Object)this.zzacd, (Object)session.zzacd) && zzaa.equal((Object)((Object)this.zzaTK), (Object)((Object)session.zzaTK)) && this.zzaQW == session.zzaQW;
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.zzaed, this.zzaQV, this.zzaTJ});
    }

    public String toString() {
        return zzaa.zzv((Object)((Object)this)).zzg("startTime", (Object)this.zzaed).zzg("endTime", (Object)this.zzaQV).zzg("name", (Object)this.mName).zzg("identifier", (Object)this.zzaTJ).zzg("description", (Object)this.zzacd).zzg("activity", (Object)this.zzaQW).zzg("application", (Object)this.zzaTK).toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public long zzpN() {
        return this.zzaed;
    }

    public long zzzx() {
        return this.zzaQV;
    }

    public Long zzBJ() {
        return this.zzaTL;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzab.zza(this, parcel, n);
    }

    public static class Builder {
        private long zzaed = 0L;
        private long zzaQV = 0L;
        private String mName = null;
        private String zzaTJ;
        private String zzacd;
        private int zzaQW = 4;
        private Long zzaTL;

        public Builder setStartTime(long l, TimeUnit timeUnit) {
            zzac.zza((l > 0L ? 1 : 0) != 0, (Object)"Start time should be positive.");
            this.zzaed = timeUnit.toMillis(l);
            return this;
        }

        public Builder setEndTime(long l, TimeUnit timeUnit) {
            zzac.zza((l >= 0L ? 1 : 0) != 0, (Object)"End time should be positive.");
            this.zzaQV = timeUnit.toMillis(l);
            return this;
        }

        public Builder setName(String string) {
            zzac.zzb((string.length() <= 100 ? 1 : 0) != 0, (String)"Session name cannot exceed %d characters", (Object[])new Object[]{100});
            this.mName = string;
            return this;
        }

        public Builder setIdentifier(String string) {
            zzac.zzas((string != null && TextUtils.getTrimmedLength((CharSequence)string) > 0 ? 1 : 0) != 0);
            this.zzaTJ = string;
            return this;
        }

        public Builder setDescription(String string) {
            zzac.zzb((string.length() <= 1000 ? 1 : 0) != 0, (String)"Session description cannot exceed %d characters", (Object[])new Object[]{1000});
            this.zzacd = string;
            return this;
        }

        public Builder setActivity(String string) {
            return this.zzgM(FitnessActivities.zzdY(string));
        }

        public Builder zzgM(int n) {
            this.zzaQW = n;
            return this;
        }

        public Builder setActiveTime(long l, TimeUnit timeUnit) {
            this.zzaTL = timeUnit.toMillis(l);
            return this;
        }

        public Session build() {
            zzac.zza((this.zzaed > 0L ? 1 : 0) != 0, (Object)"Start time should be specified.");
            zzac.zza((this.zzaQV == 0L || this.zzaQV > this.zzaed ? 1 : 0) != 0, (Object)"End time should be later than start time.");
            if (this.zzaTJ == null) {
                String string = this.mName == null ? "" : this.mName;
                long l = this.zzaed;
                this.zzaTJ = new StringBuilder(20 + String.valueOf(string).length()).append(string).append(l).toString();
            }
            if (this.zzacd == null) {
                this.zzacd = "";
            }
            return new Session(this);
        }
    }
}

