/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.util.zzm;
import com.google.android.gms.fitness.FitnessActivities;
import com.google.android.gms.fitness.data.MapValue;
import com.google.android.gms.fitness.data.zzaf;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public final class Value
extends zza {
    private final int versionCode;
    private final int format;
    private boolean zzaTP;
    private float value;
    private String zzaFy;
    private Map<String, MapValue> zzaTQ;
    private int[] zzaTR;
    private float[] zzaTS;
    private byte[] zzaTT;
    public static final Parcelable.Creator<Value> CREATOR = new zzaf();

    public Value(int n) {
        this(3, n, false, 0.0f, null, null, null, null, null);
    }

    Value(int n, int n2, boolean bl, float f, String string, Bundle bundle, int[] nArray, float[] fArray, byte[] byArray) {
        this.versionCode = n;
        this.format = n2;
        this.zzaTP = bl;
        this.value = f;
        this.zzaFy = string;
        this.zzaTQ = Value.zzB(bundle);
        this.zzaTR = nArray;
        this.zzaTS = fArray;
        this.zzaTT = byArray;
    }

    public void setInt(int n) {
        zzac.zza((this.format == 1 ? 1 : 0) != 0, (Object)"Attempting to set an int value to a field that is not in INT32 format.  Please check the data type definition and use the right format.");
        this.zzaTP = true;
        this.value = Float.intBitsToFloat(n);
    }

    public void setFloat(float f) {
        zzac.zza((this.format == 2 ? 1 : 0) != 0, (Object)"Attempting to set an float value to a field that is not in FLOAT format.  Please check the data type definition and use the right format.");
        this.zzaTP = true;
        this.value = f;
    }

    public void setString(String string) {
        zzac.zza((this.format == 3 ? 1 : 0) != 0, (Object)"Attempting to set a string value to a field that is not in STRING format.  Please check the data type definition and use the right format.");
        this.zzaTP = true;
        this.zzaFy = string;
    }

    public void setKeyValue(String string, float f) {
        zzac.zza((this.format == 4 ? 1 : 0) != 0, (Object)"Attempting to set a key's value to a field that is not in FLOAT_MAP format.  Please check the data type definition and use the right format.");
        this.zzaTP = true;
        if (this.zzaTQ == null) {
            this.zzaTQ = new HashMap<String, MapValue>();
        }
        this.zzaTQ.put(string, MapValue.zzd(f));
    }

    public void clearKey(String string) {
        zzac.zza((this.format == 4 ? 1 : 0) != 0, (Object)"Attempting to set a key's value to a field that is not in FLOAT_MAP format.  Please check the data type definition and use the right format.");
        if (this.zzaTQ != null) {
            this.zzaTQ.remove(string);
        }
    }

    public void setActivity(String string) {
        this.setInt(FitnessActivities.zzdY(string));
    }

    public boolean isSet() {
        return this.zzaTP;
    }

    public int getFormat() {
        return this.format;
    }

    public int asInt() {
        zzac.zza((this.format == 1 ? 1 : 0) != 0, (Object)"Value is not in int format");
        return Float.floatToRawIntBits(this.value);
    }

    public float asFloat() {
        zzac.zza((this.format == 2 ? 1 : 0) != 0, (Object)"Value is not in float format");
        return this.value;
    }

    public String asString() {
        zzac.zza((this.format == 3 ? 1 : 0) != 0, (Object)"Value is not in string format");
        return this.zzaFy;
    }

    @Nullable
    public Float getKeyValue(String string) {
        zzac.zza((this.format == 4 ? 1 : 0) != 0, (Object)"Value is not in float map format");
        if (this.zzaTQ != null && this.zzaTQ.containsKey(string)) {
            return Float.valueOf(this.zzaTQ.get(string).asFloat());
        }
        return null;
    }

    public String asActivity() {
        return FitnessActivities.getName(this.asInt());
    }

    public boolean equals(Object object) {
        return this == object || object instanceof Value && this.zza((Value)((Object)object));
    }

    private boolean zza(Value value) {
        if (this.format == value.format && this.zzaTP == value.zzaTP) {
            switch (this.format) {
                case 1: {
                    return this.asInt() == value.asInt();
                }
                case 2: {
                    return this.value == value.value;
                }
                case 3: {
                    return zzaa.equal((Object)this.zzaFy, (Object)value.zzaFy);
                }
                case 4: {
                    return zzaa.equal(this.zzaTQ, value.zzaTQ);
                }
                case 5: {
                    return Arrays.equals(this.zzaTR, value.zzaTR);
                }
                case 6: {
                    return Arrays.equals(this.zzaTS, value.zzaTS);
                }
                case 7: {
                    return Arrays.equals(this.zzaTT, value.zzaTT);
                }
            }
            return this.value == value.value;
        }
        return false;
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{Float.valueOf(this.value), this.zzaFy, this.zzaTQ, this.zzaTR, this.zzaTS, this.zzaTT});
    }

    public String toString() {
        if (!this.zzaTP) {
            return "unset";
        }
        switch (this.format) {
            case 1: {
                return Integer.toString(this.asInt());
            }
            case 2: {
                return Float.toString(this.value);
            }
            case 3: {
                return this.zzaFy;
            }
            case 4: {
                return new TreeMap<String, MapValue>(this.zzaTQ).toString();
            }
            case 5: {
                return Arrays.toString(this.zzaTR);
            }
            case 6: {
                return Arrays.toString(this.zzaTS);
            }
            case 7: {
                return zzm.zza((byte[])this.zzaTT, (int)0, (int)this.zzaTT.length, (boolean)false);
            }
        }
        return "unknown";
    }

    int getVersionCode() {
        return this.versionCode;
    }

    float zzBI() {
        return this.value;
    }

    String zzBN() {
        return this.zzaFy;
    }

    Bundle zzBO() {
        if (this.zzaTQ == null) {
            return null;
        }
        Bundle bundle = new Bundle(this.zzaTQ.size());
        for (Map.Entry<String, MapValue> entry : this.zzaTQ.entrySet()) {
            bundle.putParcelable(entry.getKey(), (Parcelable)entry.getValue());
        }
        return bundle;
    }

    int[] zzBP() {
        return this.zzaTR;
    }

    float[] zzBQ() {
        return this.zzaTS;
    }

    byte[] zzBR() {
        return this.zzaTT;
    }

    private static Map<String, MapValue> zzB(Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        bundle.setClassLoader(MapValue.class.getClassLoader());
        ArrayMap arrayMap = new ArrayMap(bundle.size());
        for (String string : bundle.keySet()) {
            arrayMap.put(string, (MapValue)bundle.getParcelable(string));
        }
        return arrayMap;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzaf.zza(this, parcel, n);
    }
}

