/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.fitness.FitnessActivities;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.zzah;
import com.google.android.gms.internal.zzanh;
import com.google.android.gms.internal.zzaoe;
import java.util.ArrayList;
import java.util.List;

public class GoalsReadRequest
extends zza {
    private final int versionCode;
    private final zzaoe zzaVy;
    private final List<DataType> zzaVz;
    private final List<Integer> zzaVA;
    private final List<Integer> zzaSq;
    public static final Parcelable.Creator<GoalsReadRequest> CREATOR = new zzah();

    public List<DataType> getDataTypes() {
        return this.zzaVz;
    }

    public List<Integer> getObjectiveTypes() {
        return this.zzaVA.isEmpty() ? null : this.zzaVA;
    }

    public List<String> getActivityNames() {
        if (this.zzaSq.isEmpty()) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int n : this.zzaSq) {
            arrayList.add(FitnessActivities.getName(n));
        }
        return arrayList;
    }

    GoalsReadRequest(int n, IBinder iBinder, List<DataType> list, List<Integer> list2, List<Integer> list3) {
        this.versionCode = n;
        this.zzaVy = iBinder == null ? null : zzaoe.zza.zzcv(iBinder);
        this.zzaVz = list;
        this.zzaVA = list2;
        this.zzaSq = list3;
    }

    private GoalsReadRequest(Builder builder) {
        this(null, builder.zzaVz, builder.zzaVA, builder.zzaSq);
    }

    public GoalsReadRequest(GoalsReadRequest goalsReadRequest, zzaoe zzaoe2) {
        this(zzaoe2, goalsReadRequest.getDataTypes(), goalsReadRequest.zzCl(), goalsReadRequest.zzBD());
    }

    private GoalsReadRequest(zzaoe zzaoe2, List<DataType> list, List<Integer> list2, List<Integer> list3) {
        this(1, zzaoe2 == null ? null : zzaoe2.asBinder(), list, list2, list3);
    }

    public List<Integer> zzCl() {
        return this.zzaVA;
    }

    public List<Integer> zzBD() {
        return this.zzaSq;
    }

    public boolean equals(Object object) {
        return this == object || object instanceof GoalsReadRequest && this.zzb((GoalsReadRequest)((Object)object));
    }

    private boolean zzb(GoalsReadRequest goalsReadRequest) {
        return zzaa.equal(this.zzaVz, goalsReadRequest.zzaVz) && zzaa.equal(this.zzaVA, goalsReadRequest.zzaVA) && zzaa.equal(this.zzaSq, goalsReadRequest.zzaSq);
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.zzaVz, this.zzaVA, this.getActivityNames()});
    }

    public String toString() {
        return zzaa.zzv((Object)((Object)this)).zzg("dataTypes", this.zzaVz).zzg("objectiveTypes", this.zzaVA).zzg("activities", this.getActivityNames()).toString();
    }

    int getVersionCode() {
        return this.versionCode;
    }

    public IBinder getCallbackBinder() {
        return this.zzaVy.asBinder();
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzah.zza(this, parcel, n);
    }

    public static class Builder {
        private final List<DataType> zzaVz = new ArrayList<DataType>();
        private final List<Integer> zzaVA = new ArrayList<Integer>();
        private final List<Integer> zzaSq = new ArrayList<Integer>();

        public Builder addDataType(DataType dataType) {
            zzac.zzb((Object)((Object)dataType), (Object)"Attempting to use a null data type");
            if (!this.zzaVz.contains((Object)dataType)) {
                this.zzaVz.add(dataType);
            }
            return this;
        }

        public Builder addActivity(String string) {
            int n = FitnessActivities.zzdY(string);
            zzac.zza((n != 4 ? 1 : 0) != 0, (Object)"Attempting to add an unknown activity");
            zzanh.zza(n, this.zzaSq);
            return this;
        }

        public Builder addObjectiveType(int n) {
            zzac.zza((n == 1 || n == 2 || n == 3 ? 1 : 0) != 0, (Object)"Attempting to add an invalid objective type");
            if (!this.zzaVA.contains(n)) {
                this.zzaVA.add(n);
            }
            return this;
        }

        public GoalsReadRequest build() {
            zzac.zza((!this.zzaVz.isEmpty() ? 1 : 0) != 0, (Object)"At least one data type should be specified.");
            return new GoalsReadRequest(this);
        }
    }
}

