/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Field;
import com.google.android.gms.fitness.data.RawDataPoint;
import com.google.android.gms.fitness.data.Value;
import com.google.android.gms.fitness.data.zzh;
import com.google.android.gms.internal.zzant;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class DataPoint
extends zza
implements ReflectedParcelable {
    private final int versionCode;
    private final DataSource zzaSh;
    private long zzaSA;
    private long zzaSB;
    private final Value[] zzaSC;
    private DataSource zzaSD;
    private long zzaSE;
    private long zzaSF;
    public static final Parcelable.Creator<DataPoint> CREATOR = new zzh();

    DataPoint(int n, DataSource dataSource, long l, long l2, Value[] valueArray, DataSource dataSource2, long l3, long l4) {
        this.versionCode = n;
        this.zzaSh = dataSource;
        this.zzaSD = dataSource2;
        this.zzaSA = l;
        this.zzaSB = l2;
        this.zzaSC = valueArray;
        this.zzaSE = l3;
        this.zzaSF = l4;
    }

    DataPoint(List<DataSource> list, RawDataPoint rawDataPoint) {
        this(DataPoint.zzc(list, rawDataPoint.zzaUe), DataPoint.zzc(list, rawDataPoint.zzaUf), rawDataPoint);
    }

    public DataPoint(DataSource dataSource, DataSource dataSource2, RawDataPoint rawDataPoint) {
        this(4, dataSource, DataPoint.zza(rawDataPoint.zzaUb, 0L), DataPoint.zza(rawDataPoint.zzaUc, 0L), rawDataPoint.zzaUd, dataSource2, DataPoint.zza(rawDataPoint.zzaUg, 0L), DataPoint.zza(rawDataPoint.zzaUh, 0L));
    }

    private static DataSource zzc(List<DataSource> list, int n) {
        return n >= 0 && n < list.size() ? list.get(n) : null;
    }

    private DataPoint(DataSource dataSource) {
        this.versionCode = 4;
        this.zzaSh = (DataSource)((Object)zzac.zzb((Object)((Object)dataSource), (Object)"Data source cannot be null"));
        DataType dataType = dataSource.getDataType();
        List<Field> list = dataType.getFields();
        this.zzaSC = new Value[list.size()];
        int n = 0;
        for (Field field : list) {
            this.zzaSC[n] = new Value(field.getFormat());
            ++n;
        }
    }

    public static DataPoint create(DataSource dataSource) {
        return new DataPoint(dataSource);
    }

    public static DataPoint extract(Intent intent) {
        if (intent == null) {
            return null;
        }
        return (DataPoint)zzd.zza((Intent)intent, (String)"com.google.android.gms.fitness.EXTRA_DATA_POINT", CREATOR);
    }

    public DataPoint setTimestamp(long l, TimeUnit timeUnit) {
        this.zzaSA = timeUnit.toNanos(l);
        if (this.zzBZ() && zzant.zza(timeUnit)) {
            Log.w((String)"Fitness", (String)"Storing location at more than millisecond granularity is not supported. Extra precision is lost as the value is converted to milliseconds.");
            this.zzaSA = zzant.zza(this.zzaSA, TimeUnit.NANOSECONDS, TimeUnit.MILLISECONDS);
        }
        return this;
    }

    private boolean zzBZ() {
        return this.getDataType() == DataType.TYPE_LOCATION_SAMPLE;
    }

    public DataPoint setTimeInterval(long l, long l2, TimeUnit timeUnit) {
        this.zzaSB = timeUnit.toNanos(l);
        this.zzaSA = timeUnit.toNanos(l2);
        return this;
    }

    public Value zzgy(int n) {
        DataType dataType = this.getDataType();
        if (n < 0 || n >= dataType.getFields().size()) {
            throw new IllegalArgumentException(String.format("fieldIndex %s is out of range for %s", new Object[]{n, dataType}));
        }
        return this.zzaSC[n];
    }

    public Value getValue(Field field) {
        int n = this.getDataType().indexOf(field);
        return this.zzaSC[n];
    }

    public Value[] zzCa() {
        return this.zzaSC;
    }

    public DataPoint setFloatValues(float ... fArray) {
        this.zzgz(fArray.length);
        for (int i = 0; i < fArray.length; ++i) {
            this.zzaSC[i].setFloat(fArray[i]);
        }
        return this;
    }

    public DataPoint setIntValues(int ... nArray) {
        this.zzgz(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            this.zzaSC[i].setInt(nArray[i]);
        }
        return this;
    }

    private void zzgz(int n) {
        List<Field> list = this.getDataType().getFields();
        int n2 = list.size();
        zzac.zzb((n == n2 ? 1 : 0) != 0, (String)"Attempting to insert %s values, but needed %s: %s", (Object[])new Object[]{n, n2, list});
    }

    public DataType getDataType() {
        return this.zzaSh.getDataType();
    }

    public DataSource getDataSource() {
        return this.zzaSh;
    }

    public DataSource getOriginalDataSource() {
        return this.zzaSD != null ? this.zzaSD : this.zzaSh;
    }

    public DataSource zzCb() {
        return this.zzaSD;
    }

    public long getTimestamp(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaSA, TimeUnit.NANOSECONDS);
    }

    public long zzCc() {
        return this.zzaSE;
    }

    public long zzCd() {
        return this.zzaSF;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaSB, TimeUnit.NANOSECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaSA, TimeUnit.NANOSECONDS);
    }

    public void zzCe() {
        DataSource dataSource = this.getDataSource();
        zzac.zzb((boolean)this.getDataType().getName().equals(dataSource.getDataType().getName()), (String)"Conflicting data types found %s vs %s", (Object[])new Object[]{this.getDataType(), this.getDataType()});
        zzac.zzb((this.zzaSA > 0L ? 1 : 0) != 0, (String)"Data point does not have the timestamp set: %s", (Object[])new Object[]{this});
        zzac.zzb((this.zzaSB <= this.zzaSA ? 1 : 0) != 0, (String)"Data point with start time greater than end time found: %s", (Object[])new Object[]{this});
    }

    public boolean equals(Object object) {
        return this == object || object instanceof DataPoint && this.zzc((DataPoint)((Object)object));
    }

    private boolean zzc(DataPoint dataPoint) {
        return zzaa.equal((Object)((Object)this.zzaSh), (Object)((Object)dataPoint.zzaSh)) && this.zzaSA == dataPoint.zzaSA && this.zzaSB == dataPoint.zzaSB && Arrays.equals((Object[])this.zzaSC, (Object[])dataPoint.zzaSC) && zzaa.equal((Object)((Object)this.getOriginalDataSource()), (Object)((Object)dataPoint.getOriginalDataSource()));
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.zzaSh, this.zzaSA, this.zzaSB});
    }

    public String toString() {
        return String.format("DataPoint{%s@[%s, %s,raw=%s,insert=%s](%s %s)}", Arrays.toString((Object[])this.zzaSC), this.zzaSB, this.zzaSA, this.zzaSE, this.zzaSF, this.zzaSh.toDebugString(), this.zzaSD != null ? this.zzaSD.toDebugString() : "N/A");
    }

    public int getVersionCode() {
        return this.versionCode;
    }

    public long getTimestampNanos() {
        return this.zzaSA;
    }

    public long zzCf() {
        return this.zzaSB;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzh.zza(this, parcel, n);
    }

    private static long zza(Long l, long l2) {
        return l != null ? l : l2;
    }
}

