/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.fitness.data.zzo;
import com.google.android.gms.fitness.data.zzq;
import com.google.android.gms.fitness.data.zzr;
import com.google.android.gms.fitness.data.zzu;
import com.google.android.gms.fitness.data.zzy;
import com.google.android.gms.fitness.zza;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class Goal
extends com.google.android.gms.common.internal.safeparcel.zza {
    public static final int OBJECTIVE_TYPE_METRIC = 1;
    public static final int OBJECTIVE_TYPE_DURATION = 2;
    public static final int OBJECTIVE_TYPE_FREQUENCY = 3;
    private final int versionCode;
    private final long zzaTM;
    private final long zzaTN;
    private final List<Integer> zzaTO;
    private final Recurrence zzaTP;
    private final int zzaTQ;
    private final MetricObjective zzaTR;
    private final DurationObjective zzaTS;
    private final FrequencyObjective zzaTT;
    public static final Parcelable.Creator<Goal> CREATOR = new zzr();

    public long getCreateTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaTM, TimeUnit.NANOSECONDS);
    }

    public long getStartTime(Calendar calendar, TimeUnit timeUnit) {
        if (this.zzaTP != null) {
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTime(calendar.getTime());
            switch (this.zzaTP.zzaTX) {
                case 1: {
                    calendar2.set(11, 0);
                    return timeUnit.convert(calendar2.getTimeInMillis(), TimeUnit.MILLISECONDS);
                }
                case 2: {
                    calendar2.set(7, 2);
                    calendar2.set(11, 0);
                    return timeUnit.convert(calendar2.getTimeInMillis(), TimeUnit.MILLISECONDS);
                }
                case 3: {
                    calendar2.set(5, 1);
                    calendar2.set(11, 0);
                    return timeUnit.convert(calendar2.getTimeInMillis(), TimeUnit.MILLISECONDS);
                }
            }
            int n = this.zzaTP.zzaTX;
            throw new IllegalArgumentException(new StringBuilder(24).append("Invalid unit ").append(n).toString());
        }
        return timeUnit.convert(this.zzaTM, TimeUnit.NANOSECONDS);
    }

    public long getEndTime(Calendar calendar, TimeUnit timeUnit) {
        if (this.zzaTP != null) {
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTime(calendar.getTime());
            switch (this.zzaTP.zzaTX) {
                case 1: {
                    calendar2.add(5, 1);
                    calendar2.set(11, 0);
                    return timeUnit.convert(calendar2.getTimeInMillis(), TimeUnit.MILLISECONDS);
                }
                case 2: {
                    calendar2.add(4, 1);
                    calendar2.set(7, 2);
                    calendar2.set(11, 0);
                    return timeUnit.convert(calendar2.getTimeInMillis(), TimeUnit.MILLISECONDS);
                }
                case 3: {
                    calendar2.add(2, 1);
                    calendar2.set(5, 1);
                    calendar2.set(11, 0);
                    return timeUnit.convert(calendar2.getTimeInMillis(), TimeUnit.MILLISECONDS);
                }
            }
            int n = this.zzaTP.zzaTX;
            throw new IllegalArgumentException(new StringBuilder(24).append("Invalid unit ").append(n).toString());
        }
        return timeUnit.convert(this.zzaTN, TimeUnit.NANOSECONDS);
    }

    @Nullable
    public String getActivityName() {
        if (this.zzaTO.isEmpty() || this.zzaTO.size() > 1) {
            return null;
        }
        return zza.getName(this.zzaTO.get(0));
    }

    public Recurrence getRecurrence() {
        return this.zzaTP;
    }

    public int getObjectiveType() {
        return this.zzaTQ;
    }

    private static String zzgL(int n) {
        switch (n) {
            case 1: {
                return "metric";
            }
            case 2: {
                return "duration";
            }
            case 3: {
                return "frequency";
            }
            case 0: {
                return "unknown";
            }
        }
        throw new IllegalArgumentException("invalid objective type value");
    }

    public MetricObjective getMetricObjective() {
        this.zzgM(1);
        return this.zzaTR;
    }

    public DurationObjective getDurationObjective() {
        this.zzgM(2);
        return this.zzaTS;
    }

    public FrequencyObjective getFrequencyObjective() {
        this.zzgM(3);
        return this.zzaTT;
    }

    Goal(int n, long l, long l2, List<Integer> list, Recurrence recurrence, int n2, MetricObjective metricObjective, DurationObjective durationObjective, FrequencyObjective frequencyObjective) {
        this.versionCode = n;
        this.zzaTM = l;
        this.zzaTN = l2;
        this.zzaTO = list == null ? Collections.emptyList() : list;
        this.zzaTP = recurrence;
        this.zzaTQ = n2;
        this.zzaTR = metricObjective;
        this.zzaTS = durationObjective;
        this.zzaTT = frequencyObjective;
    }

    int getVersionCode() {
        return this.versionCode;
    }

    public long zzCq() {
        return this.zzaTM;
    }

    public long zzCr() {
        return this.zzaTN;
    }

    public List<Integer> zzCs() {
        return this.zzaTO;
    }

    public MetricObjective zzCt() {
        return this.zzaTR;
    }

    public DurationObjective zzCu() {
        return this.zzaTS;
    }

    public FrequencyObjective zzCv() {
        return this.zzaTT;
    }

    public boolean equals(Object object) {
        return this == object || object instanceof Goal && this.zza((Goal)((Object)object));
    }

    private boolean zza(Goal goal) {
        return this.zzaTM == goal.zzaTM && this.zzaTN == goal.zzaTN && zzaa.equal(this.zzaTO, goal.zzaTO) && zzaa.equal((Object)((Object)this.zzaTP), (Object)((Object)goal.zzaTP)) && this.zzaTQ == goal.zzaTQ && zzaa.equal((Object)((Object)this.zzaTR), (Object)((Object)goal.zzaTR)) && zzaa.equal((Object)((Object)this.zzaTS), (Object)((Object)goal.zzaTS)) && zzaa.equal((Object)((Object)this.zzaTT), (Object)((Object)goal.zzaTT));
    }

    public int hashCode() {
        return this.zzaTQ;
    }

    public String toString() {
        return zzaa.zzv((Object)((Object)this)).zzg("activity", (Object)this.getActivityName()).zzg("recurrence", (Object)this.zzaTP).zzg("metricObjective", (Object)this.zzaTR).zzg("durationObjective", (Object)this.zzaTS).zzg("frequencyObjective", (Object)this.zzaTT).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzr.zza(this, parcel, n);
    }

    private void zzgM(int n) throws MismatchedGoalException {
        if (n != this.zzaTQ) {
            throw new MismatchedGoalException(String.format("%s goal does not have %s objective", Goal.zzgL(this.zzaTQ), Goal.zzgL(n)));
        }
    }

    public static class MismatchedGoalException
    extends IllegalStateException {
        public MismatchedGoalException(String string) {
            super(string);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ObjectiveType {
    }

    public static class FrequencyObjective
    extends com.google.android.gms.common.internal.safeparcel.zza {
        private final int versionCode;
        private final int frequency;
        public static final Parcelable.Creator<FrequencyObjective> CREATOR = new zzq();

        public int getFrequency() {
            return this.frequency;
        }

        FrequencyObjective(int n, int n2) {
            this.versionCode = n;
            this.frequency = n2;
        }

        public FrequencyObjective(int n) {
            this(1, n);
        }

        int getVersionCode() {
            return this.versionCode;
        }

        public boolean equals(Object object) {
            return this == object || object instanceof FrequencyObjective && this.zza((FrequencyObjective)((Object)object));
        }

        private boolean zza(FrequencyObjective frequencyObjective) {
            return this.frequency == frequencyObjective.frequency;
        }

        public int hashCode() {
            return this.frequency;
        }

        public String toString() {
            return zzaa.zzv((Object)((Object)this)).zzg("frequency", (Object)this.frequency).toString();
        }

        public void writeToParcel(Parcel parcel, int n) {
            zzq.zza(this, parcel, n);
        }
    }

    public static class DurationObjective
    extends com.google.android.gms.common.internal.safeparcel.zza {
        private final int versionCode;
        private final long zzaTU;
        public static final Parcelable.Creator<DurationObjective> CREATOR = new zzo();

        public long getDuration(TimeUnit timeUnit) {
            return timeUnit.convert(this.zzaTU, TimeUnit.NANOSECONDS);
        }

        public long getDuration() {
            return this.zzaTU;
        }

        DurationObjective(int n, long l) {
            this.versionCode = n;
            this.zzaTU = l;
        }

        public DurationObjective(long l, TimeUnit timeUnit) {
            this(1, timeUnit.toNanos(l));
        }

        int getVersionCode() {
            return this.versionCode;
        }

        public boolean equals(Object object) {
            return this == object || object instanceof DurationObjective && this.zza((DurationObjective)((Object)object));
        }

        private boolean zza(DurationObjective durationObjective) {
            return this.zzaTU == durationObjective.zzaTU;
        }

        public int hashCode() {
            return (int)this.zzaTU;
        }

        public String toString() {
            return zzaa.zzv((Object)((Object)this)).zzg("duration", (Object)this.zzaTU).toString();
        }

        public void writeToParcel(Parcel parcel, int n) {
            zzo.zza(this, parcel, n);
        }
    }

    public static class MetricObjective
    extends com.google.android.gms.common.internal.safeparcel.zza {
        private final int versionCode;
        private final String zzaTV;
        private final double value;
        private final double zzaTW;
        public static final Parcelable.Creator<MetricObjective> CREATOR = new zzu();

        public String getDataTypeName() {
            return this.zzaTV;
        }

        public double getValue() {
            return this.value;
        }

        public double zzCw() {
            return this.zzaTW;
        }

        MetricObjective(int n, String string, double d, double d2) {
            this.versionCode = n;
            this.zzaTV = string;
            this.value = d;
            this.zzaTW = d2;
        }

        public MetricObjective(String string, double d) {
            this(1, string, d, 0.0);
        }

        int getVersionCode() {
            return this.versionCode;
        }

        public boolean equals(Object object) {
            return this == object || object instanceof MetricObjective && this.zza((MetricObjective)((Object)object));
        }

        private boolean zza(MetricObjective metricObjective) {
            return zzaa.equal((Object)this.zzaTV, (Object)metricObjective.zzaTV) && this.value == metricObjective.value && this.zzaTW == metricObjective.zzaTW;
        }

        public int hashCode() {
            return this.zzaTV.hashCode();
        }

        public String toString() {
            return zzaa.zzv((Object)((Object)this)).zzg("dataTypeName", (Object)this.zzaTV).zzg("value", (Object)this.value).zzg("initialValue", (Object)this.zzaTW).toString();
        }

        public void writeToParcel(Parcel parcel, int n) {
            zzu.zza(this, parcel, n);
        }
    }

    public static class Recurrence
    extends com.google.android.gms.common.internal.safeparcel.zza {
        public static final int UNIT_DAY = 1;
        public static final int UNIT_WEEK = 2;
        public static final int UNIT_MONTH = 3;
        private final int versionCode;
        private final int count;
        private final int zzaTX;
        public static final Parcelable.Creator<Recurrence> CREATOR = new zzy();

        public int getCount() {
            return this.count;
        }

        public int getUnit() {
            return this.zzaTX;
        }

        private static String zzgN(int n) {
            switch (n) {
                case 1: {
                    return "day";
                }
                case 2: {
                    return "week";
                }
                case 3: {
                    return "month";
                }
            }
            throw new IllegalArgumentException("invalid unit value");
        }

        Recurrence(int n, int n2, int n3) {
            this.versionCode = n;
            this.count = n2;
            zzac.zzaw((n3 > 0 && n3 <= 3 ? 1 : 0) != 0);
            this.zzaTX = n3;
        }

        public Recurrence(int n, int n2) {
            this(1, n, n2);
        }

        int getVersionCode() {
            return this.versionCode;
        }

        public boolean equals(Object object) {
            return this == object || object instanceof Recurrence && this.zza((Recurrence)((Object)object));
        }

        private boolean zza(Recurrence recurrence) {
            return this.count == recurrence.count && this.zzaTX == recurrence.zzaTX;
        }

        public int hashCode() {
            return this.zzaTX;
        }

        public String toString() {
            return zzaa.zzv((Object)((Object)this)).zzg("count", (Object)this.count).zzg("unit", (Object)Recurrence.zzgN(this.zzaTX)).toString();
        }

        public void writeToParcel(Parcel parcel, int n) {
            zzy.zza(this, parcel, n);
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface RecurrenceUnit {
        }
    }
}

