/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.util.zzn;
import com.google.android.gms.fitness.data.MapValue;
import com.google.android.gms.fitness.data.zzad;
import com.google.android.gms.fitness.zza;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public final class Value
extends com.google.android.gms.common.internal.safeparcel.zza {
    private final int versionCode;
    private final int format;
    private boolean zzaUq;
    private float value;
    private String zzaGV;
    private Map<String, MapValue> zzaUr;
    private int[] zzaUs;
    private float[] zzaUt;
    private byte[] zzaUu;
    public static final Parcelable.Creator<Value> CREATOR = new zzad();

    public Value(int n) {
        this(3, n, false, 0.0f, null, null, null, null, null);
    }

    Value(int n, int n2, boolean bl, float f, String string, Bundle bundle, int[] nArray, float[] fArray, byte[] byArray) {
        this.versionCode = n;
        this.format = n2;
        this.zzaUq = bl;
        this.value = f;
        this.zzaGV = string;
        this.zzaUr = Value.zzB(bundle);
        this.zzaUs = nArray;
        this.zzaUt = fArray;
        this.zzaUu = byArray;
    }

    public void setInt(int n) {
        zzac.zza((this.format == 1 ? 1 : 0) != 0, (Object)"Attempting to set an int value to a field that is not in INT32 format.  Please check the data type definition and use the right format.");
        this.zzaUq = true;
        this.value = Float.intBitsToFloat(n);
    }

    public void setFloat(float f) {
        zzac.zza((this.format == 2 ? 1 : 0) != 0, (Object)"Attempting to set an float value to a field that is not in FLOAT format.  Please check the data type definition and use the right format.");
        this.zzaUq = true;
        this.value = f;
    }

    public void setString(String string) {
        zzac.zza((this.format == 3 ? 1 : 0) != 0, (Object)"Attempting to set a string value to a field that is not in STRING format.  Please check the data type definition and use the right format.");
        this.zzaUq = true;
        this.zzaGV = string;
    }

    public void setKeyValue(String string, float f) {
        zzac.zza((this.format == 4 ? 1 : 0) != 0, (Object)"Attempting to set a key's value to a field that is not in FLOAT_MAP format.  Please check the data type definition and use the right format.");
        this.zzaUq = true;
        if (this.zzaUr == null) {
            this.zzaUr = new HashMap<String, MapValue>();
        }
        this.zzaUr.put(string, MapValue.zzd(f));
    }

    public void clearKey(String string) {
        zzac.zza((this.format == 4 ? 1 : 0) != 0, (Object)"Attempting to set a key's value to a field that is not in FLOAT_MAP format.  Please check the data type definition and use the right format.");
        if (this.zzaUr != null) {
            this.zzaUr.remove(string);
        }
    }

    public void setActivity(String string) {
        this.setInt(zza.zzdU(string));
    }

    public boolean isSet() {
        return this.zzaUq;
    }

    public int getFormat() {
        return this.format;
    }

    public int asInt() {
        zzac.zza((this.format == 1 ? 1 : 0) != 0, (Object)"Value is not in int format");
        return Float.floatToRawIntBits(this.value);
    }

    public float asFloat() {
        zzac.zza((this.format == 2 ? 1 : 0) != 0, (Object)"Value is not in float format");
        return this.value;
    }

    public String asString() {
        zzac.zza((this.format == 3 ? 1 : 0) != 0, (Object)"Value is not in string format");
        return this.zzaGV;
    }

    @Nullable
    public Float getKeyValue(String string) {
        zzac.zza((this.format == 4 ? 1 : 0) != 0, (Object)"Value is not in float map format");
        if (this.zzaUr != null && this.zzaUr.containsKey(string)) {
            return Float.valueOf(this.zzaUr.get(string).asFloat());
        }
        return null;
    }

    public String asActivity() {
        return zza.getName(this.asInt());
    }

    public boolean equals(Object object) {
        return this == object || object instanceof Value && this.zza((Value)((Object)object));
    }

    private boolean zza(Value value) {
        if (this.format == value.format && this.zzaUq == value.zzaUq) {
            switch (this.format) {
                case 1: {
                    return this.asInt() == value.asInt();
                }
                case 2: {
                    return this.value == value.value;
                }
                case 3: {
                    return zzaa.equal((Object)this.zzaGV, (Object)value.zzaGV);
                }
                case 4: {
                    return zzaa.equal(this.zzaUr, value.zzaUr);
                }
                case 5: {
                    return Arrays.equals(this.zzaUs, value.zzaUs);
                }
                case 6: {
                    return Arrays.equals(this.zzaUt, value.zzaUt);
                }
                case 7: {
                    return Arrays.equals(this.zzaUu, value.zzaUu);
                }
            }
            return this.value == value.value;
        }
        return false;
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{Float.valueOf(this.value), this.zzaGV, this.zzaUr, this.zzaUs, this.zzaUt, this.zzaUu});
    }

    public String toString() {
        if (!this.zzaUq) {
            return "unset";
        }
        switch (this.format) {
            case 1: {
                return Integer.toString(this.asInt());
            }
            case 2: {
                return Float.toString(this.value);
            }
            case 3: {
                return this.zzaGV;
            }
            case 4: {
                return new TreeMap<String, MapValue>(this.zzaUr).toString();
            }
            case 5: {
                return Arrays.toString(this.zzaUs);
            }
            case 6: {
                return Arrays.toString(this.zzaUt);
            }
            case 7: {
                return zzn.zza((byte[])this.zzaUu, (int)0, (int)this.zzaUu.length, (boolean)false);
            }
        }
        return "unknown";
    }

    int getVersionCode() {
        return this.versionCode;
    }

    float zzCx() {
        return this.value;
    }

    String zzCC() {
        return this.zzaGV;
    }

    Bundle zzCD() {
        if (this.zzaUr == null) {
            return null;
        }
        Bundle bundle = new Bundle(this.zzaUr.size());
        for (Map.Entry<String, MapValue> entry : this.zzaUr.entrySet()) {
            bundle.putParcelable(entry.getKey(), (Parcelable)entry.getValue());
        }
        return bundle;
    }

    int[] zzCE() {
        return this.zzaUs;
    }

    float[] zzCF() {
        return this.zzaUt;
    }

    byte[] zzCG() {
        return this.zzaUu;
    }

    private static Map<String, MapValue> zzB(Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        bundle.setClassLoader(MapValue.class.getClassLoader());
        ArrayMap arrayMap = new ArrayMap(bundle.size());
        for (String string : bundle.keySet()) {
            arrayMap.put(string, (MapValue)bundle.getParcelable(string));
        }
        return arrayMap;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzad.zza(this, parcel, n);
    }
}

