/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.fitness.data.Bucket;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Device;
import com.google.android.gms.fitness.request.zzi;
import com.google.android.gms.internal.zzaom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class DataReadRequest
extends zza {
    public static final int NO_LIMIT = 0;
    private final int zzaiI;
    private final List<DataType> zzaSs;
    private final List<DataSource> zzaVw;
    private final long zzafe;
    private final long zzaSt;
    private final List<DataType> zzaVB;
    private final List<DataSource> zzaVC;
    private final int zzaSw;
    private final long zzaVD;
    private final DataSource zzaVE;
    private final int zzaVF;
    private final boolean zzaVG;
    private final boolean zzaVH;
    private final zzaom zzaVI;
    private final List<Device> zzaVJ;
    private final List<Integer> zzaVK;
    public static final Parcelable.Creator<DataReadRequest> CREATOR = new zzi();

    DataReadRequest(int n, List<DataType> list, List<DataSource> list2, long l, long l2, List<DataType> list3, List<DataSource> list4, int n2, long l3, DataSource dataSource, int n3, boolean bl, boolean bl2, IBinder iBinder, List<Device> list5, List<Integer> list6) {
        this.zzaiI = n;
        this.zzaSs = list;
        this.zzaVw = list2;
        this.zzafe = l;
        this.zzaSt = l2;
        this.zzaVB = list3;
        this.zzaVC = list4;
        this.zzaSw = n2;
        this.zzaVD = l3;
        this.zzaVE = dataSource;
        this.zzaVF = n3;
        this.zzaVG = bl;
        this.zzaVH = bl2;
        this.zzaVI = iBinder == null ? null : zzaom.zza.zzcq(iBinder);
        this.zzaVJ = list5 == null ? Collections.emptyList() : list5;
        this.zzaVK = list6 == null ? Collections.emptyList() : list6;
    }

    private DataReadRequest(Builder builder) {
        this(builder.zzaSs, builder.zzaVw, builder.zzafe, builder.zzaSt, builder.zzaVB, builder.zzaVC, builder.zzaSw, builder.zzaVD, builder.zzaVE, builder.zzaVF, false, builder.zzaVH, null, builder.zzaVJ, builder.zzaVK);
    }

    public DataReadRequest(DataReadRequest dataReadRequest, zzaom zzaom2) {
        this(dataReadRequest.zzaSs, dataReadRequest.zzaVw, dataReadRequest.zzafe, dataReadRequest.zzaSt, dataReadRequest.zzaVB, dataReadRequest.zzaVC, dataReadRequest.zzaSw, dataReadRequest.zzaVD, dataReadRequest.zzaVE, dataReadRequest.zzaVF, dataReadRequest.zzaVG, dataReadRequest.zzaVH, zzaom2, dataReadRequest.zzaVJ, dataReadRequest.zzaVK);
    }

    public DataReadRequest(List<DataType> list, List<DataSource> list2, long l, long l2, List<DataType> list3, List<DataSource> list4, int n, long l3, DataSource dataSource, int n2, boolean bl, boolean bl2, zzaom zzaom2, List<Device> list5, List<Integer> list6) {
        this(6, list, list2, l, l2, list3, list4, n, l3, dataSource, n2, bl, bl2, zzaom2 == null ? null : zzaom2.asBinder(), list5, list6);
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzafe, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaSt, TimeUnit.MILLISECONDS);
    }

    public List<DataType> getDataTypes() {
        return this.zzaSs;
    }

    public List<DataSource> getDataSources() {
        return this.zzaVw;
    }

    public List<DataType> getAggregatedDataTypes() {
        return this.zzaVB;
    }

    public List<DataSource> getAggregatedDataSources() {
        return this.zzaVC;
    }

    public int getBucketType() {
        return this.zzaSw;
    }

    public long getBucketDuration(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaVD, TimeUnit.MILLISECONDS);
    }

    public DataSource getActivityDataSource() {
        return this.zzaVE;
    }

    public int getLimit() {
        return this.zzaVF;
    }

    public boolean zzCS() {
        return this.zzaVH;
    }

    public boolean zzCT() {
        return this.zzaVG;
    }

    public boolean equals(Object object) {
        return this == object || object instanceof DataReadRequest && this.zzb((DataReadRequest)((Object)object));
    }

    private boolean zzb(DataReadRequest dataReadRequest) {
        return this.zzaSs.equals(dataReadRequest.zzaSs) && this.zzaVw.equals(dataReadRequest.zzaVw) && this.zzafe == dataReadRequest.zzafe && this.zzaSt == dataReadRequest.zzaSt && this.zzaSw == dataReadRequest.zzaSw && this.zzaVC.equals(dataReadRequest.zzaVC) && this.zzaVB.equals(dataReadRequest.zzaVB) && zzaa.equal((Object)((Object)this.zzaVE), (Object)((Object)dataReadRequest.zzaVE)) && this.zzaVD == dataReadRequest.zzaVD && this.zzaVH == dataReadRequest.zzaVH && this.zzaVF == dataReadRequest.zzaVF && this.zzaVG == dataReadRequest.zzaVG && zzaa.equal((Object)this.zzaVI, (Object)dataReadRequest.zzaVI) && zzaa.equal(this.zzaVJ, dataReadRequest.zzaVJ) && zzaa.equal(this.zzaVK, dataReadRequest.zzaVK);
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.zzaSw, this.zzafe, this.zzaSt});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DataReadRequest{");
        if (!this.zzaSs.isEmpty()) {
            for (DataType zza2 : this.zzaSs) {
                stringBuilder.append(zza2.zzCk()).append(" ");
            }
        }
        if (!this.zzaVw.isEmpty()) {
            for (DataSource dataSource : this.zzaVw) {
                stringBuilder.append(dataSource.toDebugString()).append(" ");
            }
        }
        if (this.zzaSw != 0) {
            stringBuilder.append("bucket by ").append(Bucket.zzgw(this.zzaSw));
            if (this.zzaVD > 0L) {
                stringBuilder.append(" >").append(this.zzaVD).append("ms");
            }
            stringBuilder.append(": ");
        }
        if (!this.zzaVB.isEmpty()) {
            for (DataType dataType : this.zzaVB) {
                stringBuilder.append(dataType.zzCk()).append(" ");
            }
        }
        if (!this.zzaVC.isEmpty()) {
            for (DataSource dataSource : this.zzaVC) {
                stringBuilder.append(dataSource.toDebugString()).append(" ");
            }
        }
        stringBuilder.append(String.format("(%tF %tT - %tF %tT)", this.zzafe, this.zzafe, this.zzaSt, this.zzaSt));
        if (this.zzaVE != null) {
            stringBuilder.append("activities: ").append(this.zzaVE.toDebugString());
        }
        if (!this.zzaVK.isEmpty()) {
            stringBuilder.append("quality: ");
            Iterator<Object> iterator = this.zzaVK.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                stringBuilder.append(DataSource.zzgD(n)).append(" ");
            }
        }
        if (this.zzaVH) {
            stringBuilder.append(" +server");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    int getVersionCode() {
        return this.zzaiI;
    }

    public long zzAm() {
        return this.zzaSt;
    }

    public long zzqn() {
        return this.zzafe;
    }

    public long zzCU() {
        return this.zzaVD;
    }

    public IBinder getCallbackBinder() {
        return this.zzaVI == null ? null : this.zzaVI.asBinder();
    }

    public List<Device> zzCV() {
        return this.zzaVJ;
    }

    public List<Integer> getFilteredDataQualityStandards() {
        return this.zzaVK;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzi.zza(this, parcel, n);
    }

    public static class Builder {
        private List<DataType> zzaSs = new ArrayList<DataType>();
        private List<DataSource> zzaVw = new ArrayList<DataSource>();
        private List<DataType> zzaVB = new ArrayList<DataType>();
        private List<DataSource> zzaVC = new ArrayList<DataSource>();
        private DataSource zzaVE;
        private long zzafe;
        private long zzaSt;
        private int zzaSw = 0;
        private long zzaVD = 0L;
        private int zzaVF = 0;
        private boolean zzaVG = false;
        private boolean zzaVH = false;
        private final List<Device> zzaVJ = new ArrayList<Device>();
        private final List<Integer> zzaVK = new ArrayList<Integer>();

        public Builder read(DataSource dataSource) {
            zzac.zzb((Object)((Object)dataSource), (Object)"Attempting to add a null data source");
            zzac.zzb((!this.zzaVC.contains((Object)dataSource) ? 1 : 0) != 0, (Object)"Cannot add the same data source as aggregated and detailed");
            if (!this.zzaVw.contains((Object)dataSource)) {
                this.zzaVw.add(dataSource);
            }
            return this;
        }

        public Builder read(DataType dataType) {
            zzac.zzb((Object)((Object)dataType), (Object)"Attempting to use a null data type");
            zzac.zza((!this.zzaVB.contains((Object)dataType) ? 1 : 0) != 0, (Object)"Cannot add the same data type as aggregated and detailed");
            if (!this.zzaSs.contains((Object)dataType)) {
                this.zzaSs.add(dataType);
            }
            return this;
        }

        public Builder aggregate(DataSource dataSource, DataType dataType) {
            zzac.zzb((Object)((Object)dataSource), (Object)"Attempting to add a null data source");
            zzac.zza((!this.zzaVw.contains((Object)dataSource) ? 1 : 0) != 0, (Object)"Cannot add the same data source for aggregated and detailed");
            DataType dataType2 = dataSource.getDataType();
            List<DataType> list = DataType.getAggregatesForInput(dataType2);
            zzac.zzb((!list.isEmpty() ? 1 : 0) != 0, (String)"Unsupported input data type specified for aggregation: %s", (Object[])new Object[]{dataType2});
            zzac.zzb((boolean)list.contains((Object)dataType), (String)"Invalid output aggregate data type specified: %s -> %s", (Object[])new Object[]{dataType2, dataType});
            if (!this.zzaVC.contains((Object)dataSource)) {
                this.zzaVC.add(dataSource);
            }
            return this;
        }

        public Builder aggregate(DataType dataType, DataType dataType2) {
            zzac.zzb((Object)((Object)dataType), (Object)"Attempting to use a null data type");
            zzac.zza((!this.zzaSs.contains((Object)dataType) ? 1 : 0) != 0, (Object)"Cannot add the same data type as aggregated and detailed");
            List<DataType> list = DataType.getAggregatesForInput(dataType);
            zzac.zzb((!list.isEmpty() ? 1 : 0) != 0, (String)"Unsupported input data type specified for aggregation: %s", (Object[])new Object[]{dataType});
            zzac.zzb((boolean)list.contains((Object)dataType2), (String)"Invalid output aggregate data type specified: %s -> %s", (Object[])new Object[]{dataType, dataType2});
            if (!this.zzaVB.contains((Object)dataType)) {
                this.zzaVB.add(dataType);
            }
            return this;
        }

        public Builder bucketByTime(int n, TimeUnit timeUnit) {
            zzac.zzb((this.zzaSw == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzaSw});
            zzac.zzb((n > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{n});
            this.zzaSw = 1;
            this.zzaVD = timeUnit.toMillis(n);
            return this;
        }

        public Builder bucketByActivityType(int n, TimeUnit timeUnit) {
            zzac.zzb((this.zzaSw == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzaSw});
            zzac.zzb((n > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{n});
            this.zzaSw = 3;
            this.zzaVD = timeUnit.toMillis(n);
            return this;
        }

        public Builder bucketByActivityType(int n, TimeUnit timeUnit, DataSource dataSource) {
            zzac.zzb((this.zzaSw == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzaSw});
            zzac.zzb((n > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{n});
            zzac.zzb((dataSource != null ? 1 : 0) != 0, (Object)"Invalid activity data source specified");
            zzac.zzb((boolean)dataSource.getDataType().equals((Object)DataType.TYPE_ACTIVITY_SEGMENT), (String)"Invalid activity data source specified: %s", (Object[])new Object[]{dataSource});
            this.zzaVE = dataSource;
            this.zzaSw = 3;
            this.zzaVD = timeUnit.toMillis(n);
            return this;
        }

        public Builder addFilteredDataQualityStandard(int n) {
            zzac.zzb((boolean)this.zzaVJ.isEmpty(), (Object)"Cannot add data quality standard filter when filtering by device.");
            this.zzaVK.add(n);
            return this;
        }

        public Builder bucketByActivitySegment(int n, TimeUnit timeUnit) {
            zzac.zzb((this.zzaSw == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzaSw});
            zzac.zzb((n > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{n});
            this.zzaSw = 4;
            this.zzaVD = timeUnit.toMillis(n);
            return this;
        }

        public Builder bucketByActivitySegment(int n, TimeUnit timeUnit, DataSource dataSource) {
            zzac.zzb((this.zzaSw == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzaSw});
            zzac.zzb((n > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{n});
            zzac.zzb((dataSource != null ? 1 : 0) != 0, (Object)"Invalid activity data source specified");
            zzac.zzb((boolean)dataSource.getDataType().equals((Object)DataType.TYPE_ACTIVITY_SEGMENT), (String)"Invalid activity data source specified: %s", (Object[])new Object[]{dataSource});
            this.zzaVE = dataSource;
            this.zzaSw = 4;
            this.zzaVD = timeUnit.toMillis(n);
            return this;
        }

        public Builder bucketBySession(int n, TimeUnit timeUnit) {
            zzac.zzb((this.zzaSw == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzaSw});
            zzac.zzb((n > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{n});
            this.zzaSw = 2;
            this.zzaVD = timeUnit.toMillis(n);
            return this;
        }

        public Builder setTimeRange(long l, long l2, TimeUnit timeUnit) {
            this.zzafe = timeUnit.toMillis(l);
            this.zzaSt = timeUnit.toMillis(l2);
            return this;
        }

        public Builder enableServerQueries() {
            this.zzaVH = true;
            return this;
        }

        public Builder setLimit(int n) {
            zzac.zzb((n > 0 ? 1 : 0) != 0, (String)"Invalid limit %d is specified", (Object[])new Object[]{n});
            this.zzaVF = n;
            return this;
        }

        public DataReadRequest build() {
            zzac.zza((!this.zzaVw.isEmpty() || !this.zzaSs.isEmpty() || !this.zzaVC.isEmpty() || !this.zzaVB.isEmpty() ? 1 : 0) != 0, (Object)"Must add at least one data source (aggregated or detailed)");
            zzac.zza((this.zzafe > 0L ? 1 : 0) != 0, (String)"Invalid start time: %s", (Object[])new Object[]{this.zzafe});
            zzac.zza((this.zzaSt > 0L && this.zzaSt > this.zzafe ? 1 : 0) != 0, (String)"Invalid end time: %s", (Object[])new Object[]{this.zzaSt});
            boolean bl = this.zzaVC.isEmpty() && this.zzaVB.isEmpty();
            zzac.zza((bl && this.zzaSw == 0 || !bl && this.zzaSw != 0 ? 1 : 0) != 0, (Object)"Must specify a valid bucketing strategy while requesting aggregation");
            return new DataReadRequest(this);
        }
    }
}

