/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.fitness.data.Field;
import com.google.android.gms.fitness.request.zzm;
import com.google.android.gms.internal.zzaoo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DataTypeCreateRequest
extends zza {
    private final int zzaiI;
    private final String mName;
    private final List<Field> zzaVS;
    private final zzaoo zzaVT;
    public static final Parcelable.Creator<DataTypeCreateRequest> CREATOR = new zzm();

    DataTypeCreateRequest(int n, String string, List<Field> list, IBinder iBinder) {
        this.zzaiI = n;
        this.mName = string;
        this.zzaVS = Collections.unmodifiableList(list);
        this.zzaVT = zzaoo.zza.zzcs(iBinder);
    }

    private DataTypeCreateRequest(Builder builder) {
        this(builder.mName, builder.zzaVS, null);
    }

    public DataTypeCreateRequest(DataTypeCreateRequest dataTypeCreateRequest, zzaoo zzaoo2) {
        this(dataTypeCreateRequest.mName, dataTypeCreateRequest.zzaVS, zzaoo2);
    }

    public DataTypeCreateRequest(String string, List<Field> list, zzaoo zzaoo2) {
        this.zzaiI = 3;
        this.mName = string;
        this.zzaVS = Collections.unmodifiableList(list);
        this.zzaVT = zzaoo2;
    }

    public String getName() {
        return this.mName;
    }

    public List<Field> getFields() {
        return this.zzaVS;
    }

    public IBinder getCallbackBinder() {
        return this.zzaVT == null ? null : this.zzaVT.asBinder();
    }

    public boolean equals(Object object) {
        return object == this || object instanceof DataTypeCreateRequest && this.zzb((DataTypeCreateRequest)((Object)object));
    }

    private boolean zzb(DataTypeCreateRequest dataTypeCreateRequest) {
        return zzaa.equal((Object)this.mName, (Object)dataTypeCreateRequest.mName) && zzaa.equal(this.zzaVS, dataTypeCreateRequest.zzaVS);
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.mName, this.zzaVS});
    }

    public String toString() {
        return zzaa.zzv((Object)((Object)this)).zzg("name", (Object)this.mName).zzg("fields", this.zzaVS).toString();
    }

    int getVersionCode() {
        return this.zzaiI;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzm.zza(this, parcel, n);
    }

    public static class Builder {
        private String mName;
        private List<Field> zzaVS = new ArrayList<Field>();

        public Builder setName(String string) {
            this.mName = string;
            return this;
        }

        public Builder addField(Field field) {
            if (!this.zzaVS.contains((Object)field)) {
                this.zzaVS.add(field);
            }
            return this;
        }

        public Builder addField(String string, int n) {
            zzac.zzb((string != null && !string.isEmpty() ? 1 : 0) != 0, (Object)"Invalid name specified");
            Field field = Field.zzn(string, n);
            return this.addField(field);
        }

        public DataTypeCreateRequest build() {
            zzac.zza((this.mName != null ? 1 : 0) != 0, (Object)"Must set the name");
            zzac.zza((!this.zzaVS.isEmpty() ? 1 : 0) != 0, (Object)"Must specify the data fields");
            return new DataTypeCreateRequest(this);
        }
    }
}

