/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.request.zzaz;
import com.google.android.gms.internal.zzant;
import com.google.android.gms.internal.zzapf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SessionInsertRequest
extends zza {
    private final int versionCode;
    private final Session zzaWz;
    private final List<DataSet> zzaWA;
    private final List<DataPoint> zzaWB;
    private final zzapf zzaWh;
    public static final Parcelable.Creator<SessionInsertRequest> CREATOR = new zzaz();

    SessionInsertRequest(int n, Session session, List<DataSet> list, List<DataPoint> list2, IBinder iBinder) {
        this.versionCode = n;
        this.zzaWz = session;
        this.zzaWA = Collections.unmodifiableList(list);
        this.zzaWB = Collections.unmodifiableList(list2);
        this.zzaWh = zzapf.zza.zzcJ(iBinder);
    }

    private SessionInsertRequest(Builder builder) {
        this(builder.zzaWz, builder.zzaWA, builder.zzaWB, null);
    }

    public SessionInsertRequest(SessionInsertRequest sessionInsertRequest, zzapf zzapf2) {
        this(sessionInsertRequest.zzaWz, sessionInsertRequest.zzaWA, sessionInsertRequest.zzaWB, zzapf2);
    }

    public SessionInsertRequest(Session session, List<DataSet> list, List<DataPoint> list2, zzapf zzapf2) {
        this.versionCode = 3;
        this.zzaWz = session;
        this.zzaWA = Collections.unmodifiableList(list);
        this.zzaWB = Collections.unmodifiableList(list2);
        this.zzaWh = zzapf2;
    }

    public Session getSession() {
        return this.zzaWz;
    }

    public List<DataSet> getDataSets() {
        return this.zzaWA;
    }

    public List<DataPoint> getAggregateDataPoints() {
        return this.zzaWB;
    }

    public IBinder getCallbackBinder() {
        return this.zzaWh == null ? null : this.zzaWh.asBinder();
    }

    public boolean equals(Object object) {
        return object == this || object instanceof SessionInsertRequest && this.zzb((SessionInsertRequest)((Object)object));
    }

    private boolean zzb(SessionInsertRequest sessionInsertRequest) {
        return zzaa.equal((Object)((Object)this.zzaWz), (Object)((Object)sessionInsertRequest.zzaWz)) && zzaa.equal(this.zzaWA, sessionInsertRequest.zzaWA) && zzaa.equal(this.zzaWB, sessionInsertRequest.zzaWB);
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.zzaWz, this.zzaWA, this.zzaWB});
    }

    public String toString() {
        return zzaa.zzv((Object)((Object)this)).zzg("session", (Object)this.zzaWz).zzg("dataSets", this.zzaWA).zzg("aggregateDataPoints", this.zzaWB).toString();
    }

    int getVersionCode() {
        return this.versionCode;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzaz.zza(this, parcel, n);
    }

    public static class Builder {
        private Session zzaWz;
        private List<DataSet> zzaWA = new ArrayList<DataSet>();
        private List<DataPoint> zzaWB = new ArrayList<DataPoint>();
        private List<DataSource> zzaWC = new ArrayList<DataSource>();

        public Builder setSession(Session session) {
            this.zzaWz = session;
            return this;
        }

        public Builder addDataSet(DataSet dataSet) {
            zzac.zzb((dataSet != null ? 1 : 0) != 0, (Object)"Must specify a valid data set.");
            DataSource dataSource = dataSet.getDataSource();
            zzac.zza((!this.zzaWC.contains((Object)dataSource) ? 1 : 0) != 0, (String)"Data set for this data source %s is already added.", (Object[])new Object[]{dataSource});
            List<DataPoint> list = dataSet.getDataPoints();
            zzac.zzb((!list.isEmpty() ? 1 : 0) != 0, (Object)"No data points specified in the input data set.");
            this.zzaWC.add(dataSource);
            this.zzaWA.add(dataSet);
            return this;
        }

        public Builder addAggregateDataPoint(DataPoint dataPoint) {
            zzac.zzb((dataPoint != null ? 1 : 0) != 0, (Object)"Must specify a valid aggregate data point.");
            DataSource dataSource = dataPoint.getDataSource();
            zzac.zza((!this.zzaWC.contains((Object)dataSource) ? 1 : 0) != 0, (String)"Data set/Aggregate data point for this data source %s is already added.", (Object[])new Object[]{dataSource});
            DataSet.zze(dataPoint);
            this.zzaWC.add(dataSource);
            this.zzaWB.add(dataPoint);
            return this;
        }

        public SessionInsertRequest build() {
            zzac.zza((this.zzaWz != null ? 1 : 0) != 0, (Object)"Must specify a valid session.");
            zzac.zza((this.zzaWz.getEndTime(TimeUnit.MILLISECONDS) != 0L ? 1 : 0) != 0, (Object)"Must specify a valid end time, cannot insert a continuing session.");
            this.zzDj();
            return new SessionInsertRequest(this);
        }

        private void zzg(DataPoint dataPoint) {
            this.zzi(dataPoint);
            this.zzh(dataPoint);
        }

        private void zzh(DataPoint dataPoint) {
            long l = this.zzaWz.getStartTime(TimeUnit.NANOSECONDS);
            long l2 = this.zzaWz.getEndTime(TimeUnit.NANOSECONDS);
            long l3 = dataPoint.getStartTime(TimeUnit.NANOSECONDS);
            long l4 = dataPoint.getEndTime(TimeUnit.NANOSECONDS);
            if (l3 != 0L && l4 != 0L) {
                TimeUnit timeUnit = TimeUnit.MILLISECONDS;
                if (l4 > l2) {
                    l4 = zzant.zza(l4, TimeUnit.NANOSECONDS, timeUnit);
                }
                zzac.zza((l3 >= l && l4 <= l2 ? 1 : 0) != 0, (String)"Data point %s has start and end times outside session interval [%d, %d]", (Object[])new Object[]{dataPoint, l, l2});
                if (l4 != dataPoint.getEndTime(TimeUnit.NANOSECONDS)) {
                    Log.w((String)"Fitness", (String)String.format("Data point end time [%d] is truncated to [%d] to match the precision [%s] of the session start and end time", new Object[]{dataPoint.getEndTime(TimeUnit.NANOSECONDS), l4, timeUnit}));
                    dataPoint.setTimeInterval(l3, l4, TimeUnit.NANOSECONDS);
                }
            }
        }

        private void zzi(DataPoint dataPoint) {
            long l = this.zzaWz.getStartTime(TimeUnit.NANOSECONDS);
            long l2 = this.zzaWz.getEndTime(TimeUnit.NANOSECONDS);
            long l3 = dataPoint.getTimestamp(TimeUnit.NANOSECONDS);
            if (l3 != 0L) {
                TimeUnit timeUnit = TimeUnit.MILLISECONDS;
                if (l3 < l || l3 > l2) {
                    l3 = zzant.zza(l3, TimeUnit.NANOSECONDS, timeUnit);
                }
                zzac.zza((l3 >= l && l3 <= l2 ? 1 : 0) != 0, (String)"Data point %s has time stamp outside session interval [%d, %d]", (Object[])new Object[]{dataPoint, l, l2});
                if (dataPoint.getTimestamp(TimeUnit.NANOSECONDS) != l3) {
                    Log.w((String)"Fitness", (String)String.format("Data point timestamp [%d] is truncated to [%d] to match the precision [%s] of the session start and end time", new Object[]{dataPoint.getTimestamp(TimeUnit.NANOSECONDS), l3, timeUnit}));
                    dataPoint.setTimestamp(l3, TimeUnit.NANOSECONDS);
                }
            }
        }

        private void zzDj() {
            for (DataSet zza2 : this.zzaWA) {
                for (DataPoint dataPoint : zza2.getDataPoints()) {
                    this.zzg(dataPoint);
                }
            }
            for (DataPoint dataPoint : this.zzaWB) {
                this.zzg(dataPoint);
            }
        }
    }
}

