/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.zzba;
import com.google.android.gms.internal.zzapd;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SessionReadRequest
extends zza {
    private final int zzaiI;
    private final String zzaWD;
    private final String zzWD;
    private final long zzafe;
    private final long zzaSt;
    private final List<DataType> zzaSs;
    private final List<DataSource> zzaVw;
    private boolean zzaWE;
    private final boolean zzaVH;
    private final List<String> zzaWF;
    private final zzapd zzaWG;
    public static final Parcelable.Creator<SessionReadRequest> CREATOR = new zzba();

    SessionReadRequest(int n, String string, String string2, long l, long l2, List<DataType> list, List<DataSource> list2, boolean bl, boolean bl2, List<String> list3, IBinder iBinder) {
        this.zzaiI = n;
        this.zzaWD = string;
        this.zzWD = string2;
        this.zzafe = l;
        this.zzaSt = l2;
        this.zzaSs = list;
        this.zzaVw = list2;
        this.zzaWE = bl;
        this.zzaVH = bl2;
        this.zzaWF = list3;
        this.zzaWG = zzapd.zza.zzcH(iBinder);
    }

    private SessionReadRequest(Builder builder) {
        this(builder.zzaWD, builder.zzWD, builder.zzafe, builder.zzaSt, builder.zzaSs, builder.zzaVw, builder.zzaWE, builder.zzaVH, builder.zzaWF, null);
    }

    public SessionReadRequest(SessionReadRequest sessionReadRequest, zzapd zzapd2) {
        this(sessionReadRequest.zzaWD, sessionReadRequest.zzWD, sessionReadRequest.zzafe, sessionReadRequest.zzaSt, sessionReadRequest.zzaSs, sessionReadRequest.zzaVw, sessionReadRequest.zzaWE, sessionReadRequest.zzaVH, sessionReadRequest.zzaWF, zzapd2);
    }

    public SessionReadRequest(String string, String string2, long l, long l2, List<DataType> list, List<DataSource> list2, boolean bl, boolean bl2, List<String> list3, zzapd zzapd2) {
        this(5, string, string2, l, l2, list, list2, bl, bl2, list3, zzapd2 == null ? null : zzapd2.asBinder());
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzafe, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaSt, TimeUnit.MILLISECONDS);
    }

    public String getSessionName() {
        return this.zzaWD;
    }

    public String getSessionId() {
        return this.zzWD;
    }

    public List<DataType> getDataTypes() {
        return this.zzaSs;
    }

    public List<DataSource> getDataSources() {
        return this.zzaVw;
    }

    public boolean includeSessionsFromAllApps() {
        return this.zzaWE;
    }

    public List<String> getExcludedPackages() {
        return this.zzaWF;
    }

    public boolean zzCS() {
        return this.zzaVH;
    }

    public long zzAm() {
        return this.zzaSt;
    }

    public long zzqn() {
        return this.zzafe;
    }

    public boolean zzDk() {
        return this.zzaWE;
    }

    public IBinder getCallbackBinder() {
        return this.zzaWG == null ? null : this.zzaWG.asBinder();
    }

    public boolean equals(Object object) {
        return this == object || object instanceof SessionReadRequest && this.zzb((SessionReadRequest)((Object)object));
    }

    private boolean zzb(SessionReadRequest sessionReadRequest) {
        return zzaa.equal((Object)this.zzaWD, (Object)sessionReadRequest.zzaWD) && this.zzWD.equals(sessionReadRequest.zzWD) && this.zzafe == sessionReadRequest.zzafe && this.zzaSt == sessionReadRequest.zzaSt && zzaa.equal(this.zzaSs, sessionReadRequest.zzaSs) && zzaa.equal(this.zzaVw, sessionReadRequest.zzaVw) && this.zzaWE == sessionReadRequest.zzaWE && this.zzaWF.equals(sessionReadRequest.zzaWF) && this.zzaVH == sessionReadRequest.zzaVH;
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.zzaWD, this.zzWD, this.zzafe, this.zzaSt});
    }

    public String toString() {
        return zzaa.zzv((Object)((Object)this)).zzg("sessionName", (Object)this.zzaWD).zzg("sessionId", (Object)this.zzWD).zzg("startTimeMillis", (Object)this.zzafe).zzg("endTimeMillis", (Object)this.zzaSt).zzg("dataTypes", this.zzaSs).zzg("dataSources", this.zzaVw).zzg("sessionsFromAllApps", (Object)this.zzaWE).zzg("excludedPackages", this.zzaWF).zzg("useServer", (Object)this.zzaVH).toString();
    }

    int getVersionCode() {
        return this.zzaiI;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzba.zza(this, parcel, n);
    }

    public static class Builder {
        private String zzaWD;
        private String zzWD;
        private long zzafe = 0L;
        private long zzaSt = 0L;
        private List<DataType> zzaSs = new ArrayList<DataType>();
        private List<DataSource> zzaVw = new ArrayList<DataSource>();
        private boolean zzaWE = false;
        private boolean zzaVH = false;
        private List<String> zzaWF = new ArrayList<String>();

        public Builder setTimeInterval(long l, long l2, TimeUnit timeUnit) {
            this.zzafe = timeUnit.toMillis(l);
            this.zzaSt = timeUnit.toMillis(l2);
            return this;
        }

        public Builder setSessionName(String string) {
            this.zzaWD = string;
            return this;
        }

        public Builder setSessionId(String string) {
            this.zzWD = string;
            return this;
        }

        public Builder read(DataSource dataSource) {
            zzac.zzb((Object)((Object)dataSource), (Object)"Attempting to add a null data source");
            if (!this.zzaVw.contains((Object)dataSource)) {
                this.zzaVw.add(dataSource);
            }
            return this;
        }

        public Builder read(DataType dataType) {
            zzac.zzb((Object)((Object)dataType), (Object)"Attempting to use a null data type");
            if (!this.zzaSs.contains((Object)dataType)) {
                this.zzaSs.add(dataType);
            }
            return this;
        }

        public Builder readSessionsFromAllApps() {
            this.zzaWE = true;
            return this;
        }

        public Builder excludePackage(String string) {
            zzac.zzb((Object)string, (Object)"Attempting to use a null package name");
            if (!this.zzaWF.contains(string)) {
                this.zzaWF.add(string);
            }
            return this;
        }

        public Builder enableServerQueries() {
            this.zzaVH = true;
            return this;
        }

        public SessionReadRequest build() {
            zzac.zzb((this.zzafe > 0L ? 1 : 0) != 0, (String)"Invalid start time: %s", (Object[])new Object[]{this.zzafe});
            zzac.zzb((this.zzaSt > 0L && this.zzaSt > this.zzafe ? 1 : 0) != 0, (String)"Invalid end time: %s", (Object[])new Object[]{this.zzaSt});
            return new SessionReadRequest(this);
        }
    }
}

