/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.service;

import android.annotation.TargetApi;
import android.app.AppOpsManager;
import android.app.Service;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.CallSuper;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.util.zzt;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.result.DataSourcesResult;
import com.google.android.gms.fitness.service.FitnessSensorServiceRequest;
import com.google.android.gms.internal.zzaon;
import com.google.android.gms.internal.zzapf;
import com.google.android.gms.internal.zzapv;
import com.google.android.gms.internal.zzapx;
import com.google.android.gms.internal.zzapz;
import java.util.List;

public abstract class FitnessSensorService
extends Service {
    public static final String SERVICE_INTERFACE = "com.google.android.gms.fitness.service.FitnessSensorService";
    private zza zzaXg;

    @CallSuper
    public void onCreate() {
        super.onCreate();
        this.zzaXg = new zza(this);
    }

    @CallSuper
    public IBinder onBind(Intent intent) {
        if (SERVICE_INTERFACE.equals(intent.getAction())) {
            if (Log.isLoggable((String)"FitnessSensorService", (int)3)) {
                String string = String.valueOf(intent);
                String string2 = String.valueOf(((Object)((Object)this)).getClass().getName());
                Log.d((String)"FitnessSensorService", (String)new StringBuilder(20 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Intent ").append(string).append(" received by ").append(string2).toString());
            }
            return this.zzaXg.asBinder();
        }
        return null;
    }

    public abstract List<DataSource> onFindDataSources(List<DataType> var1);

    public abstract boolean onRegister(FitnessSensorServiceRequest var1);

    public abstract boolean onUnregister(DataSource var1);

    @TargetApi(value=19)
    protected void zzDB() throws SecurityException {
        int n = Binder.getCallingUid();
        if (zzt.zzzl()) {
            AppOpsManager appOpsManager = (AppOpsManager)this.getSystemService("appops");
            appOpsManager.checkPackage(n, "com.google.android.gms");
            return;
        }
        PackageManager packageManager = this.getPackageManager();
        String[] stringArray = packageManager.getPackagesForUid(n);
        if (stringArray != null) {
            for (String string : stringArray) {
                if (!string.equals("com.google.android.gms")) continue;
                return;
            }
        }
        throw new SecurityException("Unauthorized caller");
    }

    private static class zza
    extends zzapz.zza {
        private final FitnessSensorService zzaXh;

        private zza(FitnessSensorService fitnessSensorService) {
            this.zzaXh = fitnessSensorService;
        }

        @Override
        public void zza(zzapv zzapv2, zzaon zzaon2) throws RemoteException {
            this.zzaXh.zzDB();
            List<DataSource> list = this.zzaXh.onFindDataSources(zzapv2.getDataTypes());
            zzaon2.zza(new DataSourcesResult(list, Status.zzazx));
        }

        @Override
        public void zza(FitnessSensorServiceRequest fitnessSensorServiceRequest, zzapf zzapf2) throws RemoteException {
            this.zzaXh.zzDB();
            if (this.zzaXh.onRegister(fitnessSensorServiceRequest)) {
                zzapf2.zzp(Status.zzazx);
            } else {
                zzapf2.zzp(new Status(13));
            }
        }

        @Override
        public void zza(zzapx zzapx2, zzapf zzapf2) throws RemoteException {
            this.zzaXh.zzDB();
            if (this.zzaXh.onUnregister(zzapx2.getDataSource())) {
                zzapf2.zzp(Status.zzazx);
            } else {
                zzapf2.zzp(new Status(13));
            }
        }
    }
}

