/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawBucket;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.data.zze;
import com.google.android.gms.fitness.zza;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class Bucket
extends com.google.android.gms.common.internal.safeparcel.zza
implements ReflectedParcelable {
    public static final int TYPE_TIME = 1;
    public static final int TYPE_SESSION = 2;
    public static final int TYPE_ACTIVITY_TYPE = 3;
    public static final int TYPE_ACTIVITY_SEGMENT = 4;
    private final int zzaiI;
    private final long zzafe;
    private final long zzaSt;
    private final Session zzaSj;
    private final int zzaSu;
    private final List<DataSet> zzaSv;
    private final int zzaSw;
    private boolean zzaSx = false;
    public static final Parcelable.Creator<Bucket> CREATOR = new zze();

    Bucket(int n, long l, long l2, Session session, int n2, List<DataSet> list, int n3, boolean bl) {
        this.zzaiI = n;
        this.zzafe = l;
        this.zzaSt = l2;
        this.zzaSj = session;
        this.zzaSu = n2;
        this.zzaSv = list;
        this.zzaSw = n3;
        this.zzaSx = bl;
    }

    public Bucket(RawBucket rawBucket, List<DataSource> list) {
        this(2, rawBucket.zzafe, rawBucket.zzaSt, rawBucket.zzaSj, rawBucket.zzaUa, Bucket.zza(rawBucket.zzaSv, list), rawBucket.zzaSw, rawBucket.zzaSx);
    }

    private static List<DataSet> zza(Collection<RawDataSet> collection, List<DataSource> list) {
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>(collection.size());
        for (RawDataSet rawDataSet : collection) {
            arrayList.add(new DataSet(rawDataSet, list));
        }
        return arrayList;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzafe, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaSt, TimeUnit.MILLISECONDS);
    }

    public Session getSession() {
        return this.zzaSj;
    }

    public String getActivity() {
        return zza.getName(this.zzaSu);
    }

    public int zzBW() {
        return this.zzaSu;
    }

    public List<DataSet> getDataSets() {
        return this.zzaSv;
    }

    public DataSet getDataSet(DataType dataType) {
        for (DataSet dataSet : this.zzaSv) {
            if (!dataSet.getDataType().equals((Object)dataType)) continue;
            return dataSet;
        }
        return null;
    }

    public int getBucketType() {
        return this.zzaSw;
    }

    public boolean equals(Object object) {
        return object == this || object instanceof Bucket && this.zza((Bucket)((Object)object));
    }

    private boolean zza(Bucket bucket) {
        return this.zzafe == bucket.zzafe && this.zzaSt == bucket.zzaSt && this.zzaSu == bucket.zzaSu && zzaa.equal(this.zzaSv, bucket.zzaSv) && this.zzaSw == bucket.zzaSw && this.zzaSx == bucket.zzaSx;
    }

    public boolean zzb(Bucket bucket) {
        return this.zzafe == bucket.zzafe && this.zzaSt == bucket.zzaSt && this.zzaSu == bucket.zzaSu && this.zzaSw == bucket.zzaSw;
    }

    public boolean zzBX() {
        if (this.zzaSx) {
            return true;
        }
        for (DataSet dataSet : this.zzaSv) {
            if (!dataSet.zzBX()) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.zzafe, this.zzaSt, this.zzaSu, this.zzaSw});
    }

    public String toString() {
        return zzaa.zzv((Object)((Object)this)).zzg("startTime", (Object)this.zzafe).zzg("endTime", (Object)this.zzaSt).zzg("activity", (Object)this.zzaSu).zzg("dataSets", this.zzaSv).zzg("bucketType", (Object)Bucket.zzgw(this.zzaSw)).zzg("serverHasMoreData", (Object)this.zzaSx).toString();
    }

    public static String zzgw(int n) {
        switch (n) {
            case 1: {
                return "time";
            }
            case 3: {
                return "type";
            }
            case 4: {
                return "segment";
            }
            case 2: {
                return "session";
            }
            case 0: {
                return "unknown";
            }
        }
        return "bug";
    }

    int getVersionCode() {
        return this.zzaiI;
    }

    public long zzqn() {
        return this.zzafe;
    }

    public long zzAm() {
        return this.zzaSt;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zze.zza(this, parcel, n);
    }
}

