/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawDataPoint;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.data.zzf;
import com.google.android.gms.fitness.data.zzi;
import com.google.android.gms.internal.zzanz;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class DataSet
extends zza
implements ReflectedParcelable {
    private final int versionCode;
    private final DataSource zzaSh;
    private final DataType zzaSg;
    private final List<DataPoint> zzaSG;
    private final List<DataSource> zzaSH;
    private boolean zzaSI = false;
    public static final Parcelable.Creator<DataSet> CREATOR = new zzi();

    DataSet(int n, DataSource dataSource, DataType dataType, List<RawDataPoint> list, List<DataSource> list2, boolean bl) {
        this.versionCode = n;
        this.zzaSh = dataSource;
        this.zzaSg = dataSource.getDataType();
        this.zzaSI = bl;
        this.zzaSG = new ArrayList<DataPoint>(list.size());
        this.zzaSH = n >= 2 ? list2 : Collections.singletonList(dataSource);
        for (RawDataPoint rawDataPoint : list) {
            this.zzaSG.add(new DataPoint(this.zzaSH, rawDataPoint));
        }
    }

    public DataSet(DataSource dataSource) {
        this.versionCode = 3;
        this.zzaSh = (DataSource)((Object)zzac.zzw((Object)((Object)dataSource)));
        this.zzaSg = dataSource.getDataType();
        this.zzaSG = new ArrayList<DataPoint>();
        this.zzaSH = new ArrayList<DataSource>();
        this.zzaSH.add(this.zzaSh);
    }

    public DataSet(RawDataSet rawDataSet, List<DataSource> list) {
        this.versionCode = 3;
        this.zzaSh = DataSet.zzd(list, rawDataSet.zzaUe);
        this.zzaSg = this.zzaSh.getDataType();
        this.zzaSH = list;
        this.zzaSI = rawDataSet.zzaSx;
        List<RawDataPoint> list2 = rawDataSet.zzaUj;
        this.zzaSG = new ArrayList<DataPoint>(list2.size());
        for (RawDataPoint rawDataPoint : list2) {
            this.zzaSG.add(new DataPoint(this.zzaSH, rawDataPoint));
        }
    }

    private static <T> T zzd(List<T> list, int n) {
        return n >= 0 && n < list.size() ? (T)list.get(n) : null;
    }

    public static DataSet create(DataSource dataSource) {
        zzac.zzb((Object)((Object)dataSource), (Object)"DataSource should be specified");
        return new DataSet(dataSource);
    }

    public DataPoint createDataPoint() {
        return DataPoint.create(this.zzaSh);
    }

    public void add(DataPoint dataPoint) {
        DataSource dataSource = dataPoint.getDataSource();
        zzac.zzb((boolean)dataSource.getStreamIdentifier().equals(this.zzaSh.getStreamIdentifier()), (String)"Conflicting data sources found %s vs %s", (Object[])new Object[]{dataSource, this.zzaSh});
        dataPoint.zzCe();
        DataSet.zze(dataPoint);
        this.zzd(dataPoint);
    }

    public void zzd(DataPoint dataPoint) {
        this.zzaSG.add(dataPoint);
        DataSource dataSource = dataPoint.getOriginalDataSource();
        if (dataSource != null && !this.zzaSH.contains((Object)dataSource)) {
            this.zzaSH.add(dataSource);
        }
    }

    public void addAll(Iterable<DataPoint> iterable) {
        for (DataPoint dataPoint : iterable) {
            this.add(dataPoint);
        }
    }

    public void zzb(Iterable<DataPoint> iterable) {
        for (DataPoint dataPoint : iterable) {
            this.zzd(dataPoint);
        }
    }

    public DataSource getDataSource() {
        return this.zzaSh;
    }

    public DataType getDataType() {
        return this.zzaSh.getDataType();
    }

    public List<DataPoint> getDataPoints() {
        return Collections.unmodifiableList(this.zzaSG);
    }

    public boolean isEmpty() {
        return this.zzaSG.isEmpty();
    }

    public boolean zzBX() {
        return this.zzaSI;
    }

    public boolean equals(Object object) {
        return object == this || object instanceof DataSet && this.zza((DataSet)((Object)object));
    }

    private boolean zza(DataSet dataSet) {
        return zzaa.equal((Object)((Object)this.getDataType()), (Object)((Object)dataSet.getDataType())) && zzaa.equal((Object)((Object)this.zzaSh), (Object)((Object)dataSet.zzaSh)) && zzaa.equal(this.zzaSG, dataSet.zzaSG) && this.zzaSI == dataSet.zzaSI;
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.zzaSh});
    }

    public String toString() {
        List<RawDataPoint> list = this.zzCg();
        return String.format("DataSet{%s %s}", this.zzaSh.toDebugString(), this.zzaSG.size() < 10 ? list : String.format("%d data points, first 5: %s", this.zzaSG.size(), list.subList(0, 5)));
    }

    public static void zze(DataPoint dataPoint) throws IllegalArgumentException {
        String string = zzanz.zza(dataPoint, zzf.zzaSy);
        if (string != null) {
            String string2 = String.valueOf((Object)dataPoint);
            Log.w((String)"Fitness", (String)new StringBuilder(20 + String.valueOf(string2).length()).append("Invalid data point: ").append(string2).toString());
            throw new IllegalArgumentException(string);
        }
    }

    int getVersionCode() {
        return this.versionCode;
    }

    List<RawDataPoint> zzCg() {
        return this.zzC(this.zzaSH);
    }

    List<RawDataPoint> zzC(List<DataSource> list) {
        ArrayList<RawDataPoint> arrayList = new ArrayList<RawDataPoint>(this.zzaSG.size());
        for (DataPoint dataPoint : this.zzaSG) {
            arrayList.add(new RawDataPoint(dataPoint, list));
        }
        return arrayList;
    }

    List<DataSource> zzCh() {
        return this.zzaSH;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzi.zza(this, parcel, n);
    }
}

