/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.provider.Settings;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.fitness.data.zzn;
import com.google.android.gms.internal.zzany;
import com.google.android.gms.internal.zzapu;

public final class Device
extends zza {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_PHONE = 1;
    public static final int TYPE_TABLET = 2;
    public static final int TYPE_WATCH = 3;
    public static final int TYPE_CHEST_STRAP = 4;
    public static final int TYPE_SCALE = 5;
    public static final int TYPE_HEAD_MOUNTED = 6;
    private final int versionCode;
    private final String zzaTk;
    private final String zzaTl;
    private final String version;
    private final String zzaTm;
    private final int type;
    private final int zzaTn;
    public static final Parcelable.Creator<Device> CREATOR = new zzn();

    public static Device getLocalDevice(Context context) {
        int n = zzany.zzbp(context);
        String string = Device.zzbn(context);
        return new Device(Build.MANUFACTURER, Build.MODEL, Build.VERSION.RELEASE, string, n, 2);
    }

    private static String zzbn(Context context) {
        return Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
    }

    public Device(String string, String string2, String string3, int n) {
        this(string, string2, "", string3, n, 0);
    }

    public Device(String string, String string2, String string3, String string4, int n, int n2) {
        this(1, string, string2, "", string4, n, n2);
    }

    Device(int n, String string, String string2, String string3, String string4, int n2, int n3) {
        this.versionCode = n;
        this.zzaTk = (String)zzac.zzw((Object)string);
        this.zzaTl = (String)zzac.zzw((Object)string2);
        this.version = "";
        this.zzaTm = this.zzdY(string4);
        this.type = n2;
        this.zzaTn = n3;
    }

    private String zzdY(String string) {
        if (string != null) {
            return string;
        }
        throw new IllegalStateException("Device UID is null.");
    }

    public String getManufacturer() {
        return this.zzaTk;
    }

    public String getModel() {
        return this.zzaTl;
    }

    public String getVersion() {
        return this.version;
    }

    public String getUid() {
        return this.zzaTm;
    }

    public int getType() {
        return this.type;
    }

    public int zzCn() {
        return this.zzaTn;
    }

    private boolean zzCo() {
        return this.zzCn() == 1;
    }

    String getStreamIdentifier() {
        return String.format("%s:%s:%s", this.zzaTk, this.zzaTl, this.zzaTm);
    }

    public String zzCp() {
        return this.zzCo() ? this.zzaTm : zzapu.zzek(this.zzaTm);
    }

    public String toString() {
        return String.format("Device{%s:%s:%s:%s}", this.getStreamIdentifier(), this.version, this.type, this.zzaTn);
    }

    public boolean equals(Object object) {
        return this == object || object instanceof Device && this.zza((Device)((Object)object));
    }

    private boolean zza(Device device) {
        return zzaa.equal((Object)this.zzaTk, (Object)device.zzaTk) && zzaa.equal((Object)this.zzaTl, (Object)device.zzaTl) && zzaa.equal((Object)this.version, (Object)device.version) && zzaa.equal((Object)this.zzaTm, (Object)device.zzaTm) && this.type == device.type && this.zzaTn == device.zzaTn;
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.zzaTk, this.zzaTl, this.version, this.zzaTm, this.type});
    }

    int getVersionCode() {
        return this.versionCode;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzn.zza(this, parcel, n);
    }
}

