/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.SystemClock;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.internal.zzanx;
import com.google.android.gms.location.LocationRequest;
import java.util.concurrent.TimeUnit;

public class SensorRequest {
    public static final int ACCURACY_MODE_LOW = 1;
    public static final int ACCURACY_MODE_DEFAULT = 2;
    public static final int ACCURACY_MODE_HIGH = 3;
    private final DataSource zzaTi;
    private final DataType zzaTj;
    private final long zzaUo;
    private final long zzaWs;
    private final long zzaWr;
    private final int zzaUp;
    private final LocationRequest zzaWw;
    private final long zzaWx;

    private SensorRequest(Builder builder) {
        this.zzaTi = builder.zzaTi;
        this.zzaTj = builder.zzaTj;
        this.zzaUo = builder.zzaUo;
        this.zzaWs = builder.zzaWs;
        this.zzaWr = builder.zzaWr;
        this.zzaUp = builder.zzaUp;
        this.zzaWw = null;
        this.zzaWx = builder.zzaWx;
    }

    private SensorRequest(DataSource dataSource, LocationRequest locationRequest) {
        this.zzaWw = locationRequest;
        this.zzaUo = TimeUnit.MILLISECONDS.toMicros(locationRequest.getInterval());
        this.zzaWs = TimeUnit.MILLISECONDS.toMicros(locationRequest.getFastestInterval());
        this.zzaWr = this.zzaUo;
        this.zzaTj = dataSource.getDataType();
        this.zzaUp = SensorRequest.zza(locationRequest);
        this.zzaTi = dataSource;
        long l = locationRequest.getExpirationTime();
        this.zzaWx = l == Long.MAX_VALUE ? Long.MAX_VALUE : TimeUnit.MILLISECONDS.toMicros(l - SystemClock.elapsedRealtime());
    }

    public static SensorRequest fromLocationRequest(DataSource dataSource, LocationRequest locationRequest) {
        return new SensorRequest(dataSource, locationRequest);
    }

    private static int zza(LocationRequest locationRequest) {
        switch (locationRequest.getPriority()) {
            case 100: {
                return 3;
            }
            case 104: {
                return 1;
            }
        }
        return 2;
    }

    public DataSource getDataSource() {
        return this.zzaTi;
    }

    public DataType getDataType() {
        return this.zzaTj;
    }

    public long getSamplingRate(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaUo, TimeUnit.MICROSECONDS);
    }

    public long getFastestRate(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaWs, TimeUnit.MICROSECONDS);
    }

    public long getMaxDeliveryLatency(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaWr, TimeUnit.MICROSECONDS);
    }

    public int getAccuracyMode() {
        return this.zzaUp;
    }

    public long zzDi() {
        return this.zzaWx;
    }

    public String toString() {
        return zzaa.zzv((Object)this).zzg("dataSource", (Object)this.zzaTi).zzg("dataType", (Object)this.zzaTj).zzg("samplingRateMicros", (Object)this.zzaUo).zzg("deliveryLatencyMicros", (Object)this.zzaWr).zzg("timeOutMicros", (Object)this.zzaWx).toString();
    }

    public boolean equals(Object object) {
        return this == object || object instanceof SensorRequest && this.zza((SensorRequest)object);
    }

    private boolean zza(SensorRequest sensorRequest) {
        return zzaa.equal((Object)((Object)this.zzaTi), (Object)((Object)sensorRequest.zzaTi)) && zzaa.equal((Object)((Object)this.zzaTj), (Object)((Object)sensorRequest.zzaTj)) && this.zzaUo == sensorRequest.zzaUo && this.zzaWs == sensorRequest.zzaWs && this.zzaWr == sensorRequest.zzaWr && this.zzaUp == sensorRequest.zzaUp && zzaa.equal((Object)this.zzaWw, (Object)sensorRequest.zzaWw) && this.zzaWx == sensorRequest.zzaWx;
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.zzaTi, this.zzaTj, this.zzaUo, this.zzaWs, this.zzaWr, this.zzaUp, this.zzaWw, this.zzaWx});
    }

    public static class Builder {
        private DataSource zzaTi;
        private DataType zzaTj;
        private long zzaUo = -1L;
        private long zzaWs = 0L;
        private long zzaWr = 0L;
        private boolean zzaWy = false;
        private int zzaUp = 2;
        private long zzaWx = Long.MAX_VALUE;

        public Builder setDataSource(DataSource dataSource) {
            this.zzaTi = dataSource;
            return this;
        }

        public Builder setDataType(DataType dataType) {
            this.zzaTj = dataType;
            return this;
        }

        public Builder setSamplingRate(long l, TimeUnit timeUnit) {
            zzac.zzb((l >= 0L ? 1 : 0) != 0, (Object)"Cannot use a negative sampling interval");
            this.zzaUo = timeUnit.toMicros(l);
            if (!this.zzaWy) {
                this.zzaWs = this.zzaUo / 2L;
            }
            return this;
        }

        public Builder setFastestRate(int n, TimeUnit timeUnit) {
            zzac.zzb((n >= 0 ? 1 : 0) != 0, (Object)"Cannot use a negative interval");
            this.zzaWy = true;
            this.zzaWs = timeUnit.toMicros(n);
            return this;
        }

        public Builder setMaxDeliveryLatency(int n, TimeUnit timeUnit) {
            zzac.zzb((n >= 0 ? 1 : 0) != 0, (Object)"Cannot use a negative delivery interval");
            this.zzaWr = timeUnit.toMicros(n);
            return this;
        }

        public Builder setAccuracyMode(int n) {
            this.zzaUp = zzanx.zzhc(n);
            return this;
        }

        public Builder setTimeout(long l, TimeUnit timeUnit) {
            zzac.zzb((l > 0L ? 1 : 0) != 0, (String)"Invalid time out value specified: %d", (Object[])new Object[]{l});
            zzac.zzb((timeUnit != null ? 1 : 0) != 0, (Object)"Invalid time unit specified");
            this.zzaWx = timeUnit.toMicros(l);
            return this;
        }

        public SensorRequest build() {
            zzac.zza((this.zzaTi != null || this.zzaTj != null ? 1 : 0) != 0, (Object)"Must call setDataSource() or setDataType()");
            zzac.zza((this.zzaTj == null || this.zzaTi == null || this.zzaTj.equals((Object)this.zzaTi.getDataType()) ? 1 : 0) != 0, (Object)"Specified data type is incompatible with specified data source");
            return new SensorRequest(this);
        }
    }
}

