/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.result;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.fitness.data.Bucket;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawBucket;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.result.zzc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DataReadResult
extends zza
implements Result {
    private final int zzaiI;
    private final List<DataSet> zzaSv;
    private final Status zzair;
    private final List<Bucket> zzaWP;
    private int zzaWQ;
    private final List<DataSource> zzaWR;
    private final List<DataType> zzaWS;
    public static final Parcelable.Creator<DataReadResult> CREATOR = new zzc();

    DataReadResult(int n, List<RawDataSet> list, Status status, List<RawBucket> list2, int n2, List<DataSource> list3, List<DataType> list4) {
        this.zzaiI = n;
        this.zzair = status;
        this.zzaWQ = n2;
        this.zzaWR = list3;
        this.zzaWS = list4;
        this.zzaSv = new ArrayList<DataSet>(list.size());
        for (RawDataSet zza2 : list) {
            this.zzaSv.add(new DataSet(zza2, list3));
        }
        this.zzaWP = new ArrayList<Bucket>(list2.size());
        for (RawBucket rawBucket : list2) {
            this.zzaWP.add(new Bucket(rawBucket, list3));
        }
    }

    public DataReadResult(List<DataSet> list, List<Bucket> list2, Status status) {
        this.zzaiI = 5;
        this.zzaSv = list;
        this.zzair = status;
        this.zzaWP = list2;
        this.zzaWQ = 1;
        this.zzaWR = new ArrayList<DataSource>();
        this.zzaWS = new ArrayList<DataType>();
    }

    public static DataReadResult zza(Status status, List<DataType> list, List<DataSource> list2) {
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>();
        for (DataSource zza2 : list2) {
            arrayList.add(DataSet.create(zza2));
        }
        for (DataType dataType : list) {
            DataSource dataSource = new DataSource.Builder().setDataType(dataType).setType(1).setName("Default").build();
            arrayList.add(DataSet.create(dataSource));
        }
        return new DataReadResult(arrayList, Collections.emptyList(), status);
    }

    public DataSet getDataSet(DataType dataType) {
        for (DataSet dataSet : this.zzaSv) {
            if (!dataType.equals((Object)dataSet.getDataType())) continue;
            return dataSet;
        }
        return DataSet.create(new DataSource.Builder().setDataType(dataType).setType(1).build());
    }

    public DataSet getDataSet(DataSource dataSource) {
        for (DataSet dataSet : this.zzaSv) {
            if (!dataSource.equals((Object)dataSet.getDataSource())) continue;
            return dataSet;
        }
        return DataSet.create(dataSource);
    }

    public List<DataSet> getDataSets() {
        return this.zzaSv;
    }

    public List<Bucket> getBuckets() {
        return this.zzaWP;
    }

    public int zzDq() {
        return this.zzaWQ;
    }

    public void zzb(DataReadResult dataReadResult) {
        for (DataSet zza2 : dataReadResult.getDataSets()) {
            this.zza(zza2, this.zzaSv);
        }
        for (Bucket bucket : dataReadResult.getBuckets()) {
            this.zza(bucket, this.zzaWP);
        }
    }

    private void zza(DataSet dataSet, List<DataSet> list) {
        for (DataSet dataSet2 : list) {
            if (!dataSet2.getDataSource().equals((Object)dataSet.getDataSource())) continue;
            dataSet2.zzb(dataSet.getDataPoints());
            return;
        }
        list.add(dataSet);
    }

    private void zza(Bucket bucket, List<Bucket> list) {
        for (Bucket bucket2 : list) {
            if (!bucket2.zzb(bucket)) continue;
            for (DataSet dataSet : bucket.getDataSets()) {
                this.zza(dataSet, bucket2.getDataSets());
            }
            return;
        }
        this.zzaWP.add(bucket);
    }

    public Status getStatus() {
        return this.zzair;
    }

    public boolean equals(Object object) {
        return this == object || object instanceof DataReadResult && this.zzc((DataReadResult)((Object)object));
    }

    private boolean zzc(DataReadResult dataReadResult) {
        return this.zzair.equals((Object)dataReadResult.zzair) && zzaa.equal(this.zzaSv, dataReadResult.zzaSv) && zzaa.equal(this.zzaWP, dataReadResult.zzaWP);
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.zzair, this.zzaSv, this.zzaWP});
    }

    public String toString() {
        Object object;
        Object object2;
        int n;
        zzaa.zza zza2 = zzaa.zzv((Object)((Object)this)).zzg("status", (Object)this.zzair);
        if (this.zzaSv.size() > 5) {
            n = this.zzaSv.size();
            object2 = new StringBuilder(21).append(n).append(" data sets").toString();
        } else {
            object2 = this.zzaSv;
        }
        zzaa.zza zza3 = zza2.zzg("dataSets", object2);
        if (this.zzaWP.size() > 5) {
            n = this.zzaWP.size();
            object = new StringBuilder(19).append(n).append(" buckets").toString();
        } else {
            object = this.zzaWP;
        }
        return zza3.zzg("buckets", object).toString();
    }

    int getVersionCode() {
        return this.zzaiI;
    }

    List<RawBucket> zzDr() {
        ArrayList<RawBucket> arrayList = new ArrayList<RawBucket>(this.zzaWP.size());
        for (Bucket bucket : this.zzaWP) {
            arrayList.add(new RawBucket(bucket, this.zzaWR, this.zzaWS));
        }
        return arrayList;
    }

    List<RawDataSet> zzDs() {
        ArrayList<RawDataSet> arrayList = new ArrayList<RawDataSet>(this.zzaSv.size());
        for (DataSet dataSet : this.zzaSv) {
            arrayList.add(new RawDataSet(dataSet, this.zzaWR, this.zzaWS));
        }
        return arrayList;
    }

    List<DataSource> zzCh() {
        return this.zzaWR;
    }

    List<DataType> zzDt() {
        return this.zzaWS;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzc.zza(this, parcel, n);
    }
}

