/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.PendingIntent;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.fitness.HistoryApi;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.DataDeleteRequest;
import com.google.android.gms.fitness.request.DataReadRequest;
import com.google.android.gms.fitness.request.DataUpdateListenerRegistrationRequest;
import com.google.android.gms.fitness.request.DataUpdateRequest;
import com.google.android.gms.fitness.request.zzd;
import com.google.android.gms.fitness.request.zzg;
import com.google.android.gms.fitness.request.zzq;
import com.google.android.gms.fitness.result.DailyTotalResult;
import com.google.android.gms.fitness.result.DataReadResult;
import com.google.android.gms.internal.zzaad;
import com.google.android.gms.internal.zzaog;
import com.google.android.gms.internal.zzaol;
import com.google.android.gms.internal.zzaom;
import com.google.android.gms.internal.zzaov;
import com.google.android.gms.internal.zzapr;

public class zzapm
implements HistoryApi {
    @Override
    public PendingResult<Status> insertData(GoogleApiClient googleApiClient, DataSet dataSet) {
        return this.zza(googleApiClient, dataSet, false);
    }

    private PendingResult<Status> zza(GoogleApiClient googleApiClient, final DataSet dataSet, final boolean bl) {
        zzac.zzb((Object)((Object)dataSet), (Object)"Must set the data set");
        zzac.zza((!dataSet.getDataPoints().isEmpty() ? 1 : 0) != 0, (Object)"Cannot use an empty data set");
        zzac.zzb((Object)((Object)dataSet.getDataSource().zzCi()), (Object)"Must set the app package name for the data source");
        return googleApiClient.zza((zzaad.zza)new zzaog.zzc(this, googleApiClient){

            protected void zza(zzaog zzaog2) throws RemoteException {
                zzapr zzapr2 = new zzapr((zzaad.zzb<Status>)this);
                ((zzaov)zzaog2.zzxD()).zza(new zzg(dataSet, zzapr2, bl));
            }
        });
    }

    @Override
    public PendingResult<Status> deleteData(GoogleApiClient googleApiClient, final DataDeleteRequest dataDeleteRequest) {
        return googleApiClient.zza((zzaad.zza)new zzaog.zzc(this, googleApiClient){

            protected void zza(zzaog zzaog2) throws RemoteException {
                zzapr zzapr2 = new zzapr((zzaad.zzb<Status>)this);
                ((zzaov)zzaog2.zzxD()).zza(new DataDeleteRequest(dataDeleteRequest, zzapr2));
            }
        });
    }

    @Override
    public PendingResult<Status> updateData(GoogleApiClient googleApiClient, final DataUpdateRequest dataUpdateRequest) {
        zzac.zzb((Object)((Object)dataUpdateRequest.getDataSet()), (Object)"Must set the data set");
        zzac.zza((long)dataUpdateRequest.zzqn(), (Object)"Must set a non-zero value for startTimeMillis/startTime");
        zzac.zza((long)dataUpdateRequest.zzAm(), (Object)"Must set a non-zero value for endTimeMillis/endTime");
        return googleApiClient.zza((zzaad.zza)new zzaog.zzc(this, googleApiClient){

            protected void zza(zzaog zzaog2) throws RemoteException {
                zzapr zzapr2 = new zzapr((zzaad.zzb<Status>)this);
                ((zzaov)zzaog2.zzxD()).zza(new DataUpdateRequest(dataUpdateRequest, (IBinder)zzapr2));
            }
        });
    }

    @Override
    public PendingResult<Status> registerDataUpdateListener(GoogleApiClient googleApiClient, final DataUpdateListenerRegistrationRequest dataUpdateListenerRegistrationRequest) {
        return googleApiClient.zza((zzaad.zza)new zzaog.zzc(this, googleApiClient){

            protected void zza(zzaog zzaog2) throws RemoteException {
                zzapr zzapr2 = new zzapr((zzaad.zzb<Status>)this);
                ((zzaov)zzaog2.zzxD()).zza(new DataUpdateListenerRegistrationRequest(dataUpdateListenerRegistrationRequest, (IBinder)zzapr2));
            }
        });
    }

    @Override
    public PendingResult<Status> unregisterDataUpdateListener(GoogleApiClient googleApiClient, final PendingIntent pendingIntent) {
        return googleApiClient.zzb((zzaad.zza)new zzaog.zzc(this, googleApiClient){

            protected void zza(zzaog zzaog2) throws RemoteException {
                zzapr zzapr2 = new zzapr((zzaad.zzb<Status>)this);
                ((zzaov)zzaog2.zzxD()).zza(new zzq(pendingIntent, (IBinder)zzapr2));
            }
        });
    }

    @Override
    public PendingResult<DataReadResult> readData(GoogleApiClient googleApiClient, final DataReadRequest dataReadRequest) {
        return googleApiClient.zza((zzaad.zza)new zzaog.zza<DataReadResult>(this, googleApiClient){

            protected void zza(zzaog zzaog2) throws RemoteException {
                zza zza2 = new zza((zzaad.zzb)this);
                ((zzaov)zzaog2.zzxD()).zza(new DataReadRequest(dataReadRequest, zza2));
            }

            protected DataReadResult zzX(Status status) {
                return DataReadResult.zza(status, dataReadRequest.getDataTypes(), dataReadRequest.getDataSources());
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzX(status);
            }
        });
    }

    @Override
    public PendingResult<DailyTotalResult> readDailyTotal(GoogleApiClient googleApiClient, DataType dataType) {
        return this.zza(googleApiClient, dataType, false);
    }

    @Override
    public PendingResult<DailyTotalResult> readDailyTotalFromLocalDevice(GoogleApiClient googleApiClient, DataType dataType) {
        return this.zza(googleApiClient, dataType, true);
    }

    private PendingResult<DailyTotalResult> zza(GoogleApiClient googleApiClient, final DataType dataType, final boolean bl) {
        return googleApiClient.zza((zzaad.zza)new zzaog.zza<DailyTotalResult>(this, googleApiClient){

            protected void zza(zzaog zzaog2) throws RemoteException {
                zzaol.zza zza2 = new zzaol.zza(){

                    @Override
                    public void zza(DailyTotalResult dailyTotalResult) throws RemoteException {
                        this.zzb(dailyTotalResult);
                    }
                };
                zzd zzd2 = new zzd(zza2, dataType, bl);
                ((zzaov)zzaog2.zzxD()).zza(zzd2);
            }

            protected DailyTotalResult zzY(Status status) {
                return DailyTotalResult.zza(status, dataType);
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzY(status);
            }
        });
    }

    private static class zza
    extends zzaom.zza {
        private final zzaad.zzb<DataReadResult> zzaGN;
        private int zzaUV = 0;
        private DataReadResult zzaUW = null;

        private zza(zzaad.zzb<DataReadResult> zzb2) {
            this.zzaGN = zzb2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zza(DataReadResult dataReadResult) {
            zza zza2 = this;
            synchronized (zza2) {
                if (Log.isLoggable((String)"Fitness", (int)2)) {
                    int n = this.zzaUV;
                    Log.v((String)"Fitness", (String)new StringBuilder(33).append("Received batch result ").append(n).toString());
                }
                if (this.zzaUW == null) {
                    this.zzaUW = dataReadResult;
                } else {
                    this.zzaUW.zzb(dataReadResult);
                }
                ++this.zzaUV;
                if (this.zzaUV == this.zzaUW.zzDq()) {
                    this.zzaGN.setResult((Object)this.zzaUW);
                }
            }
        }
    }
}

