/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.support.annotation.RequiresPermission;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.zze;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.request.SessionInsertRequest;
import com.google.android.gms.fitness.request.SessionReadRequest;
import com.google.android.gms.fitness.result.SessionReadResult;
import com.google.android.gms.fitness.result.SessionStopResult;

public interface SessionsApi {
    public PendingResult<Status> startSession(GoogleApiClient var1, Session var2);

    public PendingResult<SessionStopResult> stopSession(GoogleApiClient var1, String var2);

    public PendingResult<Status> insertSession(GoogleApiClient var1, SessionInsertRequest var2);

    @RequiresPermission(anyOf={"android.permission.ACCESS_FINE_LOCATION", "android.permission.BODY_SENSORS"}, conditional=true)
    public PendingResult<SessionReadResult> readSession(GoogleApiClient var1, SessionReadRequest var2);

    public PendingResult<Status> registerForSessions(GoogleApiClient var1, PendingIntent var2);

    public PendingResult<Status> unregisterForSessions(GoogleApiClient var1, PendingIntent var2);

    public static class ViewIntentBuilder {
        private final Context mContext;
        private Session zzaTi;
        private String zzaTj;
        private boolean zzaTk = false;

        public ViewIntentBuilder(Context context) {
            this.mContext = context;
        }

        public ViewIntentBuilder setSession(Session session) {
            this.zzaTi = session;
            return this;
        }

        public ViewIntentBuilder setPreferredApplication(String string) {
            this.zzaTj = string;
            this.zzaTk = true;
            return this;
        }

        public Intent build() {
            zzbr.zza((this.zzaTi != null ? 1 : 0) != 0, (Object)"Session must be set");
            Intent intent = new Intent("vnd.google.fitness.VIEW");
            intent.setType(Session.getMimeType(this.zzaTi.getActivity()));
            zze.zza((SafeParcelable)this.zzaTi, (Intent)intent, (String)"vnd.google.fitness.session");
            if (!this.zzaTk) {
                this.zzaTj = this.zzaTi.getAppPackageName();
            }
            Intent intent2 = intent;
            ViewIntentBuilder viewIntentBuilder = this;
            if (viewIntentBuilder.zzaTj != null) {
                Intent intent3 = new Intent(intent2).setPackage(viewIntentBuilder.zzaTj);
                ResolveInfo resolveInfo = viewIntentBuilder.mContext.getPackageManager().resolveActivity(intent3, 0);
                if (resolveInfo != null) {
                    String string = resolveInfo.activityInfo.name;
                    intent3.setComponent(new ComponentName(viewIntentBuilder.zzaTj, string));
                    return intent3;
                }
            }
            return intent2;
        }
    }
}

