/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbh;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.request.zzx;
import com.google.android.gms.fitness.request.zzy;
import com.google.android.gms.internal.zzbys;
import com.google.android.gms.internal.zzbyt;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

public class DataUpdateRequest
extends zza {
    private final int zzakw;
    private final long zzahb;
    private final long zzaTs;
    private final DataSet zzaVm;
    private final zzbys zzaWs;
    public static final Parcelable.Creator<DataUpdateRequest> CREATOR = new zzy();

    DataUpdateRequest(int n, long l, long l2, DataSet dataSet, IBinder iBinder) {
        this.zzakw = n;
        this.zzahb = l;
        this.zzaTs = l2;
        this.zzaVm = dataSet;
        this.zzaWs = zzbyt.zzW(iBinder);
    }

    private DataUpdateRequest(Builder builder) {
        this(builder.zzahb, builder.zzaTs, builder.zzaVm, null);
    }

    private DataUpdateRequest(long l, long l2, DataSet dataSet, IBinder iBinder) {
        this.zzakw = 1;
        this.zzahb = l;
        this.zzaTs = l2;
        this.zzaVm = dataSet;
        this.zzaWs = zzbyt.zzW(iBinder);
    }

    public DataUpdateRequest(DataUpdateRequest dataUpdateRequest, IBinder iBinder) {
        this(dataUpdateRequest.zzahb, dataUpdateRequest.zzaTs, dataUpdateRequest.getDataSet(), iBinder);
    }

    public final long zzma() {
        return this.zzahb;
    }

    public final long zztT() {
        return this.zzaTs;
    }

    public DataSet getDataSet() {
        return this.zzaVm;
    }

    public IBinder getCallbackBinder() {
        if (this.zzaWs == null) {
            return null;
        }
        return this.zzaWs.asBinder();
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzahb, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaTs, TimeUnit.MILLISECONDS);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (object == this) break block2;
                if (!(object instanceof DataUpdateRequest)) break block3;
                DataUpdateRequest dataUpdateRequest = (DataUpdateRequest)((Object)object);
                DataUpdateRequest dataUpdateRequest2 = this;
                if (!(dataUpdateRequest2.zzahb == dataUpdateRequest.zzahb && dataUpdateRequest2.zzaTs == dataUpdateRequest.zzaTs && zzbh.equal((Object)((Object)dataUpdateRequest2.zzaVm), (Object)((Object)dataUpdateRequest.zzaVm)))) break block3;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzahb, this.zzaTs, this.zzaVm});
    }

    public String toString() {
        return zzbh.zzt((Object)((Object)this)).zzg("startTimeMillis", (Object)this.zzahb).zzg("endTimeMillis", (Object)this.zzaTs).zzg("dataSet", (Object)this.zzaVm).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        DataUpdateRequest dataUpdateRequest = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)1, (long)dataUpdateRequest.zzahb);
        zzd.zza((Parcel)parcel2, (int)2, (long)dataUpdateRequest.zzaTs);
        zzd.zza((Parcel)parcel2, (int)3, (Parcelable)dataUpdateRequest.getDataSet(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)4, (IBinder)dataUpdateRequest.getCallbackBinder(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)1000, (int)dataUpdateRequest.zzakw);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }

    /* synthetic */ DataUpdateRequest(Builder builder, zzx zzx2) {
        this(builder);
    }

    public static class Builder {
        private long zzahb;
        private long zzaTs;
        private DataSet zzaVm;

        public Builder setTimeInterval(long l, long l2, TimeUnit timeUnit) {
            zzbr.zzb((l > 0L ? 1 : 0) != 0, (String)"Invalid start time :%d", (Object[])new Object[]{l});
            zzbr.zzb((l2 >= l ? 1 : 0) != 0, (String)"Invalid end time :%d", (Object[])new Object[]{l2});
            this.zzahb = timeUnit.toMillis(l);
            this.zzaTs = timeUnit.toMillis(l2);
            return this;
        }

        public Builder setDataSet(DataSet dataSet) {
            zzbr.zzb((Object)((Object)dataSet), (Object)"Must set the data set");
            this.zzaVm = dataSet;
            return this;
        }

        public DataUpdateRequest build() {
            Builder builder = this;
            zzbr.zza((long)builder.zzahb, (Object)"Must set a non-zero value for startTimeMillis/startTime");
            zzbr.zza((long)builder.zzaTs, (Object)"Must set a non-zero value for endTimeMillis/endTime");
            zzbr.zzb((Object)((Object)builder.zzaVm), (Object)"Must set the data set");
            for (DataPoint dataPoint : builder.zzaVm.getDataPoints()) {
                long l;
                long l2 = dataPoint.getStartTime(TimeUnit.MILLISECONDS);
                zzbr.zza((!(l2 > (l = dataPoint.getEndTime(TimeUnit.MILLISECONDS)) || l2 != 0L && l2 < builder.zzahb || l2 != 0L && l2 > builder.zzaTs || l > builder.zzaTs || l < builder.zzahb) ? 1 : 0) != 0, (String)"Data Point's startTimeMillis %d, endTimeMillis %d should lie between timeRange provided in the request. StartTimeMillis %d, EndTimeMillis: %d", (Object[])new Object[]{l2, l, builder.zzahb, builder.zzaTs});
            }
            return new DataUpdateRequest(this, null);
        }
    }
}

