/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.service;

import android.annotation.TargetApi;
import android.app.AppOpsManager;
import android.app.Service;
import android.content.Intent;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.CallSuper;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.result.DataSourcesResult;
import com.google.android.gms.fitness.service.FitnessSensorServiceRequest;
import com.google.android.gms.internal.zzbxk;
import com.google.android.gms.internal.zzbys;
import com.google.android.gms.internal.zzcba;
import com.google.android.gms.internal.zzcbc;
import com.google.android.gms.internal.zzcbf;
import java.util.List;

public abstract class FitnessSensorService
extends Service {
    public static final String SERVICE_INTERFACE = "com.google.android.gms.fitness.service.FitnessSensorService";
    private zza zzaXG;

    @CallSuper
    public void onCreate() {
        super.onCreate();
        this.zzaXG = new zza(this, null);
    }

    @CallSuper
    public IBinder onBind(Intent intent) {
        if (SERVICE_INTERFACE.equals(intent.getAction())) {
            if (Log.isLoggable((String)"FitnessSensorService", (int)3)) {
                String string = String.valueOf(intent);
                String string2 = String.valueOf(((Object)((Object)this)).getClass().getName());
                Log.d((String)"FitnessSensorService", (String)new StringBuilder(20 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Intent ").append(string).append(" received by ").append(string2).toString());
            }
            return this.zzaXG.asBinder();
        }
        return null;
    }

    public abstract List<DataSource> onFindDataSources(List<DataType> var1);

    public abstract boolean onRegister(FitnessSensorServiceRequest var1);

    public abstract boolean onUnregister(DataSource var1);

    @TargetApi(value=19)
    protected final void zztY() throws SecurityException {
        int n = Binder.getCallingUid();
        if (zzs.zzsb()) {
            ((AppOpsManager)this.getSystemService("appops")).checkPackage(n, "com.google.android.gms");
            return;
        }
        String[] stringArray = this.getPackageManager().getPackagesForUid(n);
        if (stringArray != null) {
            String[] stringArray2 = stringArray;
            int n2 = stringArray.length;
            for (int i = 0; i < n2; ++i) {
                if (!stringArray2[i].equals("com.google.android.gms")) continue;
                return;
            }
        }
        throw new SecurityException("Unauthorized caller");
    }

    static final class zza
    extends zzcbf {
        private final FitnessSensorService zzaXH;

        private zza(FitnessSensorService fitnessSensorService) {
            this.zzaXH = fitnessSensorService;
        }

        @Override
        public final void zza(zzcba zzcba2, zzbxk zzbxk2) throws RemoteException {
            this.zzaXH.zztY();
            List<DataSource> list = this.zzaXH.onFindDataSources(zzcba2.getDataTypes());
            zzbxk2.zza(new DataSourcesResult(list, Status.zzaBo));
        }

        @Override
        public final void zza(FitnessSensorServiceRequest fitnessSensorServiceRequest, zzbys zzbys2) throws RemoteException {
            this.zzaXH.zztY();
            if (this.zzaXH.onRegister(fitnessSensorServiceRequest)) {
                zzbys2.zzu(Status.zzaBo);
                return;
            }
            zzbys2.zzu(new Status(13));
        }

        @Override
        public final void zza(zzcbc zzcbc2, zzbys zzbys2) throws RemoteException {
            this.zzaXH.zztY();
            if (this.zzaXH.onUnregister(zzcbc2.getDataSource())) {
                zzbys2.zzu(Status.zzaBo);
                return;
            }
            zzbys2.zzu(new Status(13));
        }

        /* synthetic */ zza(FitnessSensorService fitnessSensorService, com.google.android.gms.fitness.service.zza zza2) {
            this(fitnessSensorService);
        }
    }
}

