/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbe;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawDataPoint;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.data.zzf;
import com.google.android.gms.fitness.data.zzi;
import com.google.android.gms.internal.zzbuj;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class DataSet
extends zza
implements ReflectedParcelable {
    private final int versionCode;
    private final DataSource zzaTa;
    private final DataType zzaSZ;
    private final List<DataPoint> zzaTB;
    private final List<DataSource> zzaTC;
    private boolean zzaTD = false;
    public static final Parcelable.Creator<DataSet> CREATOR = new zzi();

    DataSet(int n, DataSource dataSource, DataType dataType, List<RawDataPoint> list, List<DataSource> list2, boolean bl) {
        this.versionCode = n;
        this.zzaTa = dataSource;
        this.zzaSZ = dataSource.getDataType();
        this.zzaTD = bl;
        this.zzaTB = new ArrayList<DataPoint>(list.size());
        this.zzaTC = n >= 2 ? list2 : Collections.singletonList(dataSource);
        for (RawDataPoint rawDataPoint : list) {
            this.zzaTB.add(new DataPoint(this.zzaTC, rawDataPoint));
        }
    }

    private DataSet(DataSource dataSource) {
        this.versionCode = 3;
        this.zzaTa = (DataSource)((Object)zzbo.zzu((Object)((Object)dataSource)));
        this.zzaSZ = dataSource.getDataType();
        this.zzaTB = new ArrayList<DataPoint>();
        this.zzaTC = new ArrayList<DataSource>();
        this.zzaTC.add(this.zzaTa);
    }

    public DataSet(RawDataSet rawDataSet, List<DataSource> list) {
        this.versionCode = 3;
        int n = rawDataSet.zzaUZ;
        List<DataSource> list2 = list;
        this.zzaTa = n >= 0 && n < list2.size() ? list2.get(n) : null;
        this.zzaSZ = this.zzaTa.getDataType();
        this.zzaTC = list;
        this.zzaTD = rawDataSet.zzaTs;
        List<RawDataPoint> list3 = rawDataSet.zzaVe;
        this.zzaTB = new ArrayList<DataPoint>(list3.size());
        for (RawDataPoint rawDataPoint : list3) {
            this.zzaTB.add(new DataPoint(this.zzaTC, rawDataPoint));
        }
    }

    public static DataSet create(DataSource dataSource) {
        zzbo.zzb((Object)((Object)dataSource), (Object)"DataSource should be specified");
        return new DataSet(dataSource);
    }

    public final DataPoint createDataPoint() {
        return DataPoint.create(this.zzaTa);
    }

    public final void add(DataPoint dataPoint) {
        DataSource dataSource = dataPoint.getDataSource();
        zzbo.zzb((boolean)dataSource.getStreamIdentifier().equals(this.zzaTa.getStreamIdentifier()), (String)"Conflicting data sources found %s vs %s", (Object[])new Object[]{dataSource, this.zzaTa});
        dataPoint.zztK();
        DataSet.zzb(dataPoint);
        this.zza(dataPoint);
    }

    private final void zza(DataPoint dataPoint) {
        this.zzaTB.add(dataPoint);
        DataSource dataSource = dataPoint.getOriginalDataSource();
        if (dataSource != null && !this.zzaTC.contains((Object)dataSource)) {
            this.zzaTC.add(dataSource);
        }
    }

    public final void addAll(Iterable<DataPoint> iterable) {
        for (DataPoint dataPoint : iterable) {
            this.add(dataPoint);
        }
    }

    public final void zzb(Iterable<DataPoint> iterable) {
        for (DataPoint dataPoint : iterable) {
            this.zza(dataPoint);
        }
    }

    public final DataSource getDataSource() {
        return this.zzaTa;
    }

    public final DataType getDataType() {
        return this.zzaTa.getDataType();
    }

    public final List<DataPoint> getDataPoints() {
        return Collections.unmodifiableList(this.zzaTB);
    }

    public final boolean isEmpty() {
        return this.zzaTB.isEmpty();
    }

    public final boolean zztE() {
        return this.zzaTD;
    }

    public final boolean equals(Object object) {
        block3: {
            block2: {
                if (object == this) break block2;
                if (!(object instanceof DataSet)) break block3;
                DataSet dataSet = (DataSet)((Object)object);
                DataSet dataSet2 = this;
                if (!(zzbe.equal((Object)((Object)dataSet2.getDataType()), (Object)((Object)dataSet.getDataType())) && zzbe.equal((Object)((Object)dataSet2.zzaTa), (Object)((Object)dataSet.zzaTa)) && zzbe.equal(dataSet2.zzaTB, dataSet.zzaTB) && dataSet2.zzaTD == dataSet.zzaTD)) break block3;
            }
            return true;
        }
        return false;
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzaTa});
    }

    public final String toString() {
        List<RawDataPoint> list = this.zztL();
        return String.format("DataSet{%s %s}", this.zzaTa.toDebugString(), this.zzaTB.size() < 10 ? list : String.format("%d data points, first 5: %s", this.zzaTB.size(), list.subList(0, 5)));
    }

    public static void zzb(DataPoint dataPoint) throws IllegalArgumentException {
        String string = zzbuj.zza(dataPoint, zzf.zzaTt);
        if (string != null) {
            String string2 = String.valueOf((Object)dataPoint);
            Log.w((String)"Fitness", (String)new StringBuilder(20 + String.valueOf(string2).length()).append("Invalid data point: ").append(string2).toString());
            throw new IllegalArgumentException(string);
        }
    }

    private List<RawDataPoint> zztL() {
        return this.zzA(this.zzaTC);
    }

    final List<RawDataPoint> zzA(List<DataSource> list) {
        ArrayList<RawDataPoint> arrayList = new ArrayList<RawDataPoint>(this.zzaTB.size());
        for (DataPoint dataPoint : this.zzaTB) {
            arrayList.add(new RawDataPoint(dataPoint, list));
        }
        return arrayList;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        DataSet dataSet = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)1, (Parcelable)dataSet.getDataSource(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)2, (Parcelable)dataSet.getDataType(), (int)n, (boolean)false);
        zzd.zzd((Parcel)parcel2, (int)3, dataSet.zztL(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)4, dataSet.zzaTC, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)5, (boolean)dataSet.zzaTD);
        zzd.zzc((Parcel)parcel2, (int)1000, (int)dataSet.versionCode);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }
}

