/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.provider.Settings;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbe;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.fitness.data.zzo;
import com.google.android.gms.internal.zzbui;
import com.google.android.gms.internal.zzbzn;
import java.util.Arrays;

public final class Device
extends zza {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_PHONE = 1;
    public static final int TYPE_TABLET = 2;
    public static final int TYPE_WATCH = 3;
    public static final int TYPE_CHEST_STRAP = 4;
    public static final int TYPE_SCALE = 5;
    public static final int TYPE_HEAD_MOUNTED = 6;
    private final int versionCode;
    private final String zzaUf;
    private final String zzaUg;
    private final String version;
    private final String zzaUh;
    private final int type;
    private final int zzaUi;
    public static final Parcelable.Creator<Device> CREATOR = new zzo();

    public static Device getLocalDevice(Context context) {
        int n = zzbui.zzaU(context);
        String string = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        return new Device(Build.MANUFACTURER, Build.MODEL, Build.VERSION.RELEASE, string, n, 2);
    }

    public Device(String string, String string2, String string3, int n) {
        this(string, string2, "", string3, n, 0);
    }

    private Device(String string, String string2, String string3, String string4, int n, int n2) {
        this(1, string, string2, "", string4, n, n2);
    }

    Device(int n, String string, String string2, String string3, String string4, int n2, int n3) {
        this.versionCode = n;
        this.zzaUf = (String)zzbo.zzu((Object)string);
        this.zzaUg = (String)zzbo.zzu((Object)string2);
        this.version = "";
        String string5 = string4;
        if (string5 == null) {
            throw new IllegalStateException("Device UID is null.");
        }
        this.zzaUh = string5;
        this.type = n2;
        this.zzaUi = n3;
    }

    public final String getManufacturer() {
        return this.zzaUf;
    }

    public final String getModel() {
        return this.zzaUg;
    }

    public final String getUid() {
        return this.zzaUh;
    }

    public final int getType() {
        return this.type;
    }

    final String getStreamIdentifier() {
        return String.format("%s:%s:%s", this.zzaUf, this.zzaUg, this.zzaUh);
    }

    public final String toString() {
        return String.format("Device{%s:%s:%s:%s}", this.getStreamIdentifier(), this.version, this.type, this.zzaUi);
    }

    public final boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Device)) break block3;
                Device device = (Device)((Object)object);
                Device device2 = this;
                if (!(zzbe.equal((Object)device2.zzaUf, (Object)device.zzaUf) && zzbe.equal((Object)device2.zzaUg, (Object)device.zzaUg) && zzbe.equal((Object)device2.version, (Object)device.version) && zzbe.equal((Object)device2.zzaUh, (Object)device.zzaUh) && device2.type == device.type && device2.zzaUi == device.zzaUi)) break block3;
            }
            return true;
        }
        return false;
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzaUf, this.zzaUg, this.version, this.zzaUh, this.type});
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        Device device = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)1, (String)device.getManufacturer(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)2, (String)device.getModel(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)3, (String)device.version, (boolean)false);
        Device device2 = device;
        zzd.zza((Parcel)parcel2, (int)4, (String)(device2.zzaUi == 1 ? device2.zzaUh : zzbzn.zzdh(device2.zzaUh)), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)5, (int)device.getType());
        zzd.zzc((Parcel)parcel2, (int)6, (int)device.zzaUi);
        zzd.zzc((Parcel)parcel2, (int)1000, (int)device.versionCode);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }
}

