/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.safeparcel.zze;
import com.google.android.gms.common.internal.zzbe;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.fitness.data.zzac;
import com.google.android.gms.fitness.data.zzad;
import com.google.android.gms.fitness.data.zzb;
import com.google.android.gms.fitness.zza;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

public class Session
extends com.google.android.gms.common.internal.safeparcel.zza {
    public static final String EXTRA_SESSION = "vnd.google.fitness.session";
    public static final String MIME_TYPE_PREFIX = "vnd.google.fitness.session/";
    private final int zzaku;
    private final long zzagZ;
    private final long zzaTo;
    private final String mName;
    private final String zzaVf;
    private final String zzafa;
    private final int zzaTp;
    private final zzb zzaVg;
    private final Long zzaVh;
    public static final Parcelable.Creator<Session> CREATOR = new zzad();

    Session(int n, long l, long l2, String string, String string2, String string3, int n2, zzb zzb2, Long l3) {
        this.zzaku = n;
        this.zzagZ = l;
        this.zzaTo = l2;
        this.mName = string;
        this.zzaVf = string2;
        this.zzafa = string3;
        this.zzaTp = n2;
        this.zzaVg = zzb2;
        this.zzaVh = l3;
    }

    private Session(long l, long l2, String string, String string2, String string3, int n, zzb zzb2, Long l3) {
        this(3, l, l2, string, string2, string3, n, null, l3);
    }

    private Session(Builder builder) {
        this(builder.zzagZ, builder.zzaTo, builder.mName, builder.zzaVf, builder.zzafa, builder.zzaTp, null, builder.zzaVh);
    }

    public static Session extract(Intent intent) {
        if (intent == null) {
            return null;
        }
        return (Session)zze.zza((Intent)intent, (String)EXTRA_SESSION, CREATOR);
    }

    public static String getMimeType(String string) {
        String string2 = String.valueOf(MIME_TYPE_PREFIX);
        String string3 = String.valueOf(string);
        if (string3.length() != 0) {
            return string2.concat(string3);
        }
        return new String(string2);
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzagZ, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaTo, TimeUnit.MILLISECONDS);
    }

    public long getActiveTime(TimeUnit timeUnit) {
        zzbo.zza((this.zzaVh != null ? 1 : 0) != 0, (Object)"Active time is not set");
        return timeUnit.convert(this.zzaVh, TimeUnit.MILLISECONDS);
    }

    public boolean hasActiveTime() {
        return this.zzaVh != null;
    }

    public boolean isOngoing() {
        return this.zzaTo == 0L;
    }

    public String getName() {
        return this.mName;
    }

    public String getIdentifier() {
        return this.zzaVf;
    }

    public String getDescription() {
        return this.zzafa;
    }

    public String getActivity() {
        return zza.getName(this.zzaTp);
    }

    public String getAppPackageName() {
        if (this.zzaVg == null) {
            return null;
        }
        return this.zzaVg.getPackageName();
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (object == this) break block2;
                if (!(object instanceof Session)) break block3;
                Session session = (Session)((Object)object);
                Session session2 = this;
                if (!(session2.zzagZ == session.zzagZ && session2.zzaTo == session.zzaTo && zzbe.equal((Object)session2.mName, (Object)session.mName) && zzbe.equal((Object)session2.zzaVf, (Object)session.zzaVf) && zzbe.equal((Object)session2.zzafa, (Object)session.zzafa) && zzbe.equal((Object)((Object)session2.zzaVg), (Object)((Object)session.zzaVg)) && session2.zzaTp == session.zzaTp)) break block3;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzagZ, this.zzaTo, this.zzaVf});
    }

    public String toString() {
        return zzbe.zzt((Object)((Object)this)).zzg("startTime", (Object)this.zzagZ).zzg("endTime", (Object)this.zzaTo).zzg("name", (Object)this.mName).zzg("identifier", (Object)this.zzaVf).zzg("description", (Object)this.zzafa).zzg("activity", (Object)this.zzaTp).zzg("application", (Object)this.zzaVg).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        Session session = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)1, (long)session.zzagZ);
        zzd.zza((Parcel)parcel2, (int)2, (long)session.zzaTo);
        zzd.zza((Parcel)parcel2, (int)3, (String)session.getName(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)4, (String)session.getIdentifier(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)5, (String)session.getDescription(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)7, (int)session.zzaTp);
        zzd.zzc((Parcel)parcel2, (int)1000, (int)session.zzaku);
        zzd.zza((Parcel)parcel2, (int)8, (Parcelable)session.zzaVg, (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)9, (Long)session.zzaVh, (boolean)false);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }

    /* synthetic */ Session(Builder builder, zzac zzac2) {
        this(builder);
    }

    public static class Builder {
        private long zzagZ = 0L;
        private long zzaTo = 0L;
        private String mName = null;
        private String zzaVf;
        private String zzafa;
        private int zzaTp = 4;
        private Long zzaVh;

        public Builder setStartTime(long l, TimeUnit timeUnit) {
            zzbo.zza((l > 0L ? 1 : 0) != 0, (Object)"Start time should be positive.");
            this.zzagZ = timeUnit.toMillis(l);
            return this;
        }

        public Builder setEndTime(long l, TimeUnit timeUnit) {
            zzbo.zza((l >= 0L ? 1 : 0) != 0, (Object)"End time should be positive.");
            this.zzaTo = timeUnit.toMillis(l);
            return this;
        }

        public Builder setName(String string) {
            zzbo.zzb((string.length() <= 100 ? 1 : 0) != 0, (String)"Session name cannot exceed %d characters", (Object[])new Object[]{100});
            this.mName = string;
            return this;
        }

        public Builder setIdentifier(String string) {
            zzbo.zzaf((string != null && TextUtils.getTrimmedLength((CharSequence)string) > 0 ? 1 : 0) != 0);
            this.zzaVf = string;
            return this;
        }

        public Builder setDescription(String string) {
            zzbo.zzb((string.length() <= 1000 ? 1 : 0) != 0, (String)"Session description cannot exceed %d characters", (Object[])new Object[]{1000});
            this.zzafa = string;
            return this;
        }

        public Builder setActivity(String string) {
            int n = zza.zzcW(string);
            Builder builder = this;
            this.zzaTp = n;
            return builder;
        }

        public Builder setActiveTime(long l, TimeUnit timeUnit) {
            this.zzaVh = timeUnit.toMillis(l);
            return this;
        }

        public Session build() {
            zzbo.zza((this.zzagZ > 0L ? 1 : 0) != 0, (Object)"Start time should be specified.");
            zzbo.zza((this.zzaTo == 0L || this.zzaTo > this.zzagZ ? 1 : 0) != 0, (Object)"End time should be later than start time.");
            if (this.zzaVf == null) {
                String string = this.mName == null ? "" : this.mName;
                long l = this.zzagZ;
                this.zzaVf = new StringBuilder(20 + String.valueOf(string).length()).append(string).append(l).toString();
            }
            if (this.zzafa == null) {
                this.zzafa = "";
            }
            return new Session(this, null);
        }
    }
}

