/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbe;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.zzau;
import com.google.android.gms.fitness.request.zzav;
import com.google.android.gms.internal.zzbxa;
import com.google.android.gms.internal.zzbxb;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SessionReadRequest
extends zza {
    private final int zzaku;
    private final String zzaXj;
    private final String mSessionId;
    private final long zzagZ;
    private final long zzaTo;
    private final List<DataType> zzaTn;
    private final List<DataSource> zzaWr;
    private boolean zzaXk;
    private final boolean zzaWC;
    private final List<String> zzaXl;
    private final zzbxa zzaXm;
    public static final Parcelable.Creator<SessionReadRequest> CREATOR = new zzav();

    SessionReadRequest(int n, String string, String string2, long l, long l2, List<DataType> list, List<DataSource> list2, boolean bl, boolean bl2, List<String> list3, IBinder iBinder) {
        this.zzaku = n;
        this.zzaXj = string;
        this.mSessionId = string2;
        this.zzagZ = l;
        this.zzaTo = l2;
        this.zzaTn = list;
        this.zzaWr = list2;
        this.zzaXk = bl;
        this.zzaWC = bl2;
        this.zzaXl = list3;
        this.zzaXm = zzbxb.zzU(iBinder);
    }

    private SessionReadRequest(Builder builder) {
        this(builder.zzaXj, builder.mSessionId, builder.zzagZ, builder.zzaTo, builder.zzaTn, builder.zzaWr, builder.zzaXk, builder.zzaWC, builder.zzaXl, null);
    }

    public SessionReadRequest(SessionReadRequest sessionReadRequest, zzbxa zzbxa2) {
        this(sessionReadRequest.zzaXj, sessionReadRequest.mSessionId, sessionReadRequest.zzagZ, sessionReadRequest.zzaTo, sessionReadRequest.zzaTn, sessionReadRequest.zzaWr, sessionReadRequest.zzaXk, sessionReadRequest.zzaWC, sessionReadRequest.zzaXl, zzbxa2);
    }

    private SessionReadRequest(String string, String string2, long l, long l2, List<DataType> list, List<DataSource> list2, boolean bl, boolean bl2, List<String> list3, zzbxa zzbxa2) {
        this(5, string, string2, l, l2, list, list2, bl, bl2, list3, zzbxa2 == null ? null : zzbxa2.asBinder());
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzagZ, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaTo, TimeUnit.MILLISECONDS);
    }

    public String getSessionName() {
        return this.zzaXj;
    }

    public String getSessionId() {
        return this.mSessionId;
    }

    public List<DataType> getDataTypes() {
        return this.zzaTn;
    }

    public List<DataSource> getDataSources() {
        return this.zzaWr;
    }

    public boolean includeSessionsFromAllApps() {
        return this.zzaXk;
    }

    public List<String> getExcludedPackages() {
        return this.zzaXl;
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof SessionReadRequest)) break block3;
                SessionReadRequest sessionReadRequest = (SessionReadRequest)((Object)object);
                SessionReadRequest sessionReadRequest2 = this;
                if (!(zzbe.equal((Object)sessionReadRequest2.zzaXj, (Object)sessionReadRequest.zzaXj) && sessionReadRequest2.mSessionId.equals(sessionReadRequest.mSessionId) && sessionReadRequest2.zzagZ == sessionReadRequest.zzagZ && sessionReadRequest2.zzaTo == sessionReadRequest.zzaTo && zzbe.equal(sessionReadRequest2.zzaTn, sessionReadRequest.zzaTn) && zzbe.equal(sessionReadRequest2.zzaWr, sessionReadRequest.zzaWr) && sessionReadRequest2.zzaXk == sessionReadRequest.zzaXk && sessionReadRequest2.zzaXl.equals(sessionReadRequest.zzaXl) && sessionReadRequest2.zzaWC == sessionReadRequest.zzaWC)) break block3;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzaXj, this.mSessionId, this.zzagZ, this.zzaTo});
    }

    public String toString() {
        return zzbe.zzt((Object)((Object)this)).zzg("sessionName", (Object)this.zzaXj).zzg("sessionId", (Object)this.mSessionId).zzg("startTimeMillis", (Object)this.zzagZ).zzg("endTimeMillis", (Object)this.zzaTo).zzg("dataTypes", this.zzaTn).zzg("dataSources", this.zzaWr).zzg("sessionsFromAllApps", (Object)this.zzaXk).zzg("excludedPackages", this.zzaXl).zzg("useServer", (Object)this.zzaWC).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        SessionReadRequest sessionReadRequest = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)1, (String)sessionReadRequest.getSessionName(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)2, (String)sessionReadRequest.getSessionId(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)3, (long)sessionReadRequest.zzagZ);
        zzd.zza((Parcel)parcel2, (int)4, (long)sessionReadRequest.zzaTo);
        zzd.zzc((Parcel)parcel2, (int)5, sessionReadRequest.getDataTypes(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)6, sessionReadRequest.getDataSources(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)7, (boolean)sessionReadRequest.zzaXk);
        zzd.zzc((Parcel)parcel2, (int)1000, (int)sessionReadRequest.zzaku);
        zzd.zza((Parcel)parcel2, (int)8, (boolean)sessionReadRequest.zzaWC);
        zzd.zzb((Parcel)parcel2, (int)9, sessionReadRequest.getExcludedPackages(), (boolean)false);
        SessionReadRequest sessionReadRequest2 = sessionReadRequest;
        zzd.zza((Parcel)parcel2, (int)10, (IBinder)(sessionReadRequest2.zzaXm == null ? null : sessionReadRequest2.zzaXm.asBinder()), (boolean)false);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }

    /* synthetic */ SessionReadRequest(Builder builder, zzau zzau2) {
        this(builder);
    }

    public static class Builder {
        private String zzaXj;
        private String mSessionId;
        private long zzagZ = 0L;
        private long zzaTo = 0L;
        private List<DataType> zzaTn = new ArrayList<DataType>();
        private List<DataSource> zzaWr = new ArrayList<DataSource>();
        private boolean zzaXk = false;
        private boolean zzaWC = false;
        private List<String> zzaXl = new ArrayList<String>();

        public Builder setTimeInterval(long l, long l2, TimeUnit timeUnit) {
            this.zzagZ = timeUnit.toMillis(l);
            this.zzaTo = timeUnit.toMillis(l2);
            return this;
        }

        public Builder setSessionName(String string) {
            this.zzaXj = string;
            return this;
        }

        public Builder setSessionId(String string) {
            this.mSessionId = string;
            return this;
        }

        public Builder read(DataSource dataSource) {
            zzbo.zzb((Object)((Object)dataSource), (Object)"Attempting to add a null data source");
            if (!this.zzaWr.contains((Object)dataSource)) {
                this.zzaWr.add(dataSource);
            }
            return this;
        }

        public Builder read(DataType dataType) {
            zzbo.zzb((Object)((Object)dataType), (Object)"Attempting to use a null data type");
            if (!this.zzaTn.contains((Object)dataType)) {
                this.zzaTn.add(dataType);
            }
            return this;
        }

        public Builder readSessionsFromAllApps() {
            this.zzaXk = true;
            return this;
        }

        public Builder excludePackage(String string) {
            zzbo.zzb((Object)string, (Object)"Attempting to use a null package name");
            if (!this.zzaXl.contains(string)) {
                this.zzaXl.add(string);
            }
            return this;
        }

        public Builder enableServerQueries() {
            this.zzaWC = true;
            return this;
        }

        public SessionReadRequest build() {
            zzbo.zzb((this.zzagZ > 0L ? 1 : 0) != 0, (String)"Invalid start time: %s", (Object[])new Object[]{this.zzagZ});
            zzbo.zzb((this.zzaTo > 0L && this.zzaTo > this.zzagZ ? 1 : 0) != 0, (String)"Invalid end time: %s", (Object[])new Object[]{this.zzaTo});
            return new SessionReadRequest(this, null);
        }
    }
}

