/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.result;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbe;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.data.zzae;
import com.google.android.gms.fitness.result.zzh;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class SessionReadResult
extends zza
implements Result {
    private final int zzaku;
    private final List<Session> zzaWs;
    private final List<zzae> zzaXB;
    private final Status mStatus;
    public static final Parcelable.Creator<SessionReadResult> CREATOR = new zzh();

    SessionReadResult(int n, List<Session> list, List<zzae> list2, Status status) {
        this.zzaku = n;
        this.zzaWs = list;
        this.zzaXB = Collections.unmodifiableList(list2);
        this.mStatus = status;
    }

    private SessionReadResult(List<Session> list, List<zzae> list2, Status status) {
        this.zzaku = 3;
        this.zzaWs = list;
        this.zzaXB = Collections.unmodifiableList(list2);
        this.mStatus = status;
    }

    public static SessionReadResult zzE(Status status) {
        ArrayList<Session> arrayList = new ArrayList<Session>();
        ArrayList<zzae> arrayList2 = new ArrayList<zzae>();
        return new SessionReadResult(arrayList, arrayList2, status);
    }

    public List<Session> getSessions() {
        return this.zzaWs;
    }

    public List<DataSet> getDataSet(Session session, DataType dataType) {
        zzbo.zzb((boolean)this.zzaWs.contains((Object)session), (String)"Attempting to read data for session %s which was not returned", (Object[])new Object[]{session});
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>();
        for (zzae zzae2 : this.zzaXB) {
            if (!zzbe.equal((Object)((Object)session), (Object)((Object)zzae2.getSession())) || !dataType.equals((Object)zzae2.getDataSet().getDataType())) continue;
            arrayList.add(zzae2.getDataSet());
        }
        return arrayList;
    }

    public List<DataSet> getDataSet(Session session) {
        zzbo.zzb((boolean)this.zzaWs.contains((Object)session), (String)"Attempting to read data for session %s which was not returned", (Object[])new Object[]{session});
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>();
        for (zzae zzae2 : this.zzaXB) {
            if (!zzbe.equal((Object)((Object)session), (Object)((Object)zzae2.getSession()))) continue;
            arrayList.add(zzae2.getDataSet());
        }
        return arrayList;
    }

    public Status getStatus() {
        return this.mStatus;
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof SessionReadResult)) break block3;
                SessionReadResult sessionReadResult = (SessionReadResult)((Object)object);
                SessionReadResult sessionReadResult2 = this;
                if (!(sessionReadResult2.mStatus.equals((Object)sessionReadResult.mStatus) && zzbe.equal(sessionReadResult2.zzaWs, sessionReadResult.zzaWs) && zzbe.equal(sessionReadResult2.zzaXB, sessionReadResult.zzaXB))) break block3;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.mStatus, this.zzaWs, this.zzaXB});
    }

    public String toString() {
        return zzbe.zzt((Object)((Object)this)).zzg("status", (Object)this.mStatus).zzg("sessions", this.zzaWs).zzg("sessionDataSets", this.zzaXB).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        SessionReadResult sessionReadResult = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zzc((Parcel)parcel2, (int)1, sessionReadResult.getSessions(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)2, sessionReadResult.zzaXB, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)3, (Parcelable)sessionReadResult.getStatus(), (int)n, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)1000, (int)sessionReadResult.zzaku);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }
}

