/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbe;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.zzab;
import com.google.android.gms.fitness.request.zzac;
import com.google.android.gms.fitness.zza;
import com.google.android.gms.internal.zzbuf;
import com.google.android.gms.internal.zzbwe;
import com.google.android.gms.internal.zzbwf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GoalsReadRequest
extends com.google.android.gms.common.internal.safeparcel.zza {
    private final int versionCode;
    private final zzbwe zzaWN;
    private final List<DataType> zzaWO;
    private final List<Integer> zzaWP;
    private final List<Integer> zzaUJ;
    public static final Parcelable.Creator<GoalsReadRequest> CREATOR = new zzac();

    public List<DataType> getDataTypes() {
        return this.zzaWO;
    }

    public List<Integer> getObjectiveTypes() {
        if (this.zzaWP.isEmpty()) {
            return null;
        }
        return this.zzaWP;
    }

    public List<String> getActivityNames() {
        if (this.zzaUJ.isEmpty()) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int n : this.zzaUJ) {
            arrayList.add(zza.getName(n));
        }
        return arrayList;
    }

    GoalsReadRequest(int n, IBinder iBinder, List<DataType> list, List<Integer> list2, List<Integer> list3) {
        this.versionCode = n;
        this.zzaWN = iBinder == null ? null : zzbwf.zzS(iBinder);
        this.zzaWO = list;
        this.zzaWP = list2;
        this.zzaUJ = list3;
    }

    private GoalsReadRequest(Builder builder) {
        this(null, builder.zzaWO, builder.zzaWP, builder.zzaUJ);
    }

    public GoalsReadRequest(GoalsReadRequest goalsReadRequest, zzbwe zzbwe2) {
        this(zzbwe2, goalsReadRequest.getDataTypes(), goalsReadRequest.zzaWP, goalsReadRequest.zzaUJ);
    }

    private GoalsReadRequest(zzbwe zzbwe2, List<DataType> list, List<Integer> list2, List<Integer> list3) {
        this(1, zzbwe2 == null ? null : zzbwe2.asBinder(), list, list2, list3);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof GoalsReadRequest)) break block3;
                GoalsReadRequest goalsReadRequest = (GoalsReadRequest)((Object)object);
                GoalsReadRequest goalsReadRequest2 = this;
                if (!(zzbe.equal(goalsReadRequest2.zzaWO, goalsReadRequest.zzaWO) && zzbe.equal(goalsReadRequest2.zzaWP, goalsReadRequest.zzaWP) && zzbe.equal(goalsReadRequest2.zzaUJ, goalsReadRequest.zzaUJ))) break block3;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzaWO, this.zzaWP, this.getActivityNames()});
    }

    public String toString() {
        return zzbe.zzt((Object)((Object)this)).zzg("dataTypes", this.zzaWO).zzg("objectiveTypes", this.zzaWP).zzg("activities", this.getActivityNames()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GoalsReadRequest goalsReadRequest = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)1, (IBinder)goalsReadRequest.zzaWN.asBinder(), (boolean)false);
        zzd.zzd((Parcel)parcel2, (int)2, goalsReadRequest.getDataTypes(), (boolean)false);
        zzd.zzd((Parcel)parcel2, (int)3, goalsReadRequest.zzaWP, (boolean)false);
        zzd.zzd((Parcel)parcel2, (int)4, goalsReadRequest.zzaUJ, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)1000, (int)goalsReadRequest.versionCode);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }

    /* synthetic */ GoalsReadRequest(Builder builder, zzab zzab2) {
        this(builder);
    }

    public static class Builder {
        private final List<DataType> zzaWO = new ArrayList<DataType>();
        private final List<Integer> zzaWP = new ArrayList<Integer>();
        private final List<Integer> zzaUJ = new ArrayList<Integer>();

        public Builder addDataType(DataType dataType) {
            zzbo.zzb((Object)((Object)dataType), (Object)"Attempting to use a null data type");
            if (!this.zzaWO.contains((Object)dataType)) {
                this.zzaWO.add(dataType);
            }
            return this;
        }

        public Builder addActivity(String string) {
            int n = zza.zzcW(string);
            zzbo.zza((n != 4 ? 1 : 0) != 0, (Object)"Attempting to add an unknown activity");
            zzbuf.zza(n, this.zzaUJ);
            return this;
        }

        public Builder addObjectiveType(int n) {
            zzbo.zza((n == 1 || n == 2 || n == 3 ? 1 : 0) != 0, (Object)"Attempting to add an invalid objective type");
            if (!this.zzaWP.contains(n)) {
                this.zzaWP.add(n);
            }
            return this;
        }

        public GoalsReadRequest build() {
            zzbo.zza((!this.zzaWO.isEmpty() ? 1 : 0) != 0, (Object)"At least one data type should be specified.");
            return new GoalsReadRequest(this, null);
        }
    }
}

