/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fitness.data.Bucket;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Device;
import com.google.android.gms.fitness.request.zzm;
import com.google.android.gms.fitness.request.zzn;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import com.google.android.gms.internal.zzbyk;
import com.google.android.gms.internal.zzbyl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class DataReadRequest
extends zzbgl {
    public static final int NO_LIMIT = 0;
    private final List<DataType> zza;
    private final List<DataSource> zzb;
    private final long zzc;
    private final long zzd;
    private final List<DataType> zze;
    private final List<DataSource> zzf;
    private final int zzg;
    private final long zzh;
    private final DataSource zzi;
    private final int zzj;
    private final boolean zzk;
    private final boolean zzl;
    @Nullable
    private final zzbyk zzm;
    private final List<Device> zzn;
    private final List<Integer> zzo;
    public static final Parcelable.Creator<DataReadRequest> CREATOR = new zzn();

    @Hide
    DataReadRequest(List<DataType> list, List<DataSource> list2, long l, long l2, List<DataType> list3, List<DataSource> list4, int n, long l3, DataSource dataSource, int n2, boolean bl, boolean bl2, IBinder iBinder, List<Device> list5, List<Integer> list6) {
        this.zza = list;
        this.zzb = list2;
        this.zzc = l;
        this.zzd = l2;
        this.zze = list3;
        this.zzf = list4;
        this.zzg = n;
        this.zzh = l3;
        this.zzi = dataSource;
        this.zzj = n2;
        this.zzk = bl;
        this.zzl = bl2;
        this.zzm = iBinder == null ? null : zzbyl.zza(iBinder);
        this.zzn = list5 == null ? Collections.emptyList() : list5;
        this.zzo = list6 == null ? Collections.emptyList() : list6;
    }

    private DataReadRequest(Builder builder) {
        this((List<DataType>)builder.zza, (List<DataSource>)builder.zzb, builder.zzf, builder.zzg, (List<DataType>)builder.zzc, (List<DataSource>)builder.zzd, builder.zzh, builder.zzi, builder.zze, builder.zzj, false, builder.zzl, (zzbyk)null, (List<Device>)builder.zzm, (List<Integer>)builder.zzn);
    }

    @Hide
    public DataReadRequest(DataReadRequest dataReadRequest, zzbyk zzbyk2) {
        this(dataReadRequest.zza, dataReadRequest.zzb, dataReadRequest.zzc, dataReadRequest.zzd, dataReadRequest.zze, dataReadRequest.zzf, dataReadRequest.zzg, dataReadRequest.zzh, dataReadRequest.zzi, dataReadRequest.zzj, dataReadRequest.zzk, dataReadRequest.zzl, zzbyk2, dataReadRequest.zzn, dataReadRequest.zzo);
    }

    @Hide
    private DataReadRequest(List<DataType> list, List<DataSource> list2, long l, long l2, List<DataType> list3, List<DataSource> list4, int n, long l3, DataSource dataSource, int n2, boolean bl, boolean bl2, @Nullable zzbyk zzbyk2, List<Device> list5, List<Integer> list6) {
        this(list, list2, l, l2, list3, list4, n, l3, dataSource, n2, bl, bl2, zzbyk2 == null ? null : zzbyk2.asBinder(), list5, list6);
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzc, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzd, TimeUnit.MILLISECONDS);
    }

    public List<DataType> getDataTypes() {
        return this.zza;
    }

    public List<DataSource> getDataSources() {
        return this.zzb;
    }

    public List<DataType> getAggregatedDataTypes() {
        return this.zze;
    }

    public List<DataSource> getAggregatedDataSources() {
        return this.zzf;
    }

    public int getBucketType() {
        return this.zzg;
    }

    public long getBucketDuration(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzh, TimeUnit.MILLISECONDS);
    }

    @Nullable
    public DataSource getActivityDataSource() {
        return this.zzi;
    }

    public int getLimit() {
        return this.zzj;
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof DataReadRequest)) break block3;
                DataReadRequest dataReadRequest = (DataReadRequest)((Object)object);
                DataReadRequest dataReadRequest2 = this;
                if (!(dataReadRequest2.zza.equals(dataReadRequest.zza) && dataReadRequest2.zzb.equals(dataReadRequest.zzb) && dataReadRequest2.zzc == dataReadRequest.zzc && dataReadRequest2.zzd == dataReadRequest.zzd && dataReadRequest2.zzg == dataReadRequest.zzg && dataReadRequest2.zzf.equals(dataReadRequest.zzf) && dataReadRequest2.zze.equals(dataReadRequest.zze) && zzbg.zza((Object)((Object)dataReadRequest2.zzi), (Object)((Object)dataReadRequest.zzi)) && dataReadRequest2.zzh == dataReadRequest.zzh && dataReadRequest2.zzl == dataReadRequest.zzl && dataReadRequest2.zzj == dataReadRequest.zzj && dataReadRequest2.zzk == dataReadRequest.zzk && zzbg.zza((Object)dataReadRequest2.zzm, (Object)dataReadRequest.zzm) && zzbg.zza(dataReadRequest2.zzn, dataReadRequest.zzn) && zzbg.zza(dataReadRequest2.zzo, dataReadRequest.zzo))) break block3;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzg, this.zzc, this.zzd});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DataReadRequest{");
        if (!this.zza.isEmpty()) {
            for (DataType zzbgl2 : this.zza) {
                stringBuilder.append(zzbgl2.zzc()).append(" ");
            }
        }
        if (!this.zzb.isEmpty()) {
            for (DataSource dataSource : this.zzb) {
                stringBuilder.append(dataSource.zzb()).append(" ");
            }
        }
        if (this.zzg != 0) {
            stringBuilder.append("bucket by ").append(Bucket.zza(this.zzg));
            if (this.zzh > 0L) {
                stringBuilder.append(" >").append(this.zzh).append("ms");
            }
            stringBuilder.append(": ");
        }
        if (!this.zze.isEmpty()) {
            for (DataType dataType : this.zze) {
                stringBuilder.append(dataType.zzc()).append(" ");
            }
        }
        if (!this.zzf.isEmpty()) {
            for (DataSource dataSource : this.zzf) {
                stringBuilder.append(dataSource.zzb()).append(" ");
            }
        }
        stringBuilder.append(String.format("(%tF %tT - %tF %tT)", this.zzc, this.zzc, this.zzd, this.zzd));
        if (this.zzi != null) {
            stringBuilder.append("activities: ").append(this.zzi.zzb());
        }
        if (!this.zzo.isEmpty()) {
            stringBuilder.append("quality: ");
            Iterator<Object> iterator = this.zzo.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                stringBuilder.append(DataSource.zza(n)).append(" ");
            }
        }
        if (this.zzl) {
            stringBuilder.append(" +server");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public List<Integer> getFilteredDataQualityStandards() {
        return this.zzo;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        DataReadRequest dataReadRequest = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zzc((Parcel)parcel2, (int)1, dataReadRequest.getDataTypes(), (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)2, dataReadRequest.getDataSources(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)3, (long)dataReadRequest.zzc);
        zzbgo.zza((Parcel)parcel2, (int)4, (long)dataReadRequest.zzd);
        zzbgo.zzc((Parcel)parcel2, (int)5, dataReadRequest.getAggregatedDataTypes(), (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)6, dataReadRequest.getAggregatedDataSources(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)7, (int)dataReadRequest.getBucketType());
        zzbgo.zza((Parcel)parcel2, (int)8, (long)dataReadRequest.zzh);
        zzbgo.zza((Parcel)parcel2, (int)9, (Parcelable)dataReadRequest.getActivityDataSource(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)10, (int)dataReadRequest.getLimit());
        zzbgo.zza((Parcel)parcel2, (int)12, (boolean)dataReadRequest.zzk);
        zzbgo.zza((Parcel)parcel2, (int)13, (boolean)dataReadRequest.zzl);
        DataReadRequest dataReadRequest2 = dataReadRequest;
        zzbgo.zza((Parcel)parcel2, (int)14, (IBinder)(dataReadRequest2.zzm == null ? null : dataReadRequest2.zzm.asBinder()), (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)16, dataReadRequest.zzn, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)17, dataReadRequest.getFilteredDataQualityStandards(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)n2);
    }

    /* synthetic */ DataReadRequest(Builder builder, zzm zzm2) {
        this(builder);
    }

    public static class Builder {
        private List<DataType> zza = new ArrayList<DataType>();
        private List<DataSource> zzb = new ArrayList<DataSource>();
        private List<DataType> zzc = new ArrayList<DataType>();
        private List<DataSource> zzd = new ArrayList<DataSource>();
        private DataSource zze;
        private long zzf;
        private long zzg;
        private int zzh = 0;
        private long zzi = 0L;
        private int zzj = 0;
        private boolean zzk = false;
        private boolean zzl = false;
        private final List<Device> zzm = new ArrayList<Device>();
        private final List<Integer> zzn = new ArrayList<Integer>();

        public Builder() {
        }

        public Builder read(DataSource dataSource) {
            zzbq.zza((Object)((Object)dataSource), (Object)"Attempting to add a null data source");
            zzbq.zzb((!this.zzd.contains((Object)dataSource) ? 1 : 0) != 0, (Object)"Cannot add the same data source as aggregated and detailed");
            if (!this.zzb.contains((Object)dataSource)) {
                this.zzb.add(dataSource);
            }
            return this;
        }

        public Builder read(DataType dataType) {
            zzbq.zza((Object)((Object)dataType), (Object)"Attempting to use a null data type");
            zzbq.zza((!this.zzc.contains((Object)dataType) ? 1 : 0) != 0, (Object)"Cannot add the same data type as aggregated and detailed");
            if (!this.zza.contains((Object)dataType)) {
                this.zza.add(dataType);
            }
            return this;
        }

        public Builder aggregate(DataSource dataSource, DataType dataType) {
            zzbq.zza((Object)((Object)dataSource), (Object)"Attempting to add a null data source");
            zzbq.zza((!this.zzb.contains((Object)dataSource) ? 1 : 0) != 0, (Object)"Cannot add the same data source for aggregated and detailed");
            DataType dataType2 = dataSource.getDataType();
            List<DataType> list = DataType.getAggregatesForInput(dataType2);
            zzbq.zzb((!list.isEmpty() ? 1 : 0) != 0, (String)"Unsupported input data type specified for aggregation: %s", (Object[])new Object[]{dataType2});
            zzbq.zzb((boolean)list.contains((Object)dataType), (String)"Invalid output aggregate data type specified: %s -> %s", (Object[])new Object[]{dataType2, dataType});
            if (!this.zzd.contains((Object)dataSource)) {
                this.zzd.add(dataSource);
            }
            return this;
        }

        public Builder aggregate(DataType dataType, DataType dataType2) {
            zzbq.zza((Object)((Object)dataType), (Object)"Attempting to use a null data type");
            zzbq.zza((!this.zza.contains((Object)dataType) ? 1 : 0) != 0, (Object)"Cannot add the same data type as aggregated and detailed");
            List<DataType> list = DataType.getAggregatesForInput(dataType);
            zzbq.zzb((!list.isEmpty() ? 1 : 0) != 0, (String)"Unsupported input data type specified for aggregation: %s", (Object[])new Object[]{dataType});
            zzbq.zzb((boolean)list.contains((Object)dataType2), (String)"Invalid output aggregate data type specified: %s -> %s", (Object[])new Object[]{dataType, dataType2});
            if (!this.zzc.contains((Object)dataType)) {
                this.zzc.add(dataType);
            }
            return this;
        }

        public Builder bucketByTime(int n, TimeUnit timeUnit) {
            zzbq.zzb((this.zzh == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzh});
            zzbq.zzb((n > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{n});
            this.zzh = 1;
            this.zzi = timeUnit.toMillis(n);
            return this;
        }

        public Builder bucketByActivityType(int n, TimeUnit timeUnit) {
            zzbq.zzb((this.zzh == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzh});
            zzbq.zzb((n > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{n});
            this.zzh = 3;
            this.zzi = timeUnit.toMillis(n);
            return this;
        }

        public Builder bucketByActivityType(int n, TimeUnit timeUnit, DataSource dataSource) {
            zzbq.zzb((this.zzh == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzh});
            zzbq.zzb((n > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{n});
            zzbq.zzb((dataSource != null ? 1 : 0) != 0, (Object)"Invalid activity data source specified");
            zzbq.zzb((boolean)dataSource.getDataType().equals((Object)DataType.TYPE_ACTIVITY_SEGMENT), (String)"Invalid activity data source specified: %s", (Object[])new Object[]{dataSource});
            this.zze = dataSource;
            this.zzh = 3;
            this.zzi = timeUnit.toMillis(n);
            return this;
        }

        public Builder addFilteredDataQualityStandard(int n) {
            zzbq.zzb((boolean)this.zzm.isEmpty(), (Object)"Cannot add data quality standard filter when filtering by device.");
            this.zzn.add(n);
            return this;
        }

        public Builder bucketByActivitySegment(int n, TimeUnit timeUnit) {
            zzbq.zzb((this.zzh == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzh});
            zzbq.zzb((n > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{n});
            this.zzh = 4;
            this.zzi = timeUnit.toMillis(n);
            return this;
        }

        public Builder bucketByActivitySegment(int n, TimeUnit timeUnit, DataSource dataSource) {
            zzbq.zzb((this.zzh == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzh});
            zzbq.zzb((n > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{n});
            zzbq.zzb((dataSource != null ? 1 : 0) != 0, (Object)"Invalid activity data source specified");
            zzbq.zzb((boolean)dataSource.getDataType().equals((Object)DataType.TYPE_ACTIVITY_SEGMENT), (String)"Invalid activity data source specified: %s", (Object[])new Object[]{dataSource});
            this.zze = dataSource;
            this.zzh = 4;
            this.zzi = timeUnit.toMillis(n);
            return this;
        }

        public Builder bucketBySession(int n, TimeUnit timeUnit) {
            zzbq.zzb((this.zzh == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzh});
            zzbq.zzb((n > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{n});
            this.zzh = 2;
            this.zzi = timeUnit.toMillis(n);
            return this;
        }

        public Builder setTimeRange(long l, long l2, TimeUnit timeUnit) {
            this.zzf = timeUnit.toMillis(l);
            this.zzg = timeUnit.toMillis(l2);
            return this;
        }

        public Builder enableServerQueries() {
            this.zzl = true;
            return this;
        }

        public Builder setLimit(int n) {
            zzbq.zzb((n > 0 ? 1 : 0) != 0, (String)"Invalid limit %d is specified", (Object[])new Object[]{n});
            this.zzj = n;
            return this;
        }

        public DataReadRequest build() {
            zzbq.zza((!this.zzb.isEmpty() || !this.zza.isEmpty() || !this.zzd.isEmpty() || !this.zzc.isEmpty() ? 1 : 0) != 0, (Object)"Must add at least one data source (aggregated or detailed)");
            zzbq.zza((this.zzf > 0L ? 1 : 0) != 0, (String)"Invalid start time: %s", (Object[])new Object[]{this.zzf});
            zzbq.zza((this.zzg > 0L && this.zzg > this.zzf ? 1 : 0) != 0, (String)"Invalid end time: %s", (Object[])new Object[]{this.zzg});
            boolean bl = this.zzd.isEmpty() && this.zzc.isEmpty();
            zzbq.zza((bl && this.zzh == 0 || !bl && this.zzh != 0 ? 1 : 0) != 0, (Object)"Must specify a valid bucketing strategy while requesting aggregation");
            return new DataReadRequest(this, null);
        }
    }
}

