/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.SystemClock;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.zzaq;
import com.google.android.gms.location.LocationRequest;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

public class SensorRequest {
    public static final int ACCURACY_MODE_LOW = 1;
    public static final int ACCURACY_MODE_DEFAULT = 2;
    public static final int ACCURACY_MODE_HIGH = 3;
    private final DataSource zza;
    private final DataType zzb;
    private final long zzc;
    private final long zzd;
    private final long zze;
    private final int zzf;
    private final long zzg;

    private SensorRequest(Builder builder) {
        this.zza = builder.zza;
        this.zzb = builder.zzb;
        this.zzc = builder.zzc;
        this.zzd = builder.zzd;
        this.zze = builder.zze;
        this.zzf = builder.zzg;
        this.zzg = builder.zzh;
    }

    private SensorRequest(DataSource dataSource, LocationRequest locationRequest) {
        int n;
        this.zzc = TimeUnit.MILLISECONDS.toMicros(locationRequest.getInterval());
        this.zzd = TimeUnit.MILLISECONDS.toMicros(locationRequest.getFastestInterval());
        this.zze = this.zzc;
        this.zzb = dataSource.getDataType();
        switch (locationRequest.getPriority()) {
            case 100: {
                n = 3;
                break;
            }
            case 104: {
                n = 1;
                break;
            }
            default: {
                n = 2;
            }
        }
        this.zzf = n;
        this.zza = dataSource;
        long l = locationRequest.getExpirationTime();
        if (l == Long.MAX_VALUE) {
            this.zzg = Long.MAX_VALUE;
            return;
        }
        this.zzg = TimeUnit.MILLISECONDS.toMicros(l - SystemClock.elapsedRealtime());
    }

    public static SensorRequest fromLocationRequest(DataSource dataSource, LocationRequest locationRequest) {
        return new SensorRequest(dataSource, locationRequest);
    }

    @Nullable
    public DataSource getDataSource() {
        return this.zza;
    }

    public DataType getDataType() {
        return this.zzb;
    }

    public long getSamplingRate(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzc, TimeUnit.MICROSECONDS);
    }

    public long getFastestRate(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzd, TimeUnit.MICROSECONDS);
    }

    public long getMaxDeliveryLatency(TimeUnit timeUnit) {
        return timeUnit.convert(this.zze, TimeUnit.MICROSECONDS);
    }

    public int getAccuracyMode() {
        return this.zzf;
    }

    @Hide
    public final long zza() {
        return this.zzg;
    }

    public String toString() {
        return zzbg.zza((Object)this).zza("dataSource", (Object)this.zza).zza("dataType", (Object)this.zzb).zza("samplingRateMicros", (Object)this.zzc).zza("deliveryLatencyMicros", (Object)this.zze).zza("timeOutMicros", (Object)this.zzg).toString();
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof SensorRequest)) break block3;
                SensorRequest sensorRequest = (SensorRequest)object;
                SensorRequest sensorRequest2 = this;
                if (!(zzbg.zza((Object)((Object)sensorRequest2.zza), (Object)((Object)sensorRequest.zza)) && zzbg.zza((Object)((Object)sensorRequest2.zzb), (Object)((Object)sensorRequest.zzb)) && sensorRequest2.zzc == sensorRequest.zzc && sensorRequest2.zzd == sensorRequest.zzd && sensorRequest2.zze == sensorRequest.zze && sensorRequest2.zzf == sensorRequest.zzf && sensorRequest2.zzg == sensorRequest.zzg)) break block3;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zza, this.zzb, this.zzc, this.zzd, this.zze, this.zzf, this.zzg});
    }

    /* synthetic */ SensorRequest(Builder builder, zzaq zzaq2) {
        this(builder);
    }

    public static class Builder {
        private DataSource zza;
        private DataType zzb;
        private long zzc = -1L;
        private long zzd = 0L;
        private long zze = 0L;
        private boolean zzf = false;
        private int zzg = 2;
        private long zzh = Long.MAX_VALUE;

        public Builder() {
        }

        public Builder setDataSource(DataSource dataSource) {
            this.zza = dataSource;
            return this;
        }

        public Builder setDataType(DataType dataType) {
            this.zzb = dataType;
            return this;
        }

        public Builder setSamplingRate(long l, TimeUnit timeUnit) {
            zzbq.zzb((l >= 0L ? 1 : 0) != 0, (Object)"Cannot use a negative sampling interval");
            this.zzc = timeUnit.toMicros(l);
            if (!this.zzf) {
                this.zzd = this.zzc / 2L;
            }
            return this;
        }

        public Builder setFastestRate(int n, TimeUnit timeUnit) {
            zzbq.zzb((n >= 0 ? 1 : 0) != 0, (Object)"Cannot use a negative interval");
            this.zzf = true;
            this.zzd = timeUnit.toMicros(n);
            return this;
        }

        public Builder setMaxDeliveryLatency(int n, TimeUnit timeUnit) {
            zzbq.zzb((n >= 0 ? 1 : 0) != 0, (Object)"Cannot use a negative delivery interval");
            this.zze = timeUnit.toMicros(n);
            return this;
        }

        public Builder setAccuracyMode(int n) {
            int n2;
            switch (n) {
                case 1: 
                case 3: {
                    n2 = n;
                    break;
                }
                default: {
                    n2 = 2;
                }
            }
            this.zzg = n2;
            return this;
        }

        public Builder setTimeout(long l, TimeUnit timeUnit) {
            zzbq.zzb((l > 0L ? 1 : 0) != 0, (String)"Invalid time out value specified: %d", (Object[])new Object[]{l});
            zzbq.zzb((timeUnit != null ? 1 : 0) != 0, (Object)"Invalid time unit specified");
            this.zzh = timeUnit.toMicros(l);
            return this;
        }

        public SensorRequest build() {
            zzbq.zza((this.zza != null || this.zzb != null ? 1 : 0) != 0, (Object)"Must call setDataSource() or setDataType()");
            zzbq.zza((this.zzb == null || this.zza == null || this.zzb.equals((Object)this.zza.getDataType()) ? 1 : 0) != 0, (Object)"Specified data type is incompatible with specified data source");
            return new SensorRequest(this, null);
        }
    }
}

