/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.Context;
import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.zzc;
import com.google.android.gms.common.internal.zzv;
import com.google.android.gms.fitness.data.Application;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Device;
import com.google.android.gms.fitness.data.zzf;

public class DataSource
implements SafeParcelable {
    public static final String EXTRA_DATA_SOURCE = "vnd.google.fitness.data_source";
    public static final int TYPE_RAW = 0;
    public static final int TYPE_DERIVED = 1;
    private final int zzzH;
    private final DataType zzacC;
    private final String mName;
    private final int zzMG;
    private final Device zzadb;
    private final Application zzadc;
    private final String zzadd;
    private final String zzade;
    public static final Parcelable.Creator<DataSource> CREATOR = new zzf();

    DataSource(int versionCode, DataType dataType, String name, int type, Device device, Application application, String streamName) {
        this.zzzH = versionCode;
        this.zzacC = dataType;
        this.zzMG = type;
        this.mName = name;
        this.zzadb = device;
        this.zzadc = application;
        this.zzadd = streamName;
        this.zzade = this.zzoN();
    }

    private DataSource(Builder builder) {
        this.zzzH = 3;
        this.zzacC = builder.zzacC;
        this.zzMG = builder.zzMG;
        this.mName = builder.mName;
        this.zzadb = builder.zzadb;
        this.zzadc = builder.zzadc;
        this.zzadd = builder.zzadd;
        this.zzade = this.zzoN();
    }

    public static DataSource extract(Intent intent) {
        if (intent == null) {
            return null;
        }
        return (DataSource)zzc.zza((Intent)intent, (String)EXTRA_DATA_SOURCE, CREATOR);
    }

    public DataType getDataType() {
        return this.zzacC;
    }

    public int getType() {
        return this.zzMG;
    }

    public String getName() {
        return this.mName;
    }

    public String getAppPackageName() {
        return this.zzadc == null ? null : this.zzadc.getPackageName();
    }

    public Application zzoM() {
        return this.zzadc;
    }

    public Device getDevice() {
        return this.zzadb;
    }

    public String getStreamName() {
        return this.zzadd;
    }

    public String getStreamIdentifier() {
        return this.zzade;
    }

    private String zzoN() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getTypeString());
        stringBuilder.append(":").append(this.zzacC.getName());
        if (this.zzadc != null) {
            stringBuilder.append(":").append(this.zzadc.getPackageName());
        }
        if (this.zzadb != null) {
            stringBuilder.append(":").append(this.zzadb.getStreamIdentifier());
        }
        if (this.zzadd != null) {
            stringBuilder.append(":").append(this.zzadd);
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object that) {
        return this == that || that instanceof DataSource && this.zza((DataSource)that);
    }

    private boolean zza(DataSource dataSource) {
        return this.zzade.equals(dataSource.zzade);
    }

    public int hashCode() {
        return this.zzade.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("DataSource{");
        stringBuilder.append(this.getTypeString());
        if (this.mName != null) {
            stringBuilder.append(":").append(this.mName);
        }
        if (this.zzadc != null) {
            stringBuilder.append(":").append(this.zzadc);
        }
        if (this.zzadb != null) {
            stringBuilder.append(":").append(this.zzadb);
        }
        if (this.zzadd != null) {
            stringBuilder.append(":").append(this.zzadd);
        }
        stringBuilder.append(":").append(this.zzacC);
        return stringBuilder.append("}").toString();
    }

    public String toDebugString() {
        return (this.zzMG == 0 ? "r" : "d") + ":" + this.zzacC.zzoO() + (this.zzadc == null ? "" : (this.zzadc.equals(Application.zzacJ) ? ":gms" : ":" + this.zzadc.getPackageName())) + (this.zzadb != null ? ":" + this.zzadb.getModel() + ":" + this.zzadb.getUid() : "") + (this.zzadd != null ? ":" + this.zzadd : "");
    }

    private String getTypeString() {
        switch (this.zzMG) {
            case 0: {
                return "raw";
            }
            case 1: {
                return "derived";
            }
        }
        throw new IllegalArgumentException("invalid type value");
    }

    int getVersionCode() {
        return this.zzzH;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zzf.zza(this, parcel, flags);
    }

    public static final class Builder {
        private DataType zzacC;
        private int zzMG = -1;
        private String mName;
        private Device zzadb;
        private Application zzadc;
        private String zzadd = "";

        public Builder setDataType(DataType dataType) {
            this.zzacC = dataType;
            return this;
        }

        public Builder setType(int type) {
            this.zzMG = type;
            return this;
        }

        public Builder setName(String name) {
            this.mName = name;
            return this;
        }

        public Builder setDevice(Device device) {
            this.zzadb = device;
            return this;
        }

        public Builder setAppPackageName(String packageName) {
            this.zzadc = Application.zzcm(packageName);
            return this;
        }

        public Builder setAppPackageName(Context appContext) {
            return this.setAppPackageName(appContext.getPackageName());
        }

        public Builder setStreamName(String streamName) {
            zzv.zzb((streamName != null ? 1 : 0) != 0, (Object)"Must specify a valid stream name");
            this.zzadd = streamName;
            return this;
        }

        public DataSource build() {
            zzv.zza((this.zzacC != null ? 1 : 0) != 0, (Object)"Must set data type");
            zzv.zza((this.zzMG >= 0 ? 1 : 0) != 0, (Object)"Must set data source type");
            return new DataSource(this);
        }
    }
}

