/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.fitness.data.Bucket;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.data.zzm;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class RawBucket
implements SafeParcelable {
    final int zzzH;
    public final long zzGX;
    public final long zzacE;
    public final Session zzacG;
    public final int zzadB;
    public final List<RawDataSet> zzacQ;
    public final int zzacR;
    public final boolean zzacS;
    public static final Parcelable.Creator<RawBucket> CREATOR = new zzm();

    public RawBucket(int versionCode, long startTimeMillis, long endTimeMillis, Session session, int activity, List<RawDataSet> dataSets, int bucketType, boolean serverHasMoreData) {
        this.zzzH = versionCode;
        this.zzGX = startTimeMillis;
        this.zzacE = endTimeMillis;
        this.zzacG = session;
        this.zzadB = activity;
        this.zzacQ = dataSets;
        this.zzacR = bucketType;
        this.zzacS = serverHasMoreData;
    }

    public RawBucket(Bucket bucket, List<DataSource> uniqueDataSources, List<DataType> uniqueDataTypes) {
        this.zzzH = 2;
        this.zzGX = bucket.getStartTime(TimeUnit.MILLISECONDS);
        this.zzacE = bucket.getEndTime(TimeUnit.MILLISECONDS);
        this.zzacG = bucket.getSession();
        this.zzadB = bucket.zzoB();
        this.zzacR = bucket.getBucketType();
        this.zzacS = bucket.zzoC();
        List<DataSet> list = bucket.getDataSets();
        this.zzacQ = new ArrayList<RawDataSet>(list.size());
        for (DataSet dataSet : list) {
            this.zzacQ.add(new RawDataSet(dataSet, uniqueDataSources, uniqueDataTypes));
        }
    }

    public boolean equals(Object o) {
        return this == o || o instanceof RawBucket && this.zza((RawBucket)o);
    }

    private boolean zza(RawBucket rawBucket) {
        return this.zzGX == rawBucket.zzGX && this.zzacE == rawBucket.zzacE && this.zzadB == rawBucket.zzadB && zzu.equal(this.zzacQ, rawBucket.zzacQ) && this.zzacR == rawBucket.zzacR && this.zzacS == rawBucket.zzacS;
    }

    public int hashCode() {
        return zzu.hashCode((Object[])new Object[]{this.zzGX, this.zzacE, this.zzacR});
    }

    public String toString() {
        return zzu.zzq((Object)this).zzg("startTime", (Object)this.zzGX).zzg("endTime", (Object)this.zzacE).zzg("activity", (Object)this.zzadB).zzg("dataSets", this.zzacQ).zzg("bucketType", (Object)this.zzacR).zzg("serverHasMoreData", (Object)this.zzacS).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zzm.zza(this, parcel, flags);
    }
}

