/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.zzc;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.common.internal.zzv;
import com.google.android.gms.fitness.FitnessActivities;
import com.google.android.gms.fitness.data.Application;
import com.google.android.gms.fitness.data.zzp;
import java.util.concurrent.TimeUnit;

public class Session
implements SafeParcelable {
    public static final String EXTRA_SESSION = "vnd.google.fitness.session";
    public static final String MIME_TYPE_PREFIX = "vnd.google.fitness.session/";
    private final int zzzH;
    private final long zzGX;
    private final long zzacE;
    private final String mName;
    private final String zzadG;
    private final String zzadH;
    private final int zzacP;
    private final Application zzadc;
    private final Long zzadI;
    public static final Parcelable.Creator<Session> CREATOR = new zzp();

    Session(int versionCode, long startTimeMillis, long endTimeMillis, String name, String identifier, String description, int activityType, Application application, Long activeTimeMillis) {
        this.zzzH = versionCode;
        this.zzGX = startTimeMillis;
        this.zzacE = endTimeMillis;
        this.mName = name;
        this.zzadG = identifier;
        this.zzadH = description;
        this.zzacP = activityType;
        this.zzadc = application;
        this.zzadI = activeTimeMillis;
    }

    public Session(long startTimeMillis, long endTimeMillis, String name, String identifier, String description, int activityType, Application application, Long activeTimeMillis) {
        this(3, startTimeMillis, endTimeMillis, name, identifier, description, activityType, application, activeTimeMillis);
    }

    private Session(Builder builder) {
        this(builder.zzGX, builder.zzacE, builder.mName, builder.zzadG, builder.zzadH, builder.zzacP, builder.zzadc, builder.zzadI);
    }

    public static Session extract(Intent intent) {
        if (intent == null) {
            return null;
        }
        return (Session)zzc.zza((Intent)intent, (String)EXTRA_SESSION, CREATOR);
    }

    public static String getMimeType(String activity) {
        return MIME_TYPE_PREFIX + activity;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzGX, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzacE, TimeUnit.MILLISECONDS);
    }

    public long getActiveTime(TimeUnit timeUnit) {
        zzv.zza((this.zzadI != null ? 1 : 0) != 0, (Object)"Active time is not set");
        return timeUnit.convert(this.zzadI, TimeUnit.MILLISECONDS);
    }

    public boolean hasActiveTime() {
        return this.zzadI != null;
    }

    public boolean isOngoing() {
        return this.zzacE == 0L;
    }

    public String getName() {
        return this.mName;
    }

    public String getIdentifier() {
        return this.zzadG;
    }

    public String getDescription() {
        return this.zzadH;
    }

    public String getActivity() {
        return FitnessActivities.getName(this.zzacP);
    }

    public int zzoB() {
        return this.zzacP;
    }

    public Application zzoM() {
        return this.zzadc;
    }

    public String getAppPackageName() {
        return this.zzadc == null ? null : this.zzadc.getPackageName();
    }

    public boolean equals(Object o) {
        return o == this || o instanceof Session && this.zza((Session)o);
    }

    private boolean zza(Session session) {
        return this.zzGX == session.zzGX && this.zzacE == session.zzacE && zzu.equal((Object)this.mName, (Object)session.mName) && zzu.equal((Object)this.zzadG, (Object)session.zzadG) && zzu.equal((Object)this.zzadH, (Object)session.zzadH) && zzu.equal((Object)this.zzadc, (Object)session.zzadc) && this.zzacP == session.zzacP;
    }

    public int hashCode() {
        return zzu.hashCode((Object[])new Object[]{this.zzGX, this.zzacE, this.zzadG});
    }

    public String toString() {
        return zzu.zzq((Object)this).zzg("startTime", (Object)this.zzGX).zzg("endTime", (Object)this.zzacE).zzg("name", (Object)this.mName).zzg("identifier", (Object)this.zzadG).zzg("description", (Object)this.zzadH).zzg("activity", (Object)this.zzacP).zzg("application", (Object)this.zzadc).toString();
    }

    int getVersionCode() {
        return this.zzzH;
    }

    public long zzjm() {
        return this.zzGX;
    }

    public long zzoD() {
        return this.zzacE;
    }

    public Long zzoU() {
        return this.zzadI;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzp.zza(this, dest, flags);
    }

    public static class Builder {
        private long zzGX = 0L;
        private long zzacE = 0L;
        private String mName = null;
        private String zzadG;
        private String zzadH;
        private int zzacP = 4;
        private Application zzadc;
        private Long zzadI;

        public Builder setStartTime(long time, TimeUnit timeUnit) {
            zzv.zza((time > 0L ? 1 : 0) != 0, (Object)"Start time should be positive.");
            this.zzGX = timeUnit.toMillis(time);
            return this;
        }

        public Builder setEndTime(long time, TimeUnit timeUnit) {
            zzv.zza((time >= 0L ? 1 : 0) != 0, (Object)"End time should be positive.");
            this.zzacE = timeUnit.toMillis(time);
            return this;
        }

        public Builder setName(String name) {
            zzv.zzb((name.length() <= 100 ? 1 : 0) != 0, (String)"Session name cannot exceed %d characters", (Object[])new Object[]{100});
            this.mName = name;
            return this;
        }

        public Builder setIdentifier(String identifier) {
            zzv.zzQ((identifier != null && TextUtils.getTrimmedLength((CharSequence)identifier) > 0 ? 1 : 0) != 0);
            this.zzadG = identifier;
            return this;
        }

        public Builder setDescription(String description) {
            zzv.zzb((description.length() <= 1000 ? 1 : 0) != 0, (String)"Session description cannot exceed %d characters", (Object[])new Object[]{1000});
            this.zzadH = description;
            return this;
        }

        public Builder setActivity(String activity) {
            return this.zzdK(FitnessActivities.zzcl(activity));
        }

        public Builder zzdK(int n) {
            this.zzacP = n;
            return this;
        }

        public Builder setActiveTime(long time, TimeUnit timeUnit) {
            this.zzadI = timeUnit.toMillis(time);
            return this;
        }

        public Session build() {
            zzv.zza((this.zzGX > 0L ? 1 : 0) != 0, (Object)"Start time should be specified.");
            zzv.zza((this.zzacE == 0L || this.zzacE > this.zzGX ? 1 : 0) != 0, (Object)"End time should be later than start time.");
            if (this.zzadG == null) {
                this.zzadG = (this.mName == null ? "" : this.mName) + this.zzGX;
            }
            return new Session(this);
        }
    }
}

