/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.common.internal.zzv;
import com.google.android.gms.fitness.FitnessActivities;
import com.google.android.gms.fitness.data.MapValue;
import com.google.android.gms.fitness.data.zzt;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public final class Value
implements SafeParcelable {
    private final int zzzH;
    private final int zzadw;
    private boolean zzadM;
    private float zzadA;
    private String zzadN;
    private Map<String, MapValue> zzadO;
    public static final Parcelable.Creator<Value> CREATOR = new zzt();

    public Value(int format) {
        this(2, format, false, 0.0f, null, null);
    }

    Value(int versionCode, int format, boolean isSet, float value, String stringValue, Bundle mapValue) {
        this.zzzH = versionCode;
        this.zzadw = format;
        this.zzadM = isSet;
        this.zzadA = value;
        this.zzadN = stringValue;
        this.zzadO = Value.zzr(mapValue);
    }

    public void setInt(int value) {
        zzv.zza((this.zzadw == 1 ? 1 : 0) != 0, (Object)"Attempting to set an int value to a field that is not in INT32 format.  Please check the data type definition and use the right format.");
        this.zzadM = true;
        this.zzadA = Float.intBitsToFloat(value);
    }

    public void setFloat(float value) {
        zzv.zza((this.zzadw == 2 ? 1 : 0) != 0, (Object)"Attempting to set an float value to a field that is not in FLOAT format.  Please check the data type definition and use the right format.");
        this.zzadM = true;
        this.zzadA = value;
    }

    public void setString(String value) {
        zzv.zza((this.zzadw == 3 ? 1 : 0) != 0, (Object)"Attempting to set a string value to a field that is not in STRING format.  Please check the data type definition and use the right format.");
        this.zzadM = true;
        this.zzadN = value;
    }

    public void setKeyValue(String key, float value) {
        zzv.zza((this.zzadw == 4 ? 1 : 0) != 0, (Object)"Attempting to set a key's value to a field that is not in FLOAT_MAP format.  Please check the data type definition and use the right format.");
        this.zzadM = true;
        if (this.zzadO == null) {
            this.zzadO = new HashMap<String, MapValue>();
        }
        this.zzadO.put(key, MapValue.zzc(value));
    }

    public void clearKey(String key) {
        zzv.zza((this.zzadw == 4 ? 1 : 0) != 0, (Object)"Attempting to set a key's value to a field that is not in FLOAT_MAP format.  Please check the data type definition and use the right format.");
        if (this.zzadO != null) {
            this.zzadO.remove(key);
        }
    }

    public void setActivity(String activity) {
        this.setInt(FitnessActivities.zzcl(activity));
    }

    public boolean isSet() {
        return this.zzadM;
    }

    public int getFormat() {
        return this.zzadw;
    }

    public int asInt() {
        zzv.zza((this.zzadw == 1 ? 1 : 0) != 0, (Object)"Value is not in int format");
        return Float.floatToRawIntBits(this.zzadA);
    }

    public float asFloat() {
        zzv.zza((this.zzadw == 2 ? 1 : 0) != 0, (Object)"Value is not in float format");
        return this.zzadA;
    }

    public String asString() {
        zzv.zza((this.zzadw == 3 ? 1 : 0) != 0, (Object)"Value is not in string format");
        return this.zzadN;
    }

    public Float getKeyValue(String key) {
        zzv.zza((this.zzadw == 4 ? 1 : 0) != 0, (Object)"Value is not in float map format");
        if (this.zzadO != null && this.zzadO.containsKey(key)) {
            return Float.valueOf(this.zzadO.get(key).asFloat());
        }
        return null;
    }

    public Map<String, MapValue> zzog() {
        zzv.zza((this.zzadw == 4 ? 1 : 0) != 0, (Object)"Value is not in float map format");
        return this.zzadO == null ? Collections.emptyMap() : this.zzadO;
    }

    public String asActivity() {
        return FitnessActivities.getName(this.asInt());
    }

    public boolean equals(Object o) {
        return this == o || o instanceof Value && this.zza((Value)o);
    }

    private boolean zza(Value value) {
        if (this.zzadw == value.zzadw && this.zzadM == value.zzadM) {
            switch (this.zzadw) {
                case 1: {
                    return this.asInt() == value.asInt();
                }
                case 2: {
                    return this.asFloat() == value.asFloat();
                }
                case 3: {
                    return this.asString().equals(value.asString());
                }
                case 4: {
                    return this.zzog().equals(value.zzog());
                }
            }
            return this.zzadA == value.zzadA;
        }
        return false;
    }

    public int hashCode() {
        return zzu.hashCode((Object[])new Object[]{Float.valueOf(this.zzadA), this.zzadN, this.zzadO});
    }

    public String toString() {
        if (!this.zzadM) {
            return "unset";
        }
        switch (this.zzadw) {
            case 1: {
                return Integer.toString(this.asInt());
            }
            case 2: {
                return Float.toString(this.asFloat());
            }
            case 3: {
                return this.zzadN;
            }
            case 4: {
                return new TreeMap<String, MapValue>(this.zzadO).toString();
            }
        }
        return "unknown";
    }

    int getVersionCode() {
        return this.zzzH;
    }

    float zzoT() {
        return this.zzadA;
    }

    String zzoZ() {
        return this.zzadN;
    }

    Bundle zzpa() {
        if (this.zzadO == null) {
            return null;
        }
        Bundle bundle = new Bundle(this.zzadO.size());
        for (Map.Entry<String, MapValue> entry : this.zzadO.entrySet()) {
            bundle.putParcelable(entry.getKey(), (Parcelable)entry.getValue());
        }
        return bundle;
    }

    private static Map<String, MapValue> zzr(Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        bundle.setClassLoader(MapValue.class.getClassLoader());
        ArrayMap arrayMap = new ArrayMap(bundle.size());
        for (String string : bundle.keySet()) {
            arrayMap.put(string, bundle.getParcelable(string));
        }
        return arrayMap;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzt.zza(this, dest, flags);
    }
}

