/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.common.internal.zzv;
import com.google.android.gms.fitness.data.Field;
import com.google.android.gms.fitness.request.zzi;
import com.google.android.gms.internal.zziz;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DataTypeCreateRequest
implements SafeParcelable {
    private final int zzzH;
    private final String mName;
    private final List<Field> zzadn;
    private final zziz zzafe;
    private final String zzJd;
    public static final Parcelable.Creator<DataTypeCreateRequest> CREATOR = new zzi();

    DataTypeCreateRequest(int versionCode, String name, List<Field> fields, IBinder callback, String packageName) {
        this.zzzH = versionCode;
        this.mName = name;
        this.zzadn = Collections.unmodifiableList(fields);
        this.zzafe = callback == null ? null : zziz.zza.zzaF(callback);
        this.zzJd = packageName;
    }

    private DataTypeCreateRequest(Builder builder) {
        this(builder.mName, builder.zzadn, null, null);
    }

    public DataTypeCreateRequest(DataTypeCreateRequest request, zziz callback, String packageName) {
        this(request.mName, request.zzadn, callback, packageName);
    }

    public DataTypeCreateRequest(String name, List<Field> fields, zziz callback, String packageName) {
        this.zzzH = 2;
        this.mName = name;
        this.zzadn = Collections.unmodifiableList(fields);
        this.zzafe = callback;
        this.zzJd = packageName;
    }

    public String getName() {
        return this.mName;
    }

    public List<Field> getFields() {
        return this.zzadn;
    }

    public IBinder zzpf() {
        return this.zzafe == null ? null : this.zzafe.asBinder();
    }

    public String getPackageName() {
        return this.zzJd;
    }

    public boolean equals(Object o) {
        return o == this || o instanceof DataTypeCreateRequest && this.zzb((DataTypeCreateRequest)o);
    }

    private boolean zzb(DataTypeCreateRequest dataTypeCreateRequest) {
        return zzu.equal((Object)this.mName, (Object)dataTypeCreateRequest.mName) && zzu.equal(this.zzadn, dataTypeCreateRequest.zzadn);
    }

    public int hashCode() {
        return zzu.hashCode((Object[])new Object[]{this.mName, this.zzadn});
    }

    public String toString() {
        return zzu.zzq((Object)this).zzg("name", (Object)this.mName).zzg("fields", this.zzadn).toString();
    }

    int getVersionCode() {
        return this.zzzH;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzi.zza(this, dest, flags);
    }

    public static class Builder {
        private String mName;
        private List<Field> zzadn = new ArrayList<Field>();

        public Builder setName(String name) {
            this.mName = name;
            return this;
        }

        public Builder addField(Field field) {
            if (!this.zzadn.contains(field)) {
                this.zzadn.add(field);
            }
            return this;
        }

        public Builder addField(String name, int format) {
            zzv.zzb((name != null && !name.isEmpty() ? 1 : 0) != 0, (Object)"Invalid name specified");
            Field field = Field.zzm(name, format);
            return this.addField(field);
        }

        public DataTypeCreateRequest build() {
            zzv.zza((this.mName != null ? 1 : 0) != 0, (Object)"Must set the name");
            zzv.zza((!this.zzadn.isEmpty() ? 1 : 0) != 0, (Object)"Must specify the data fields");
            return new DataTypeCreateRequest(this);
        }
    }
}

