/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.zzv;
import com.google.android.gms.internal.zzjk;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SessionReadRequest
implements SafeParcelable {
    private final int zzzH;
    private final String zzafy;
    private final String zzBL;
    private final long zzGX;
    private final long zzacE;
    private final List<DataType> zzacO;
    private final List<DataSource> zzaeJ;
    private boolean zzafz;
    private final boolean zzaeU;
    private final List<String> zzafA;
    private final zzjk zzafB;
    private final String zzJd;
    public static final Parcelable.Creator<SessionReadRequest> CREATOR = new zzv();

    SessionReadRequest(int versionCode, String sessionName, String sessionId, long startTimeMillis, long endTimeMillis, List<DataType> dataTypes, List<DataSource> dataSources, boolean getSessionsFromAllApps, boolean serverQueriesEnabled, List<String> excludedPackages, IBinder callback, String packageName) {
        this.zzzH = versionCode;
        this.zzafy = sessionName;
        this.zzBL = sessionId;
        this.zzGX = startTimeMillis;
        this.zzacE = endTimeMillis;
        this.zzacO = Collections.unmodifiableList(dataTypes);
        this.zzaeJ = Collections.unmodifiableList(dataSources);
        this.zzafz = getSessionsFromAllApps;
        this.zzaeU = serverQueriesEnabled;
        this.zzafA = excludedPackages;
        this.zzafB = callback == null ? null : zzjk.zza.zzaQ(callback);
        this.zzJd = packageName;
    }

    private SessionReadRequest(Builder builder) {
        this(builder.zzafy, builder.zzBL, builder.zzGX, builder.zzacE, builder.zzacO, builder.zzaeJ, builder.zzafz, builder.zzaeU, builder.zzafA, null, null);
    }

    public SessionReadRequest(SessionReadRequest request, zzjk callback, String packageName) {
        this(request.zzafy, request.zzBL, request.zzGX, request.zzacE, request.zzacO, request.zzaeJ, request.zzafz, request.zzaeU, request.zzafA, callback, packageName);
    }

    public SessionReadRequest(String sessionName, String sessionId, long startTimeMillis, long endTimeMillis, List<DataType> dataTypes, List<DataSource> dataSources, boolean getSessionsFromAllApps, boolean serverQueriesEnabled, List<String> excludedPackages, zzjk callback, String packageName) {
        this.zzzH = 4;
        this.zzafy = sessionName;
        this.zzBL = sessionId;
        this.zzGX = startTimeMillis;
        this.zzacE = endTimeMillis;
        this.zzacO = Collections.unmodifiableList(dataTypes);
        this.zzaeJ = Collections.unmodifiableList(dataSources);
        this.zzafz = getSessionsFromAllApps;
        this.zzaeU = serverQueriesEnabled;
        this.zzafA = excludedPackages;
        this.zzafB = callback;
        this.zzJd = packageName;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzGX, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzacE, TimeUnit.MILLISECONDS);
    }

    public String getSessionName() {
        return this.zzafy;
    }

    public String getSessionId() {
        return this.zzBL;
    }

    public List<DataType> getDataTypes() {
        return this.zzacO;
    }

    public List<DataSource> getDataSources() {
        return this.zzaeJ;
    }

    public boolean includeSessionsFromAllApps() {
        return this.zzafz;
    }

    public List<String> getExcludedPackages() {
        return this.zzafA;
    }

    public boolean zzpk() {
        return this.zzaeU;
    }

    public long zzoD() {
        return this.zzacE;
    }

    public long zzjm() {
        return this.zzGX;
    }

    public boolean zzpz() {
        return this.zzafz;
    }

    public IBinder zzpf() {
        return this.zzafB == null ? null : this.zzafB.asBinder();
    }

    public String getPackageName() {
        return this.zzJd;
    }

    public boolean equals(Object o) {
        return this == o || o instanceof SessionReadRequest && this.zzb((SessionReadRequest)o);
    }

    private boolean zzb(SessionReadRequest sessionReadRequest) {
        return zzu.equal((Object)this.zzafy, (Object)sessionReadRequest.zzafy) && this.zzBL.equals(sessionReadRequest.zzBL) && this.zzGX == sessionReadRequest.zzGX && this.zzacE == sessionReadRequest.zzacE && zzu.equal(this.zzacO, sessionReadRequest.zzacO) && zzu.equal(this.zzaeJ, sessionReadRequest.zzaeJ) && this.zzafz == sessionReadRequest.zzafz && this.zzafA.equals(sessionReadRequest.zzafA) && this.zzaeU == sessionReadRequest.zzaeU;
    }

    public int hashCode() {
        return zzu.hashCode((Object[])new Object[]{this.zzafy, this.zzBL, this.zzGX, this.zzacE});
    }

    public String toString() {
        return zzu.zzq((Object)this).zzg("sessionName", (Object)this.zzafy).zzg("sessionId", (Object)this.zzBL).zzg("startTimeMillis", (Object)this.zzGX).zzg("endTimeMillis", (Object)this.zzacE).zzg("dataTypes", this.zzacO).zzg("dataSources", this.zzaeJ).zzg("sessionsFromAllApps", (Object)this.zzafz).zzg("excludedPackages", this.zzafA).zzg("useServer", (Object)this.zzaeU).toString();
    }

    int getVersionCode() {
        return this.zzzH;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzv.zza(this, dest, flags);
    }

    public static class Builder {
        private String zzafy;
        private String zzBL;
        private long zzGX = 0L;
        private long zzacE = 0L;
        private List<DataType> zzacO = new ArrayList<DataType>();
        private List<DataSource> zzaeJ = new ArrayList<DataSource>();
        private boolean zzafz = false;
        private boolean zzaeU = false;
        private List<String> zzafA = new ArrayList<String>();

        public Builder setTimeInterval(long startTime, long endTime, TimeUnit timeUnit) {
            this.zzGX = timeUnit.toMillis(startTime);
            this.zzacE = timeUnit.toMillis(endTime);
            return this;
        }

        public Builder setSessionName(String sessionName) {
            this.zzafy = sessionName;
            return this;
        }

        public Builder setSessionId(String sessionId) {
            this.zzBL = sessionId;
            return this;
        }

        public Builder read(DataSource dataSource) {
            com.google.android.gms.common.internal.zzv.zzb((Object)dataSource, (Object)"Attempting to add a null data source");
            if (!this.zzaeJ.contains(dataSource)) {
                this.zzaeJ.add(dataSource);
            }
            return this;
        }

        public Builder read(DataType dataType) {
            com.google.android.gms.common.internal.zzv.zzb((Object)dataType, (Object)"Attempting to use a null data type");
            if (!this.zzacO.contains(dataType)) {
                this.zzacO.add(dataType);
            }
            return this;
        }

        public Builder readSessionsFromAllApps() {
            this.zzafz = true;
            return this;
        }

        public Builder excludePackage(String appPackageName) {
            com.google.android.gms.common.internal.zzv.zzb((Object)appPackageName, (Object)"Attempting to use a null package name");
            if (!this.zzafA.contains(appPackageName)) {
                this.zzafA.add(appPackageName);
            }
            return this;
        }

        public Builder enableServerQueries() {
            this.zzaeU = true;
            return this;
        }

        public SessionReadRequest build() {
            com.google.android.gms.common.internal.zzv.zzb((this.zzGX > 0L ? 1 : 0) != 0, (String)"Invalid start time: %s", (Object[])new Object[]{this.zzGX});
            com.google.android.gms.common.internal.zzv.zzb((this.zzacE > 0L && this.zzacE > this.zzGX ? 1 : 0) != 0, (String)"Invalid end time: %s", (Object[])new Object[]{this.zzacE});
            return new SessionReadRequest(this);
        }
    }
}

