/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.result;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.common.internal.zzv;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Subscription;
import com.google.android.gms.fitness.result.zzh;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ListSubscriptionsResult
implements Result,
SafeParcelable {
    private final int zzzH;
    private final List<Subscription> zzafP;
    private final Status zzKr;
    public static final Parcelable.Creator<ListSubscriptionsResult> CREATOR = new zzh();

    ListSubscriptionsResult(int versionCode, List<Subscription> subscriptions, Status status) {
        this.zzzH = versionCode;
        this.zzafP = subscriptions;
        this.zzKr = status;
    }

    public ListSubscriptionsResult(List<Subscription> subscriptions, Status status) {
        this.zzzH = 3;
        this.zzafP = Collections.unmodifiableList(subscriptions);
        this.zzKr = (Status)zzv.zzb((Object)status, (Object)"status");
    }

    public static ListSubscriptionsResult zzG(Status status) {
        return new ListSubscriptionsResult(Collections.emptyList(), status);
    }

    public List<Subscription> getSubscriptions() {
        return this.zzafP;
    }

    public List<Subscription> getSubscriptions(DataType dataType) {
        ArrayList<Subscription> arrayList = new ArrayList<Subscription>();
        for (Subscription subscription : this.zzafP) {
            if (!dataType.equals(subscription.zzoX())) continue;
            arrayList.add(subscription);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public Status getStatus() {
        return this.zzKr;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof ListSubscriptionsResult && this.zzb((ListSubscriptionsResult)that);
    }

    private boolean zzb(ListSubscriptionsResult listSubscriptionsResult) {
        return this.zzKr.equals((Object)listSubscriptionsResult.zzKr) && zzu.equal(this.zzafP, listSubscriptionsResult.zzafP);
    }

    public int hashCode() {
        return zzu.hashCode((Object[])new Object[]{this.zzKr, this.zzafP});
    }

    public String toString() {
        return zzu.zzq((Object)this).zzg("status", (Object)this.zzKr).zzg("subscriptions", this.zzafP).toString();
    }

    int getVersionCode() {
        return this.zzzH;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzh.zza(this, dest, flags);
    }
}

