/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.service;

import android.app.AppOpsManager;
import android.app.Service;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.internal.service.FitnessDataSourcesRequest;
import com.google.android.gms.fitness.internal.service.FitnessUnregistrationRequest;
import com.google.android.gms.fitness.internal.service.zzc;
import com.google.android.gms.fitness.result.DataSourcesResult;
import com.google.android.gms.fitness.service.FitnessSensorServiceRequest;
import com.google.android.gms.internal.zzic;
import com.google.android.gms.internal.zziy;
import com.google.android.gms.internal.zzjm;
import java.util.List;

public abstract class FitnessSensorService
extends Service {
    public static final String SERVICE_INTERFACE = "com.google.android.gms.fitness.service.FitnessSensorService";
    private zza zzafR;

    public void onCreate() {
        super.onCreate();
        this.zzafR = new zza(this);
    }

    public final IBinder onBind(Intent intent) {
        if (SERVICE_INTERFACE.equals(intent.getAction())) {
            if (Log.isLoggable((String)"FitnessSensorService", (int)3)) {
                Log.d((String)"FitnessSensorService", (String)("Intent " + intent + " received by " + ((Object)((Object)this)).getClass().getName()));
            }
            return this.zzafR.asBinder();
        }
        return null;
    }

    public abstract List<DataSource> onFindDataSources(List<DataType> var1);

    public abstract boolean onRegister(FitnessSensorServiceRequest var1);

    public abstract boolean onUnregister(DataSource var1);

    protected void zzpK() throws SecurityException {
        int n = Binder.getCallingUid();
        String string = "com.google.android.gms";
        if (zzic.zznk()) {
            AppOpsManager appOpsManager = (AppOpsManager)this.getSystemService("appops");
            appOpsManager.checkPackage(n, "com.google.android.gms");
            return;
        }
        PackageManager packageManager = this.getPackageManager();
        String[] stringArray = packageManager.getPackagesForUid(n);
        if (stringArray != null) {
            for (String string2 : stringArray) {
                if (!string2.equals("com.google.android.gms")) continue;
                return;
            }
        }
        throw new SecurityException("Unauthorized caller");
    }

    private static class zza
    extends zzc.zza {
        private final FitnessSensorService zzafS;

        private zza(FitnessSensorService fitnessSensorService) {
            this.zzafS = fitnessSensorService;
        }

        @Override
        public void zza(FitnessDataSourcesRequest fitnessDataSourcesRequest, zziy zziy2) throws RemoteException {
            this.zzafS.zzpK();
            List<DataSource> list = this.zzafS.onFindDataSources(fitnessDataSourcesRequest.getDataTypes());
            zziy2.zza(new DataSourcesResult(list, Status.zzQU));
        }

        @Override
        public void zza(FitnessSensorServiceRequest fitnessSensorServiceRequest, zzjm zzjm2) throws RemoteException {
            this.zzafS.zzpK();
            if (this.zzafS.onRegister(fitnessSensorServiceRequest)) {
                zzjm2.zzi(Status.zzQU);
            } else {
                zzjm2.zzi(new Status(13));
            }
        }

        @Override
        public void zza(FitnessUnregistrationRequest fitnessUnregistrationRequest, zzjm zzjm2) throws RemoteException {
            this.zzafS.zzpK();
            if (this.zzafS.onUnregister(fitnessUnregistrationRequest.getDataSource())) {
                zzjm2.zzi(Status.zzQU);
            } else {
                zzjm2.zzi(new Status(13));
            }
        }
    }
}

