/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.service;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.zzj;
import com.google.android.gms.fitness.service.SensorEventDispatcher;
import com.google.android.gms.fitness.service.zza;
import com.google.android.gms.fitness.service.zzb;
import java.util.concurrent.TimeUnit;

public class FitnessSensorServiceRequest
implements SafeParcelable {
    public static final int UNSPECIFIED = -1;
    private final int zzzH;
    private final DataSource zzacD;
    private final zzj zzafl;
    private final long zzafT;
    private final long zzafU;
    public static final Parcelable.Creator<FitnessSensorServiceRequest> CREATOR = new zza();

    FitnessSensorServiceRequest(int versionCode, DataSource dataSource, IBinder listenerBinder, long samplingRateMicros, long batchIntervalMicros) {
        this.zzzH = versionCode;
        this.zzacD = dataSource;
        this.zzafl = zzj.zza.zzau(listenerBinder);
        this.zzafT = samplingRateMicros;
        this.zzafU = batchIntervalMicros;
    }

    public DataSource getDataSource() {
        return this.zzacD;
    }

    public SensorEventDispatcher getDispatcher() {
        return new zzb(this.zzafl);
    }

    public long getSamplingRate(TimeUnit timeUnit) {
        return this.zzafT == -1L ? -1L : timeUnit.convert(this.zzafT, TimeUnit.MICROSECONDS);
    }

    public long getBatchInterval(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzafU, TimeUnit.MICROSECONDS);
    }

    public String toString() {
        return String.format("FitnessSensorServiceRequest{%s}", this.zzacD);
    }

    int getVersionCode() {
        return this.zzzH;
    }

    IBinder zzpw() {
        return this.zzafl.asBinder();
    }

    public long zzoW() {
        return this.zzafT;
    }

    public long zzpL() {
        return this.zzafU;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zza.zza(this, parcel, flags);
    }

    public boolean equals(Object that) {
        return this == that || that instanceof FitnessSensorServiceRequest && this.zza((FitnessSensorServiceRequest)that);
    }

    private boolean zza(FitnessSensorServiceRequest fitnessSensorServiceRequest) {
        return zzu.equal((Object)this.zzacD, (Object)fitnessSensorServiceRequest.zzacD) && this.zzafT == fitnessSensorServiceRequest.zzafT && this.zzafU == fitnessSensorServiceRequest.zzafU;
    }

    public int hashCode() {
        return zzu.hashCode((Object[])new Object[]{this.zzacD, this.zzafT, this.zzafU});
    }
}

