/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.result;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.data.SessionDataSet;
import com.google.android.gms.fitness.result.zzj;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SessionReadResult
implements Result,
SafeParcelable {
    private final int mVersionCode;
    private final List<Session> zzapH;
    private final List<SessionDataSet> zzaqO;
    private final Status zzQA;
    public static final Parcelable.Creator<SessionReadResult> CREATOR = new zzj();

    SessionReadResult(int versionCode, List<Session> sessions, List<SessionDataSet> sessionDataSets, Status status) {
        this.mVersionCode = versionCode;
        this.zzapH = sessions;
        this.zzaqO = Collections.unmodifiableList(sessionDataSets);
        this.zzQA = status;
    }

    public SessionReadResult(List<Session> sessions, List<SessionDataSet> sessionDataSets, Status status) {
        this.mVersionCode = 3;
        this.zzapH = sessions;
        this.zzaqO = Collections.unmodifiableList(sessionDataSets);
        this.zzQA = status;
    }

    public static SessionReadResult zzU(Status status) {
        ArrayList<Session> arrayList = new ArrayList<Session>();
        ArrayList<SessionDataSet> arrayList2 = new ArrayList<SessionDataSet>();
        return new SessionReadResult(arrayList, arrayList2, status);
    }

    public List<Session> getSessions() {
        return this.zzapH;
    }

    public List<DataSet> getDataSet(Session session, DataType dataType) {
        zzx.zzb((boolean)this.zzapH.contains(session), (String)"Attempting to read data for session %s which was not returned", (Object[])new Object[]{session});
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>();
        for (SessionDataSet sessionDataSet : this.zzaqO) {
            if (!zzw.equal((Object)session, (Object)sessionDataSet.getSession()) || !dataType.equals(sessionDataSet.zzrO().getDataType())) continue;
            arrayList.add(sessionDataSet.zzrO());
        }
        return arrayList;
    }

    public List<DataSet> getDataSet(Session session) {
        zzx.zzb((boolean)this.zzapH.contains(session), (String)"Attempting to read data for session %s which was not returned", (Object[])new Object[]{session});
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>();
        for (SessionDataSet sessionDataSet : this.zzaqO) {
            if (!zzw.equal((Object)session, (Object)sessionDataSet.getSession())) continue;
            arrayList.add(sessionDataSet.zzrO());
        }
        return arrayList;
    }

    public List<SessionDataSet> zzsG() {
        return this.zzaqO;
    }

    public Status getStatus() {
        return this.zzQA;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof SessionReadResult && this.zzb((SessionReadResult)that);
    }

    private boolean zzb(SessionReadResult sessionReadResult) {
        return this.zzQA.equals((Object)sessionReadResult.zzQA) && zzw.equal(this.zzapH, sessionReadResult.zzapH) && zzw.equal(this.zzaqO, sessionReadResult.zzaqO);
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzQA, this.zzapH, this.zzaqO});
    }

    public String toString() {
        return zzw.zzu((Object)this).zzg("status", (Object)this.zzQA).zzg("sessions", this.zzapH).zzg("sessionDataSets", this.zzaqO).toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzj.zza(this, dest, flags);
    }
}

