/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.zzc;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.DataDeleteRequest;
import com.google.android.gms.fitness.request.DataReadRequest;
import com.google.android.gms.fitness.result.DailyTotalResult;
import com.google.android.gms.fitness.result.DataReadResult;
import java.util.concurrent.TimeUnit;

public interface HistoryApi {
    public PendingResult<DataReadResult> readData(GoogleApiClient var1, DataReadRequest var2);

    public PendingResult<DailyTotalResult> readDailyTotal(GoogleApiClient var1, DataType var2);

    public PendingResult<Status> insertData(GoogleApiClient var1, DataSet var2);

    public PendingResult<Status> deleteData(GoogleApiClient var1, DataDeleteRequest var2);

    public static class ViewIntentBuilder {
        private final Context mContext;
        private final DataType zzapL;
        private DataSource zzapM;
        private long zzNY;
        private long zzapN;
        private String zzapO;

        public ViewIntentBuilder(Context context, DataType dataType) {
            this.mContext = context;
            this.zzapL = dataType;
        }

        public ViewIntentBuilder setTimeInterval(long start, long end, TimeUnit timeUnit) {
            this.zzNY = timeUnit.toMillis(start);
            this.zzapN = timeUnit.toMillis(end);
            return this;
        }

        public ViewIntentBuilder setDataSource(DataSource dataSource) {
            zzx.zzb((boolean)dataSource.getDataType().equals(this.zzapL), (String)"Data source %s is not for the data type %s", (Object[])new Object[]{dataSource, this.zzapL});
            this.zzapM = dataSource;
            return this;
        }

        public ViewIntentBuilder setPreferredApplication(String packageName) {
            this.zzapO = packageName;
            return this;
        }

        public Intent build() {
            zzx.zza((this.zzNY > 0L ? 1 : 0) != 0, (Object)"Start time must be set");
            zzx.zza((this.zzapN > this.zzNY ? 1 : 0) != 0, (Object)"End time must be set and after start time");
            Intent intent = new Intent("vnd.google.fitness.VIEW");
            intent.setType(DataType.getMimeType(this.zzapM.getDataType()));
            intent.putExtra("vnd.google.fitness.start_time", this.zzNY);
            intent.putExtra("vnd.google.fitness.end_time", this.zzapN);
            zzc.zza((SafeParcelable)this.zzapM, (Intent)intent, (String)"vnd.google.fitness.data_source");
            return this.zzj(intent);
        }

        private Intent zzj(Intent intent) {
            if (this.zzapO == null) {
                return intent;
            }
            Intent intent2 = new Intent(intent).setPackage(this.zzapO);
            ResolveInfo resolveInfo = this.mContext.getPackageManager().resolveActivity(intent2, 0);
            if (resolveInfo != null) {
                String string = resolveInfo.activityInfo.name;
                intent2.setComponent(new ComponentName(this.zzapO, string));
                return intent2;
            }
            return intent;
        }
    }
}

