/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.Context;
import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.zzc;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.Application;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Device;
import com.google.android.gms.fitness.data.zzf;

public class DataSource
implements SafeParcelable {
    public static final String EXTRA_DATA_SOURCE = "vnd.google.fitness.data_source";
    public static final int TYPE_RAW = 0;
    public static final int TYPE_DERIVED = 1;
    private final int mVersionCode;
    private final DataType zzapL;
    private final String mName;
    private final int zzWJ;
    private final Device zzaqj;
    private final Application zzaqk;
    private final String zzaql;
    private final String zzaqm;
    public static final Parcelable.Creator<DataSource> CREATOR = new zzf();

    DataSource(int versionCode, DataType dataType, String name, int type, Device device, Application application, String streamName) {
        this.mVersionCode = versionCode;
        this.zzapL = dataType;
        this.zzWJ = type;
        this.mName = name;
        this.zzaqj = device;
        this.zzaqk = application;
        this.zzaql = streamName;
        this.zzaqm = this.zzss();
    }

    private DataSource(Builder builder) {
        this.mVersionCode = 3;
        this.zzapL = builder.zzapL;
        this.zzWJ = builder.zzWJ;
        this.mName = builder.mName;
        this.zzaqj = builder.zzaqj;
        this.zzaqk = builder.zzaqk;
        this.zzaql = builder.zzaql;
        this.zzaqm = this.zzss();
    }

    public static DataSource extract(Intent intent) {
        if (intent == null) {
            return null;
        }
        return (DataSource)zzc.zza((Intent)intent, (String)EXTRA_DATA_SOURCE, CREATOR);
    }

    public DataType getDataType() {
        return this.zzapL;
    }

    public int getType() {
        return this.zzWJ;
    }

    public String getName() {
        return this.mName;
    }

    public String getAppPackageName() {
        return this.zzaqk == null ? null : this.zzaqk.getPackageName();
    }

    public Application zzsr() {
        return this.zzaqk;
    }

    public Device getDevice() {
        return this.zzaqj;
    }

    public String getStreamName() {
        return this.zzaql;
    }

    public String getStreamIdentifier() {
        return this.zzaqm;
    }

    private String zzss() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getTypeString());
        stringBuilder.append(":").append(this.zzapL.getName());
        if (this.zzaqk != null) {
            stringBuilder.append(":").append(this.zzaqk.getPackageName());
        }
        if (this.zzaqj != null) {
            stringBuilder.append(":").append(this.zzaqj.getStreamIdentifier());
        }
        if (this.zzaql != null) {
            stringBuilder.append(":").append(this.zzaql);
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object that) {
        return this == that || that instanceof DataSource && this.zza((DataSource)that);
    }

    private boolean zza(DataSource dataSource) {
        return this.zzaqm.equals(dataSource.zzaqm);
    }

    public int hashCode() {
        return this.zzaqm.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("DataSource{");
        stringBuilder.append(this.getTypeString());
        if (this.mName != null) {
            stringBuilder.append(":").append(this.mName);
        }
        if (this.zzaqk != null) {
            stringBuilder.append(":").append(this.zzaqk);
        }
        if (this.zzaqj != null) {
            stringBuilder.append(":").append(this.zzaqj);
        }
        if (this.zzaql != null) {
            stringBuilder.append(":").append(this.zzaql);
        }
        stringBuilder.append(":").append(this.zzapL);
        return stringBuilder.append("}").toString();
    }

    public String toDebugString() {
        return (this.zzWJ == 0 ? "r" : "d") + ":" + this.zzapL.zzst() + (this.zzaqk == null ? "" : (this.zzaqk.equals(Application.zzapS) ? ":gms" : ":" + this.zzaqk.getPackageName())) + (this.zzaqj != null ? ":" + this.zzaqj.getModel() + ":" + this.zzaqj.getUid() : "") + (this.zzaql != null ? ":" + this.zzaql : "");
    }

    private String getTypeString() {
        switch (this.zzWJ) {
            case 0: {
                return "raw";
            }
            case 1: {
                return "derived";
            }
        }
        throw new IllegalArgumentException("invalid type value");
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zzf.zza(this, parcel, flags);
    }

    public static final class Builder {
        private DataType zzapL;
        private int zzWJ = -1;
        private String mName;
        private Device zzaqj;
        private Application zzaqk;
        private String zzaql = "";

        public Builder setDataType(DataType dataType) {
            this.zzapL = dataType;
            return this;
        }

        public Builder setType(int type) {
            this.zzWJ = type;
            return this;
        }

        public Builder setName(String name) {
            this.mName = name;
            return this;
        }

        public Builder setDevice(Device device) {
            this.zzaqj = device;
            return this;
        }

        public Builder setAppPackageName(String packageName) {
            this.zzaqk = Application.zzcP(packageName);
            return this;
        }

        public Builder setAppPackageName(Context appContext) {
            return this.setAppPackageName(appContext.getPackageName());
        }

        public Builder setStreamName(String streamName) {
            zzx.zzb((streamName != null ? 1 : 0) != 0, (Object)"Must specify a valid stream name");
            this.zzaql = streamName;
            return this;
        }

        public DataSource build() {
            zzx.zza((this.zzapL != null ? 1 : 0) != 0, (Object)"Must set data type");
            zzx.zza((this.zzWJ >= 0 ? 1 : 0) != 0, (Object)"Must set data source type");
            return new DataSource(this);
        }
    }
}

