/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.zzc;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.FitnessActivities;
import com.google.android.gms.fitness.data.Application;
import com.google.android.gms.fitness.data.zzp;
import java.util.concurrent.TimeUnit;

public class Session
implements SafeParcelable {
    public static final String EXTRA_SESSION = "vnd.google.fitness.session";
    public static final String MIME_TYPE_PREFIX = "vnd.google.fitness.session/";
    private final int mVersionCode;
    private final long zzNY;
    private final long zzapN;
    private final String mName;
    private final String zzaqY;
    private final String zzaqZ;
    private final int zzapX;
    private final Application zzaqk;
    private final Long zzara;
    public static final Parcelable.Creator<Session> CREATOR = new zzp();

    Session(int versionCode, long startTimeMillis, long endTimeMillis, String name, String identifier, String description, int activityType, Application application, Long activeTimeMillis) {
        this.mVersionCode = versionCode;
        this.zzNY = startTimeMillis;
        this.zzapN = endTimeMillis;
        this.mName = name;
        this.zzaqY = identifier;
        this.zzaqZ = description;
        this.zzapX = activityType;
        this.zzaqk = application;
        this.zzara = activeTimeMillis;
    }

    public Session(long startTimeMillis, long endTimeMillis, String name, String identifier, String description, int activityType, Application application, Long activeTimeMillis) {
        this(3, startTimeMillis, endTimeMillis, name, identifier, description, activityType, application, activeTimeMillis);
    }

    private Session(Builder builder) {
        this(builder.zzNY, builder.zzapN, builder.mName, builder.zzaqY, builder.zzaqZ, builder.zzapX, builder.zzaqk, builder.zzara);
    }

    public static Session extract(Intent intent) {
        if (intent == null) {
            return null;
        }
        return (Session)zzc.zza((Intent)intent, (String)EXTRA_SESSION, CREATOR);
    }

    public static String getMimeType(String activity) {
        return MIME_TYPE_PREFIX + activity;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzNY, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzapN, TimeUnit.MILLISECONDS);
    }

    public long getActiveTime(TimeUnit timeUnit) {
        zzx.zza((this.zzara != null ? 1 : 0) != 0, (Object)"Active time is not set");
        return timeUnit.convert(this.zzara, TimeUnit.MILLISECONDS);
    }

    public boolean hasActiveTime() {
        return this.zzara != null;
    }

    public boolean isOngoing() {
        return this.zzapN == 0L;
    }

    public String getName() {
        return this.mName;
    }

    public String getIdentifier() {
        return this.zzaqY;
    }

    public String getDescription() {
        return this.zzaqZ;
    }

    public String getActivity() {
        return FitnessActivities.getName(this.zzapX);
    }

    public int zzsg() {
        return this.zzapX;
    }

    public Application zzsr() {
        return this.zzaqk;
    }

    public String getAppPackageName() {
        return this.zzaqk == null ? null : this.zzaqk.getPackageName();
    }

    public boolean equals(Object o) {
        return o == this || o instanceof Session && this.zza((Session)o);
    }

    private boolean zza(Session session) {
        return this.zzNY == session.zzNY && this.zzapN == session.zzapN && zzw.equal((Object)this.mName, (Object)session.mName) && zzw.equal((Object)this.zzaqY, (Object)session.zzaqY) && zzw.equal((Object)this.zzaqZ, (Object)session.zzaqZ) && zzw.equal((Object)this.zzaqk, (Object)session.zzaqk) && this.zzapX == session.zzapX;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzNY, this.zzapN, this.zzaqY});
    }

    public String toString() {
        return zzw.zzv((Object)this).zzg("startTime", (Object)this.zzNY).zzg("endTime", (Object)this.zzapN).zzg("name", (Object)this.mName).zzg("identifier", (Object)this.zzaqY).zzg("description", (Object)this.zzaqZ).zzg("activity", (Object)this.zzapX).zzg("application", (Object)this.zzaqk).toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public long zzkX() {
        return this.zzNY;
    }

    public long zzsi() {
        return this.zzapN;
    }

    public Long zzsz() {
        return this.zzara;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzp.zza(this, dest, flags);
    }

    public static class Builder {
        private long zzNY = 0L;
        private long zzapN = 0L;
        private String mName = null;
        private String zzaqY;
        private String zzaqZ;
        private int zzapX = 4;
        private Application zzaqk;
        private Long zzara;

        public Builder setStartTime(long time, TimeUnit timeUnit) {
            zzx.zza((time > 0L ? 1 : 0) != 0, (Object)"Start time should be positive.");
            this.zzNY = timeUnit.toMillis(time);
            return this;
        }

        public Builder setEndTime(long time, TimeUnit timeUnit) {
            zzx.zza((time >= 0L ? 1 : 0) != 0, (Object)"End time should be positive.");
            this.zzapN = timeUnit.toMillis(time);
            return this;
        }

        public Builder setName(String name) {
            zzx.zzb((name.length() <= 100 ? 1 : 0) != 0, (String)"Session name cannot exceed %d characters", (Object[])new Object[]{100});
            this.mName = name;
            return this;
        }

        public Builder setIdentifier(String identifier) {
            zzx.zzaa((identifier != null && TextUtils.getTrimmedLength((CharSequence)identifier) > 0 ? 1 : 0) != 0);
            this.zzaqY = identifier;
            return this;
        }

        public Builder setDescription(String description) {
            zzx.zzb((description.length() <= 1000 ? 1 : 0) != 0, (String)"Session description cannot exceed %d characters", (Object[])new Object[]{1000});
            this.zzaqZ = description;
            return this;
        }

        public Builder setActivity(String activity) {
            return this.zzeH(FitnessActivities.zzcO(activity));
        }

        public Builder zzeH(int n) {
            this.zzapX = n;
            return this;
        }

        public Builder setActiveTime(long time, TimeUnit timeUnit) {
            this.zzara = timeUnit.toMillis(time);
            return this;
        }

        public Session build() {
            zzx.zza((this.zzNY > 0L ? 1 : 0) != 0, (Object)"Start time should be specified.");
            zzx.zza((this.zzapN == 0L || this.zzapN > this.zzNY ? 1 : 0) != 0, (Object)"End time should be later than start time.");
            if (this.zzaqY == null) {
                this.zzaqY = (this.mName == null ? "" : this.mName) + this.zzNY;
            }
            return new Session(this);
        }
    }
}

