/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.zzr;

public class Subscription
implements SafeParcelable {
    private final int mVersionCode;
    private final DataSource zzapM;
    private final DataType zzapL;
    private final long zzarc;
    private final int zzard;
    public static final Parcelable.Creator<Subscription> CREATOR = new zzr();

    Subscription(int versionCode, DataSource dataSource, DataType dataType, long samplingIntervalMicros, int accuracyMode) {
        this.mVersionCode = versionCode;
        this.zzapM = dataSource;
        this.zzapL = dataType;
        this.zzarc = samplingIntervalMicros;
        this.zzard = accuracyMode;
    }

    private Subscription(zza builder) {
        this.mVersionCode = 1;
        this.zzapL = builder.zzapL;
        this.zzapM = builder.zzapM;
        this.zzarc = builder.zzarc;
        this.zzard = builder.zzard;
    }

    public DataSource getDataSource() {
        return this.zzapM;
    }

    public DataType getDataType() {
        return this.zzapL;
    }

    public int getAccuracyMode() {
        return this.zzard;
    }

    public long zzsB() {
        return this.zzarc;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof Subscription && this.zza((Subscription)that);
    }

    private boolean zza(Subscription subscription) {
        return zzw.equal((Object)this.zzapM, (Object)subscription.zzapM) && zzw.equal((Object)this.zzapL, (Object)subscription.zzapL) && this.zzarc == subscription.zzarc && this.zzard == subscription.zzard;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzapM, this.zzapM, this.zzarc, this.zzard});
    }

    public String toString() {
        return zzw.zzv((Object)this).zzg("dataSource", (Object)this.zzapM).zzg("dataType", (Object)this.zzapL).zzg("samplingIntervalMicros", (Object)this.zzarc).zzg("accuracyMode", (Object)this.zzard).toString();
    }

    public String toDebugString() {
        return String.format("Subscription{%s}", this.zzapM == null ? this.zzapL.getName() : this.zzapM.toDebugString());
    }

    public DataType zzsC() {
        return this.zzapL == null ? this.zzapM.getDataType() : this.zzapL;
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzr.zza(this, dest, flags);
    }

    public static class zza {
        private DataSource zzapM;
        private DataType zzapL;
        private long zzarc = -1L;
        private int zzard = 2;

        public zza zzb(DataSource dataSource) {
            this.zzapM = dataSource;
            return this;
        }

        public zza zzb(DataType dataType) {
            this.zzapL = dataType;
            return this;
        }

        public Subscription zzsD() {
            zzx.zza((this.zzapM != null || this.zzapL != null ? 1 : 0) != 0, (Object)"Must call setDataSource() or setDataType()");
            zzx.zza((this.zzapL == null || this.zzapM == null || this.zzapL.equals(this.zzapM.getDataType()) ? 1 : 0) != 0, (Object)"Specified data type is incompatible with specified data source");
            return new Subscription(this);
        }
    }
}

