/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.FitnessActivities;
import com.google.android.gms.fitness.data.MapValue;
import com.google.android.gms.fitness.data.zzt;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public final class Value
implements SafeParcelable {
    private final int mVersionCode;
    private final int zzaqO;
    private boolean zzare;
    private float zzaqS;
    private String zzarf;
    private Map<String, MapValue> zzarg;
    private int[] zzarh;
    private float[] zzari;
    public static final Parcelable.Creator<Value> CREATOR = new zzt();

    public Value(int format) {
        this(3, format, false, 0.0f, null, null, null, null);
    }

    Value(int versionCode, int format, boolean isSet, float value, String stringValue, Bundle mapValue, int[] intArrayValue, float[] floatArrayValue) {
        this.mVersionCode = versionCode;
        this.zzaqO = format;
        this.zzare = isSet;
        this.zzaqS = value;
        this.zzarf = stringValue;
        this.zzarg = Value.zzs(mapValue);
        this.zzarh = intArrayValue;
        this.zzari = floatArrayValue;
    }

    public void setInt(int value) {
        zzx.zza((this.zzaqO == 1 ? 1 : 0) != 0, (Object)"Attempting to set an int value to a field that is not in INT32 format.  Please check the data type definition and use the right format.");
        this.zzare = true;
        this.zzaqS = Float.intBitsToFloat(value);
    }

    public void setFloat(float value) {
        zzx.zza((this.zzaqO == 2 ? 1 : 0) != 0, (Object)"Attempting to set an float value to a field that is not in FLOAT format.  Please check the data type definition and use the right format.");
        this.zzare = true;
        this.zzaqS = value;
    }

    public void setString(String value) {
        zzx.zza((this.zzaqO == 3 ? 1 : 0) != 0, (Object)"Attempting to set a string value to a field that is not in STRING format.  Please check the data type definition and use the right format.");
        this.zzare = true;
        this.zzarf = value;
    }

    public void setKeyValue(String key, float value) {
        zzx.zza((this.zzaqO == 4 ? 1 : 0) != 0, (Object)"Attempting to set a key's value to a field that is not in FLOAT_MAP format.  Please check the data type definition and use the right format.");
        this.zzare = true;
        if (this.zzarg == null) {
            this.zzarg = new HashMap<String, MapValue>();
        }
        this.zzarg.put(key, MapValue.zzc(value));
    }

    public void clearKey(String key) {
        zzx.zza((this.zzaqO == 4 ? 1 : 0) != 0, (Object)"Attempting to set a key's value to a field that is not in FLOAT_MAP format.  Please check the data type definition and use the right format.");
        if (this.zzarg != null) {
            this.zzarg.remove(key);
        }
    }

    public void setActivity(String activity) {
        this.setInt(FitnessActivities.zzcO(activity));
    }

    public boolean isSet() {
        return this.zzare;
    }

    public int getFormat() {
        return this.zzaqO;
    }

    public int asInt() {
        zzx.zza((this.zzaqO == 1 ? 1 : 0) != 0, (Object)"Value is not in int format");
        return Float.floatToRawIntBits(this.zzaqS);
    }

    public float asFloat() {
        zzx.zza((this.zzaqO == 2 ? 1 : 0) != 0, (Object)"Value is not in float format");
        return this.zzaqS;
    }

    public String asString() {
        zzx.zza((this.zzaqO == 3 ? 1 : 0) != 0, (Object)"Value is not in string format");
        return this.zzarf;
    }

    public Float getKeyValue(String key) {
        zzx.zza((this.zzaqO == 4 ? 1 : 0) != 0, (Object)"Value is not in float map format");
        if (this.zzarg != null && this.zzarg.containsKey(key)) {
            return Float.valueOf(this.zzarg.get(key).asFloat());
        }
        return null;
    }

    public int[] zzsE() {
        zzx.zza((this.zzaqO == 5 ? 1 : 0) != 0, (Object)"Value is not in int list format");
        return this.zzarh;
    }

    public float[] zzsF() {
        zzx.zza((this.zzaqO == 6 ? 1 : 0) != 0, (Object)"Value is not in float list format");
        return this.zzari;
    }

    public Map<String, MapValue> zzrH() {
        zzx.zza((this.zzaqO == 4 ? 1 : 0) != 0, (Object)"Value is not in float map format");
        return this.zzarg == null ? Collections.emptyMap() : this.zzarg;
    }

    public String asActivity() {
        return FitnessActivities.getName(this.asInt());
    }

    public boolean equals(Object o) {
        return this == o || o instanceof Value && this.zza((Value)o);
    }

    private boolean zza(Value value) {
        if (this.zzaqO == value.zzaqO && this.zzare == value.zzare) {
            switch (this.zzaqO) {
                case 1: {
                    return this.asInt() == value.asInt();
                }
                case 2: {
                    return this.asFloat() == value.asFloat();
                }
                case 3: {
                    return this.asString().equals(value.asString());
                }
                case 4: {
                    return this.zzrH().equals(value.zzrH());
                }
                case 5: {
                    return this.zzsE().equals(value.zzsE());
                }
                case 6: {
                    return this.zzsF().equals(value.zzsF());
                }
            }
            return this.zzaqS == value.zzaqS;
        }
        return false;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{Float.valueOf(this.zzaqS), this.zzarf, this.zzarg, this.zzarh, this.zzari});
    }

    public String toString() {
        if (!this.zzare) {
            return "unset";
        }
        switch (this.zzaqO) {
            case 1: {
                return Integer.toString(this.asInt());
            }
            case 2: {
                return Float.toString(this.asFloat());
            }
            case 3: {
                return this.zzarf;
            }
            case 4: {
                return new TreeMap<String, MapValue>(this.zzarg).toString();
            }
            case 5: {
                return this.zzsE().toString();
            }
            case 6: {
                return this.zzsF().toString();
            }
        }
        return "unknown";
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    float zzsy() {
        return this.zzaqS;
    }

    String zzsG() {
        return this.zzarf;
    }

    Bundle zzsH() {
        if (this.zzarg == null) {
            return null;
        }
        Bundle bundle = new Bundle(this.zzarg.size());
        for (Map.Entry<String, MapValue> entry : this.zzarg.entrySet()) {
            bundle.putParcelable(entry.getKey(), (Parcelable)entry.getValue());
        }
        return bundle;
    }

    int[] zzsI() {
        return this.zzarh;
    }

    float[] zzsJ() {
        return this.zzari;
    }

    private static Map<String, MapValue> zzs(Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        bundle.setClassLoader(MapValue.class.getClassLoader());
        ArrayMap arrayMap = new ArrayMap(bundle.size());
        for (String string : bundle.keySet()) {
            arrayMap.put(string, bundle.getParcelable(string));
        }
        return arrayMap;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzt.zza(this, dest, flags);
    }
}

