/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.Bucket;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Device;
import com.google.android.gms.fitness.request.zzf;
import com.google.android.gms.internal.zznu;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class DataReadRequest
implements SafeParcelable {
    public static final int NO_LIMIT = 0;
    private final int mVersionCode;
    private final List<DataType> zzapW;
    private final List<DataSource> zzasd;
    private final long zzNY;
    private final long zzapN;
    private final List<DataType> zzasi;
    private final List<DataSource> zzasj;
    private final int zzapZ;
    private final long zzask;
    private final DataSource zzasl;
    private final int zzasm;
    private final boolean zzasn;
    private final boolean zzaso;
    private final zznu zzasp;
    private final List<Device> zzasq;
    public static final Parcelable.Creator<DataReadRequest> CREATOR = new zzf();

    DataReadRequest(int versionCode, List<DataType> dataTypes, List<DataSource> dataSources, long startTimeMillis, long endTimeMillis, List<DataType> aggregatedDataTypes, List<DataSource> aggregatedDataSources, int bucketType, long bucketDurationMillis, DataSource activityDataSource, int limit, boolean flushBeforeRead, boolean serverQueriesEnabled, IBinder callback, List<Device> filteredDevices) {
        this.mVersionCode = versionCode;
        this.zzapW = dataTypes;
        this.zzasd = dataSources;
        this.zzNY = startTimeMillis;
        this.zzapN = endTimeMillis;
        this.zzasi = aggregatedDataTypes;
        this.zzasj = aggregatedDataSources;
        this.zzapZ = bucketType;
        this.zzask = bucketDurationMillis;
        this.zzasl = activityDataSource;
        this.zzasm = limit;
        this.zzasn = flushBeforeRead;
        this.zzaso = serverQueriesEnabled;
        this.zzasp = callback == null ? null : zznu.zza.zzbu(callback);
        this.zzasq = filteredDevices == null ? Collections.EMPTY_LIST : filteredDevices;
    }

    private DataReadRequest(Builder builder) {
        this(builder.zzapW, builder.zzasd, builder.zzNY, builder.zzapN, builder.zzasi, builder.zzasj, builder.zzapZ, builder.zzask, builder.zzasl, builder.zzasm, builder.zzasn, builder.zzaso, null, builder.zzasq);
    }

    public DataReadRequest(DataReadRequest request, zznu callback) {
        this(request.zzapW, request.zzasd, request.zzNY, request.zzapN, request.zzasi, request.zzasj, request.zzapZ, request.zzask, request.zzasl, request.zzasm, request.zzasn, request.zzaso, callback, request.zzasq);
    }

    public DataReadRequest(List<DataType> dataTypes, List<DataSource> dataSources, long startTimeMillis, long endTimeMillis, List<DataType> aggregatedDataTypes, List<DataSource> aggregatedDataSources, int bucketType, long bucketDurationMillis, DataSource activityDataSource, int limit, boolean flushBeforeRead, boolean serverQueriesEnabled, zznu callback, List<Device> filteredDevices) {
        this(5, dataTypes, dataSources, startTimeMillis, endTimeMillis, aggregatedDataTypes, aggregatedDataSources, bucketType, bucketDurationMillis, activityDataSource, limit, flushBeforeRead, serverQueriesEnabled, callback == null ? null : callback.asBinder(), filteredDevices);
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzNY, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzapN, TimeUnit.MILLISECONDS);
    }

    public List<DataType> getDataTypes() {
        return this.zzapW;
    }

    public List<DataSource> getDataSources() {
        return this.zzasd;
    }

    public List<DataType> getAggregatedDataTypes() {
        return this.zzasi;
    }

    public List<DataSource> getAggregatedDataSources() {
        return this.zzasj;
    }

    public int getBucketType() {
        return this.zzapZ;
    }

    public long getBucketDuration(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzask, TimeUnit.MILLISECONDS);
    }

    public DataSource getActivityDataSource() {
        return this.zzasl;
    }

    public int getLimit() {
        return this.zzasm;
    }

    public boolean zzsT() {
        return this.zzaso;
    }

    public boolean zzsU() {
        return this.zzasn;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof DataReadRequest && this.zzb((DataReadRequest)that);
    }

    private boolean zzb(DataReadRequest dataReadRequest) {
        return this.zzapW.equals(dataReadRequest.zzapW) && this.zzasd.equals(dataReadRequest.zzasd) && this.zzNY == dataReadRequest.zzNY && this.zzapN == dataReadRequest.zzapN && this.zzapZ == dataReadRequest.zzapZ && this.zzasj.equals(dataReadRequest.zzasj) && this.zzasi.equals(dataReadRequest.zzasi) && zzw.equal((Object)this.zzasl, (Object)dataReadRequest.zzasl) && this.zzask == dataReadRequest.zzask && this.zzaso == dataReadRequest.zzaso;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzapZ, this.zzNY, this.zzapN});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DataReadRequest{");
        if (!this.zzapW.isEmpty()) {
            for (DataType object : this.zzapW) {
                stringBuilder.append(object.zzst()).append(" ");
            }
        }
        if (!this.zzasd.isEmpty()) {
            for (DataSource dataSource : this.zzasd) {
                stringBuilder.append(dataSource.toDebugString()).append(" ");
            }
        }
        if (this.zzapZ != 0) {
            stringBuilder.append("bucket by ").append(Bucket.zzeu(this.zzapZ));
            if (this.zzask > 0L) {
                stringBuilder.append(" >").append(this.zzask).append("ms");
            }
            stringBuilder.append(": ");
        }
        if (!this.zzasi.isEmpty()) {
            for (DataType dataType : this.zzasi) {
                stringBuilder.append(dataType.zzst()).append(" ");
            }
        }
        if (!this.zzasj.isEmpty()) {
            for (DataSource dataSource : this.zzasj) {
                stringBuilder.append(dataSource.toDebugString()).append(" ");
            }
        }
        stringBuilder.append(String.format("(%tF %tT - %tF %tT)", this.zzNY, this.zzNY, this.zzapN, this.zzapN));
        if (this.zzasl != null) {
            stringBuilder.append("activities: ").append(this.zzasl.toDebugString());
        }
        if (this.zzaso) {
            stringBuilder.append(" +server");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public long zzsi() {
        return this.zzapN;
    }

    public long zzkX() {
        return this.zzNY;
    }

    public long zzsV() {
        return this.zzask;
    }

    public IBinder zzsO() {
        return this.zzasp == null ? null : this.zzasp.asBinder();
    }

    public List<Device> zzsW() {
        return this.zzasq;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzf.zza(this, dest, flags);
    }

    public static class Builder {
        private List<DataType> zzapW = new ArrayList<DataType>();
        private List<DataSource> zzasd = new ArrayList<DataSource>();
        private List<DataType> zzasi = new ArrayList<DataType>();
        private List<DataSource> zzasj = new ArrayList<DataSource>();
        private DataSource zzasl;
        private long zzNY;
        private long zzapN;
        private int zzapZ = 0;
        private long zzask = 0L;
        private int zzasm = 0;
        private boolean zzasn = false;
        private boolean zzaso = false;
        private List<Device> zzasq = new ArrayList<Device>();

        public Builder read(DataSource dataSource) {
            zzx.zzb((Object)dataSource, (Object)"Attempting to add a null data source");
            zzx.zzb((!this.zzasj.contains(dataSource) ? 1 : 0) != 0, (Object)"Cannot add the same data source as aggregated and detailed");
            if (!this.zzasd.contains(dataSource)) {
                this.zzasd.add(dataSource);
            }
            return this;
        }

        public Builder read(DataType dataType) {
            zzx.zzb((Object)dataType, (Object)"Attempting to use a null data type");
            zzx.zza((!this.zzasi.contains(dataType) ? 1 : 0) != 0, (Object)"Cannot add the same data type as aggregated and detailed");
            if (!this.zzapW.contains(dataType)) {
                this.zzapW.add(dataType);
            }
            return this;
        }

        public Builder aggregate(DataSource dataSource, DataType outputDataType) {
            zzx.zzb((Object)dataSource, (Object)"Attempting to add a null data source");
            zzx.zza((!this.zzasd.contains(dataSource) ? 1 : 0) != 0, (Object)"Cannot add the same data source for aggregated and detailed");
            DataType dataType = dataSource.getDataType();
            zzx.zzb((boolean)DataType.AGGREGATE_INPUT_TYPES.contains(dataType), (String)"Unsupported input data type specified for aggregation: %s", (Object[])new Object[]{dataType});
            zzx.zzb((boolean)DataType.getAggregatesForInput(dataType).contains(outputDataType), (String)"Invalid output aggregate data type specified: %s -> %s", (Object[])new Object[]{dataType, outputDataType});
            if (!this.zzasj.contains(dataSource)) {
                this.zzasj.add(dataSource);
            }
            return this;
        }

        public Builder aggregate(DataType inputDataType, DataType outputDataType) {
            zzx.zzb((Object)inputDataType, (Object)"Attempting to use a null data type");
            zzx.zza((!this.zzapW.contains(inputDataType) ? 1 : 0) != 0, (Object)"Cannot add the same data type as aggregated and detailed");
            zzx.zzb((boolean)DataType.AGGREGATE_INPUT_TYPES.contains(inputDataType), (String)"Unsupported input data type specified for aggregation: %s", (Object[])new Object[]{inputDataType});
            zzx.zzb((boolean)DataType.getAggregatesForInput(inputDataType).contains(outputDataType), (String)"Invalid output aggregate data type specified: %s -> %s", (Object[])new Object[]{inputDataType, outputDataType});
            if (!this.zzasi.contains(inputDataType)) {
                this.zzasi.add(inputDataType);
            }
            return this;
        }

        public Builder bucketByTime(int duration, TimeUnit timeUnit) {
            zzx.zzb((this.zzapZ == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzapZ});
            zzx.zzb((duration > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{duration});
            this.zzapZ = 1;
            this.zzask = timeUnit.toMillis(duration);
            return this;
        }

        public Builder bucketByActivityType(int minDuration, TimeUnit timeUnit) {
            zzx.zzb((this.zzapZ == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzapZ});
            zzx.zzb((minDuration > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{minDuration});
            this.zzapZ = 3;
            this.zzask = timeUnit.toMillis(minDuration);
            return this;
        }

        public Builder bucketByActivityType(int minDuration, TimeUnit timeUnit, DataSource activityDataSource) {
            zzx.zzb((this.zzapZ == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzapZ});
            zzx.zzb((minDuration > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{minDuration});
            zzx.zzb((activityDataSource != null ? 1 : 0) != 0, (Object)"Invalid activity data source specified");
            zzx.zzb((boolean)activityDataSource.getDataType().equals(DataType.TYPE_ACTIVITY_SEGMENT), (String)"Invalid activity data source specified: %s", (Object[])new Object[]{activityDataSource});
            this.zzasl = activityDataSource;
            this.zzapZ = 3;
            this.zzask = timeUnit.toMillis(minDuration);
            return this;
        }

        public Builder bucketByActivitySegment(int minDuration, TimeUnit timeUnit) {
            zzx.zzb((this.zzapZ == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzapZ});
            zzx.zzb((minDuration > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{minDuration});
            this.zzapZ = 4;
            this.zzask = timeUnit.toMillis(minDuration);
            return this;
        }

        public Builder bucketByActivitySegment(int minDuration, TimeUnit timeUnit, DataSource activityDataSource) {
            zzx.zzb((this.zzapZ == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzapZ});
            zzx.zzb((minDuration > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{minDuration});
            zzx.zzb((activityDataSource != null ? 1 : 0) != 0, (Object)"Invalid activity data source specified");
            zzx.zzb((boolean)activityDataSource.getDataType().equals(DataType.TYPE_ACTIVITY_SEGMENT), (String)"Invalid activity data source specified: %s", (Object[])new Object[]{activityDataSource});
            this.zzasl = activityDataSource;
            this.zzapZ = 4;
            this.zzask = timeUnit.toMillis(minDuration);
            return this;
        }

        public Builder bucketBySession(int minDuration, TimeUnit timeUnit) {
            zzx.zzb((this.zzapZ == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzapZ});
            zzx.zzb((minDuration > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{minDuration});
            this.zzapZ = 2;
            this.zzask = timeUnit.toMillis(minDuration);
            return this;
        }

        public Builder setTimeRange(long start, long end, TimeUnit timeUnit) {
            this.zzNY = timeUnit.toMillis(start);
            this.zzapN = timeUnit.toMillis(end);
            return this;
        }

        public Builder enableServerQueries() {
            this.zzaso = true;
            return this;
        }

        public Builder setLimit(int limit) {
            zzx.zzb((limit > 0 ? 1 : 0) != 0, (String)"Invalid limit %d is specified", (Object[])new Object[]{limit});
            this.zzasm = limit;
            return this;
        }

        public DataReadRequest build() {
            zzx.zza((!this.zzasd.isEmpty() || !this.zzapW.isEmpty() || !this.zzasj.isEmpty() || !this.zzasi.isEmpty() ? 1 : 0) != 0, (Object)"Must add at least one data source (aggregated or detailed)");
            zzx.zza((this.zzNY > 0L ? 1 : 0) != 0, (String)"Invalid start time: %s", (Object[])new Object[]{this.zzNY});
            zzx.zza((this.zzapN > 0L && this.zzapN > this.zzNY ? 1 : 0) != 0, (String)"Invalid end time: %s", (Object[])new Object[]{this.zzapN});
            boolean bl = this.zzasj.isEmpty() && this.zzasi.isEmpty();
            zzx.zza((bl && this.zzapZ == 0 || !bl && this.zzapZ != 0 ? 1 : 0) != 0, (Object)"Must specify a valid bucketing strategy while requesting aggregation");
            return new DataReadRequest(this);
        }
    }
}

