/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.service;

import android.app.AppOpsManager;
import android.app.Service;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.internal.service.FitnessDataSourcesRequest;
import com.google.android.gms.fitness.internal.service.FitnessUnregistrationRequest;
import com.google.android.gms.fitness.internal.service.zzc;
import com.google.android.gms.fitness.result.DataSourcesResult;
import com.google.android.gms.fitness.service.FitnessSensorServiceRequest;
import com.google.android.gms.internal.zzmx;
import com.google.android.gms.internal.zznv;
import com.google.android.gms.internal.zzoj;
import java.util.List;

public abstract class FitnessSensorService
extends Service {
    public static final String SERVICE_INTERFACE = "com.google.android.gms.fitness.service.FitnessSensorService";
    private zza zzatn;

    public void onCreate() {
        super.onCreate();
        this.zzatn = new zza(this);
    }

    public IBinder onBind(Intent intent) {
        if (SERVICE_INTERFACE.equals(intent.getAction())) {
            if (Log.isLoggable((String)"FitnessSensorService", (int)3)) {
                Log.d((String)"FitnessSensorService", (String)("Intent " + intent + " received by " + ((Object)((Object)this)).getClass().getName()));
            }
            return this.zzatn.asBinder();
        }
        return null;
    }

    public abstract List<DataSource> onFindDataSources(List<DataType> var1);

    public abstract boolean onRegister(FitnessSensorServiceRequest var1);

    public abstract boolean onUnregister(DataSource var1);

    protected void zztv() throws SecurityException {
        int n = Binder.getCallingUid();
        String string = "com.google.android.gms";
        if (zzmx.zzqB()) {
            AppOpsManager appOpsManager = (AppOpsManager)this.getSystemService("appops");
            appOpsManager.checkPackage(n, "com.google.android.gms");
            return;
        }
        PackageManager packageManager = this.getPackageManager();
        String[] stringArray = packageManager.getPackagesForUid(n);
        if (stringArray != null) {
            for (String string2 : stringArray) {
                if (!string2.equals("com.google.android.gms")) continue;
                return;
            }
        }
        throw new SecurityException("Unauthorized caller");
    }

    private static class zza
    extends zzc.zza {
        private final FitnessSensorService zzato;

        private zza(FitnessSensorService fitnessSensorService) {
            this.zzato = fitnessSensorService;
        }

        @Override
        public void zza(FitnessDataSourcesRequest fitnessDataSourcesRequest, zznv zznv2) throws RemoteException {
            this.zzato.zztv();
            List<DataSource> list = this.zzato.onFindDataSources(fitnessDataSourcesRequest.getDataTypes());
            zznv2.zza(new DataSourcesResult(list, Status.zzabb));
        }

        @Override
        public void zza(FitnessSensorServiceRequest fitnessSensorServiceRequest, zzoj zzoj2) throws RemoteException {
            this.zzato.zztv();
            if (this.zzato.onRegister(fitnessSensorServiceRequest)) {
                zzoj2.zzo(Status.zzabb);
            } else {
                zzoj2.zzo(new Status(13));
            }
        }

        @Override
        public void zza(FitnessUnregistrationRequest fitnessUnregistrationRequest, zzoj zzoj2) throws RemoteException {
            this.zzato.zztv();
            if (this.zzato.onUnregister(fitnessUnregistrationRequest.getDataSource())) {
                zzoj2.zzo(Status.zzabb);
            } else {
                zzoj2.zzo(new Status(13));
            }
        }
    }
}

