/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.fitness.FitnessActivities;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawBucket;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.data.zzc;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class Bucket
implements SafeParcelable {
    public static final int TYPE_TIME = 1;
    public static final int TYPE_SESSION = 2;
    public static final int TYPE_ACTIVITY_TYPE = 3;
    public static final int TYPE_ACTIVITY_SEGMENT = 4;
    private final int mVersionCode;
    private final long zzQj;
    private final long zzatQ;
    private final Session zzatS;
    private final int zzaua;
    private final List<DataSet> zzaub;
    private final int zzauc;
    private boolean zzaud = false;
    public static final Parcelable.Creator<Bucket> CREATOR = new zzc();

    Bucket(int versionCode, long startTimeMillis, long endTimeMillis, Session session, int activityType, List<DataSet> dataSets, int bucketType, boolean serverHasMoreData) {
        this.mVersionCode = versionCode;
        this.zzQj = startTimeMillis;
        this.zzatQ = endTimeMillis;
        this.zzatS = session;
        this.zzaua = activityType;
        this.zzaub = dataSets;
        this.zzauc = bucketType;
        this.zzaud = serverHasMoreData;
    }

    public Bucket(RawBucket bucket, List<DataSource> uniqueDataSources) {
        this(2, bucket.zzQj, bucket.zzatQ, bucket.zzatS, bucket.zzauW, Bucket.zza(bucket.zzaub, uniqueDataSources), bucket.zzauc, bucket.zzaud);
    }

    private static List<DataSet> zza(Collection<RawDataSet> collection, List<DataSource> list) {
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>(collection.size());
        for (RawDataSet rawDataSet : collection) {
            arrayList.add(new DataSet(rawDataSet, list));
        }
        return arrayList;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzQj, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzatQ, TimeUnit.MILLISECONDS);
    }

    public Session getSession() {
        return this.zzatS;
    }

    public String getActivity() {
        return FitnessActivities.getName(this.zzaua);
    }

    public int zztz() {
        return this.zzaua;
    }

    public List<DataSet> getDataSets() {
        return this.zzaub;
    }

    public DataSet getDataSet(DataType dataType) {
        for (DataSet dataSet : this.zzaub) {
            if (!dataSet.getDataType().equals(dataType)) continue;
            return dataSet;
        }
        return null;
    }

    public int getBucketType() {
        return this.zzauc;
    }

    public boolean equals(Object o) {
        return o == this || o instanceof Bucket && this.zza((Bucket)o);
    }

    private boolean zza(Bucket bucket) {
        return this.zzQj == bucket.zzQj && this.zzatQ == bucket.zzatQ && this.zzaua == bucket.zzaua && zzw.equal(this.zzaub, bucket.zzaub) && this.zzauc == bucket.zzauc && this.zzaud == bucket.zzaud;
    }

    public boolean zzb(Bucket bucket) {
        return this.zzQj == bucket.zzQj && this.zzatQ == bucket.zzatQ && this.zzaua == bucket.zzaua && this.zzauc == bucket.zzauc;
    }

    public boolean zztA() {
        if (this.zzaud) {
            return true;
        }
        for (DataSet dataSet : this.zzaub) {
            if (!dataSet.zztA()) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzQj, this.zzatQ, this.zzaua, this.zzauc});
    }

    public String toString() {
        return zzw.zzx((Object)this).zzg("startTime", (Object)this.zzQj).zzg("endTime", (Object)this.zzatQ).zzg("activity", (Object)this.zzaua).zzg("dataSets", this.zzaub).zzg("bucketType", (Object)Bucket.zzeI(this.zzauc)).zzg("serverHasMoreData", (Object)this.zzaud).toString();
    }

    public static String zzeI(int n) {
        switch (n) {
            case 1: {
                return "time";
            }
            case 3: {
                return "type";
            }
            case 4: {
                return "segment";
            }
            case 2: {
                return "session";
            }
            case 0: {
                return "unknown";
            }
        }
        return "bug";
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public long zzlx() {
        return this.zzQj;
    }

    public long zztB() {
        return this.zzatQ;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzc.zza(this, dest, flags);
    }
}

