/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawDataPoint;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.data.zze;
import com.google.android.gms.internal.zzop;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class DataSet
implements SafeParcelable {
    private final int mVersionCode;
    private final DataSource zzatP;
    private final DataType zzatO;
    private final List<DataPoint> zzauk;
    private final List<DataSource> zzaul;
    private boolean zzaud = false;
    public static final Parcelable.Creator<DataSet> CREATOR = new zze();

    DataSet(int versionCode, DataSource dataSource, DataType dataType, List<RawDataPoint> dataPoints, List<DataSource> uniqueDataSources, boolean serverHasMoreData) {
        this.mVersionCode = versionCode;
        this.zzatP = dataSource;
        this.zzatO = dataSource.getDataType();
        this.zzaud = serverHasMoreData;
        this.zzauk = new ArrayList<DataPoint>(dataPoints.size());
        this.zzaul = versionCode >= 2 ? uniqueDataSources : Collections.singletonList(dataSource);
        for (RawDataPoint rawDataPoint : dataPoints) {
            this.zzauk.add(new DataPoint(this.zzaul, rawDataPoint));
        }
    }

    public DataSet(DataSource dataSource) {
        this.mVersionCode = 3;
        this.zzatP = (DataSource)zzx.zzy((Object)dataSource);
        this.zzatO = dataSource.getDataType();
        this.zzauk = new ArrayList<DataPoint>();
        this.zzaul = new ArrayList<DataSource>();
        this.zzaul.add(this.zzatP);
    }

    public DataSet(RawDataSet dataSet, List<DataSource> uniqueDataSources) {
        this.mVersionCode = 3;
        this.zzatP = DataSet.zzb(uniqueDataSources, dataSet.zzauX);
        this.zzatO = this.zzatP.getDataType();
        this.zzaul = uniqueDataSources;
        this.zzaud = dataSet.zzaud;
        List<RawDataPoint> list = dataSet.zzava;
        this.zzauk = new ArrayList<DataPoint>(list.size());
        for (RawDataPoint rawDataPoint : list) {
            this.zzauk.add(new DataPoint(this.zzaul, rawDataPoint));
        }
    }

    private static <T> T zzb(List<T> list, int n) {
        return n >= 0 && n < list.size() ? (T)list.get(n) : null;
    }

    public static DataSet create(DataSource dataSource) {
        zzx.zzb((Object)dataSource, (Object)"DataSource should be specified");
        return new DataSet(dataSource);
    }

    public DataPoint createDataPoint() {
        return DataPoint.create(this.zzatP);
    }

    public void add(DataPoint dataPoint) {
        DataSource dataSource = dataPoint.getDataSource();
        zzx.zzb((boolean)dataSource.getStreamIdentifier().equals(this.zzatP.getStreamIdentifier()), (String)"Conflicting data sources found %s vs %s", (Object[])new Object[]{dataSource, this.zzatP});
        dataPoint.zztG();
        String string = zzop.zzd(dataPoint);
        if (string == null) {
            this.zzb(dataPoint);
        } else {
            Log.w((String)"Fitness", (String)("Ignoring invalid datapoint (Will be an exception in the next release): " + dataPoint), (Throwable)new IllegalArgumentException(string));
        }
    }

    public void zzb(DataPoint dataPoint) {
        this.zzauk.add(dataPoint);
        DataSource dataSource = dataPoint.getOriginalDataSource();
        if (dataSource != null && !this.zzaul.contains(dataSource)) {
            this.zzaul.add(dataSource);
        }
    }

    public void addAll(Iterable<DataPoint> dataPoints) {
        for (DataPoint dataPoint : dataPoints) {
            this.add(dataPoint);
        }
    }

    public void zzb(Iterable<DataPoint> iterable) {
        for (DataPoint dataPoint : iterable) {
            this.zzb(dataPoint);
        }
    }

    public DataSource getDataSource() {
        return this.zzatP;
    }

    public DataType getDataType() {
        return this.zzatP.getDataType();
    }

    public List<DataPoint> getDataPoints() {
        return Collections.unmodifiableList(this.zzauk);
    }

    public boolean isEmpty() {
        return this.zzauk.isEmpty();
    }

    public boolean zztA() {
        return this.zzaud;
    }

    public boolean equals(Object o) {
        return o == this || o instanceof DataSet && this.zza((DataSet)o);
    }

    private boolean zza(DataSet dataSet) {
        return zzw.equal((Object)this.getDataType(), (Object)dataSet.getDataType()) && zzw.equal((Object)this.zzatP, (Object)dataSet.zzatP) && zzw.equal(this.zzauk, dataSet.zzauk) && this.zzaud == dataSet.zzaud;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzatP});
    }

    public String toString() {
        List<RawDataPoint> list = this.zztI();
        return String.format("DataSet{%s %s}", this.zzatP.toDebugString(), this.zzauk.size() < 10 ? list : String.format("%d data points, first 5: %s", this.zzauk.size(), list.subList(0, 5)));
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    List<RawDataPoint> zztI() {
        return this.zzt(this.zzaul);
    }

    List<RawDataPoint> zzt(List<DataSource> list) {
        ArrayList<RawDataPoint> arrayList = new ArrayList<RawDataPoint>(this.zzauk.size());
        for (DataPoint dataPoint : this.zzauk) {
            arrayList.add(new RawDataPoint(dataPoint, list));
        }
        return arrayList;
    }

    List<DataSource> zztJ() {
        return this.zzaul;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zze.zza(this, parcel, flags);
    }
}

