/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.Context;
import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.zzc;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.Application;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Device;
import com.google.android.gms.fitness.data.zzf;

public class DataSource
implements SafeParcelable {
    public static final String EXTRA_DATA_SOURCE = "vnd.google.fitness.data_source";
    public static final int TYPE_RAW = 0;
    public static final int TYPE_DERIVED = 1;
    private final int mVersionCode;
    private final DataType zzatO;
    private final String mName;
    private final int zzZU;
    private final Device zzaum;
    private final Application zzaun;
    private final String zzauo;
    private final String zzaup;
    public static final Parcelable.Creator<DataSource> CREATOR = new zzf();

    DataSource(int versionCode, DataType dataType, String name, int type, Device device, Application application, String streamName) {
        this.mVersionCode = versionCode;
        this.zzatO = dataType;
        this.zzZU = type;
        this.mName = name;
        this.zzaum = device;
        this.zzaun = application;
        this.zzauo = streamName;
        this.zzaup = this.zztL();
    }

    private DataSource(Builder builder) {
        this.mVersionCode = 3;
        this.zzatO = builder.zzatO;
        this.zzZU = builder.zzZU;
        this.mName = builder.mName;
        this.zzaum = builder.zzaum;
        this.zzaun = builder.zzaun;
        this.zzauo = builder.zzauo;
        this.zzaup = this.zztL();
    }

    public static DataSource extract(Intent intent) {
        if (intent == null) {
            return null;
        }
        return (DataSource)zzc.zza((Intent)intent, (String)EXTRA_DATA_SOURCE, CREATOR);
    }

    public DataType getDataType() {
        return this.zzatO;
    }

    public int getType() {
        return this.zzZU;
    }

    public String getName() {
        return this.mName;
    }

    public String getAppPackageName() {
        return this.zzaun == null ? null : this.zzaun.getPackageName();
    }

    public Application zztK() {
        return this.zzaun;
    }

    public Device getDevice() {
        return this.zzaum;
    }

    public String getStreamName() {
        return this.zzauo;
    }

    public String getStreamIdentifier() {
        return this.zzaup;
    }

    private String zztL() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getTypeString());
        stringBuilder.append(":").append(this.zzatO.getName());
        if (this.zzaun != null) {
            stringBuilder.append(":").append(this.zzaun.getPackageName());
        }
        if (this.zzaum != null) {
            stringBuilder.append(":").append(this.zzaum.getStreamIdentifier());
        }
        if (this.zzauo != null) {
            stringBuilder.append(":").append(this.zzauo);
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object that) {
        return this == that || that instanceof DataSource && this.zza((DataSource)that);
    }

    private boolean zza(DataSource dataSource) {
        return this.zzaup.equals(dataSource.zzaup);
    }

    public int hashCode() {
        return this.zzaup.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("DataSource{");
        stringBuilder.append(this.getTypeString());
        if (this.mName != null) {
            stringBuilder.append(":").append(this.mName);
        }
        if (this.zzaun != null) {
            stringBuilder.append(":").append(this.zzaun);
        }
        if (this.zzaum != null) {
            stringBuilder.append(":").append(this.zzaum);
        }
        if (this.zzauo != null) {
            stringBuilder.append(":").append(this.zzauo);
        }
        stringBuilder.append(":").append(this.zzatO);
        return stringBuilder.append("}").toString();
    }

    public String toDebugString() {
        return (this.zzZU == 0 ? "r" : "d") + ":" + this.zzatO.zztM() + (this.zzaun == null ? "" : (this.zzaun.equals(Application.zzatV) ? ":gms" : ":" + this.zzaun.getPackageName())) + (this.zzaum != null ? ":" + this.zzaum.getModel() + ":" + this.zzaum.getUid() : "") + (this.zzauo != null ? ":" + this.zzauo : "");
    }

    private String getTypeString() {
        switch (this.zzZU) {
            case 0: {
                return "raw";
            }
            case 1: {
                return "derived";
            }
        }
        throw new IllegalArgumentException("invalid type value");
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zzf.zza(this, parcel, flags);
    }

    public static final class Builder {
        private DataType zzatO;
        private int zzZU = -1;
        private String mName;
        private Device zzaum;
        private Application zzaun;
        private String zzauo = "";

        public Builder setDataType(DataType dataType) {
            this.zzatO = dataType;
            return this;
        }

        public Builder setType(int type) {
            this.zzZU = type;
            return this;
        }

        public Builder setName(String name) {
            this.mName = name;
            return this;
        }

        public Builder setDevice(Device device) {
            this.zzaum = device;
            return this;
        }

        public Builder setAppPackageName(String packageName) {
            this.zzaun = Application.zzde(packageName);
            return this;
        }

        public Builder setAppPackageName(Context appContext) {
            return this.setAppPackageName(appContext.getPackageName());
        }

        public Builder setStreamName(String streamName) {
            zzx.zzb((streamName != null ? 1 : 0) != 0, (Object)"Must specify a valid stream name");
            this.zzauo = streamName;
            return this;
        }

        public DataSource build() {
            zzx.zza((this.zzatO != null ? 1 : 0) != 0, (Object)"Must set data type");
            zzx.zza((this.zzZU >= 0 ? 1 : 0) != 0, (Object)"Must set data source type");
            return new DataSource(this);
        }
    }
}

