/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.fitness.data.Bucket;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.data.zzm;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class RawBucket
implements SafeParcelable {
    final int mVersionCode;
    public final long zzQj;
    public final long zzatQ;
    public final Session zzatS;
    public final int zzauW;
    public final List<RawDataSet> zzaub;
    public final int zzauc;
    public final boolean zzaud;
    public static final Parcelable.Creator<RawBucket> CREATOR = new zzm();

    public RawBucket(int versionCode, long startTimeMillis, long endTimeMillis, Session session, int activity, List<RawDataSet> dataSets, int bucketType, boolean serverHasMoreData) {
        this.mVersionCode = versionCode;
        this.zzQj = startTimeMillis;
        this.zzatQ = endTimeMillis;
        this.zzatS = session;
        this.zzauW = activity;
        this.zzaub = dataSets;
        this.zzauc = bucketType;
        this.zzaud = serverHasMoreData;
    }

    public RawBucket(Bucket bucket, List<DataSource> uniqueDataSources, List<DataType> uniqueDataTypes) {
        this.mVersionCode = 2;
        this.zzQj = bucket.getStartTime(TimeUnit.MILLISECONDS);
        this.zzatQ = bucket.getEndTime(TimeUnit.MILLISECONDS);
        this.zzatS = bucket.getSession();
        this.zzauW = bucket.zztz();
        this.zzauc = bucket.getBucketType();
        this.zzaud = bucket.zztA();
        List<DataSet> list = bucket.getDataSets();
        this.zzaub = new ArrayList<RawDataSet>(list.size());
        for (DataSet dataSet : list) {
            this.zzaub.add(new RawDataSet(dataSet, uniqueDataSources, uniqueDataTypes));
        }
    }

    public boolean equals(Object o) {
        return this == o || o instanceof RawBucket && this.zza((RawBucket)o);
    }

    private boolean zza(RawBucket rawBucket) {
        return this.zzQj == rawBucket.zzQj && this.zzatQ == rawBucket.zzatQ && this.zzauW == rawBucket.zzauW && zzw.equal(this.zzaub, rawBucket.zzaub) && this.zzauc == rawBucket.zzauc && this.zzaud == rawBucket.zzaud;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzQj, this.zzatQ, this.zzauc});
    }

    public String toString() {
        return zzw.zzx((Object)this).zzg("startTime", (Object)this.zzQj).zzg("endTime", (Object)this.zzatQ).zzg("activity", (Object)this.zzauW).zzg("dataSets", this.zzaub).zzg("bucketType", (Object)this.zzauc).zzg("serverHasMoreData", (Object)this.zzaud).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zzm.zza(this, parcel, flags);
    }
}

